/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.glsl;

import com.sun.opengl.util.glsl.ShaderCode;
import com.sun.opengl.util.glsl.ShaderUtil;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLException;

public class ShaderProgram {
    protected boolean programLinked = false;
    protected boolean programInUse = false;
    protected int shaderProgram = -1;
    protected HashMap shaderMap = new HashMap();
    protected Integer id = ShaderProgram.getNextID();
    protected static int nextID = 1;

    public boolean linked() {
        return this.programLinked;
    }

    public boolean inUse() {
        return this.programInUse;
    }

    public int program() {
        return this.shaderProgram;
    }

    public int id() {
        return this.id;
    }

    public Integer key() {
        return this.id;
    }

    public synchronized void destroy(GL2ES2 gL2ES2) {
        this.release(gL2ES2, true);
    }

    public synchronized void release(GL2ES2 gL2ES2) {
        this.release(gL2ES2, false);
    }

    public synchronized void release(GL2ES2 gL2ES2, boolean bl) {
        this.glUseProgram(gL2ES2, false);
        Iterator iterator = this.shaderMap.values().iterator();
        while (iterator.hasNext()) {
            ShaderCode shaderCode = (ShaderCode)iterator.next();
            ShaderUtil.detachShader(gL2ES2, this.shaderProgram, shaderCode.shader());
            if (!bl) continue;
            shaderCode.destroy(gL2ES2);
        }
        this.shaderMap.clear();
        gL2ES2.glDeleteProgram(this.shaderProgram);
        this.shaderProgram = -1;
    }

    public synchronized boolean add(ShaderCode shaderCode) {
        if (this.shaderMap.containsKey(shaderCode.key())) {
            return false;
        }
        this.shaderMap.put(shaderCode.key(), shaderCode);
        return true;
    }

    public synchronized ShaderCode getShader(int n) {
        return (ShaderCode)this.shaderMap.get(new Integer(n));
    }

    public synchronized boolean glReplaceShader(GL2ES2 gL2ES2, int n, ShaderCode shaderCode, PrintStream printStream) {
        ShaderCode shaderCode2;
        if (!this.programLinked) {
            throw new GLException("Program is not linked");
        }
        boolean bl = this.programInUse;
        this.glUseProgram(gL2ES2, false);
        if (!shaderCode.compile(gL2ES2, printStream)) {
            return false;
        }
        if (n >= 0 && null != (shaderCode2 = (ShaderCode)this.shaderMap.remove(new Integer(n)))) {
            ShaderUtil.detachShader(gL2ES2, this.shaderProgram, shaderCode2.shader());
        }
        this.add(shaderCode);
        ShaderUtil.attachShader(gL2ES2, this.shaderProgram, shaderCode.shader());
        gL2ES2.glLinkProgram(this.shaderProgram);
        if (!ShaderUtil.isProgramValid(gL2ES2, this.shaderProgram, System.err)) {
            return false;
        }
        if (bl) {
            this.glUseProgram(gL2ES2, true);
        }
        return true;
    }

    public synchronized boolean link(GL2ES2 gL2ES2, PrintStream printStream) {
        if (this.programLinked) {
            throw new GLException("Program is already linked");
        }
        if (0 > this.shaderProgram) {
            this.shaderProgram = gL2ES2.glCreateProgram();
        }
        Iterator iterator = this.shaderMap.values().iterator();
        while (iterator.hasNext()) {
            ShaderCode shaderCode = (ShaderCode)iterator.next();
            if (!shaderCode.compile(gL2ES2, printStream)) {
                return false;
            }
            ShaderUtil.attachShader(gL2ES2, this.shaderProgram, shaderCode.shader());
        }
        gL2ES2.glLinkProgram(this.shaderProgram);
        this.programLinked = ShaderUtil.isProgramValid(gL2ES2, this.shaderProgram, System.err);
        return this.programLinked;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ShaderCode) {
            return this.id() == ((ShaderCode)object).id();
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ShaderProgram[id=" + this.id);
        stringBuffer.append(", linked=" + this.programLinked + ", inUse=" + this.programInUse + ", program: " + this.shaderProgram + ", [");
        Iterator iterator = this.shaderMap.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((ShaderCode)iterator.next());
            stringBuffer.append(" ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected synchronized void glUseProgram(GL2ES2 gL2ES2, boolean bl) {
        if (!this.programLinked) {
            throw new GLException("Program is not linked");
        }
        if (this.programInUse == bl) {
            return;
        }
        gL2ES2.glUseProgram(bl ? this.shaderProgram : 0);
        this.programInUse = bl;
    }

    private static synchronized Integer getNextID() {
        return new Integer(nextID++);
    }
}

