/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.api;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Time
implements Comparable<Time> {
    public final long timeValue;
    public final int timeScale;
    private final double second;
    private final int hashCode;

    public Time(long timeValue, int timeScale) {
        this.timeValue = timeValue;
        this.timeScale = timeScale;
        this.second = (double)timeValue / (double)timeScale;
        this.hashCode = (int)(timeValue * 1000L / (long)timeScale);
    }

    public static Time fromFrameNumber(long frameNumber, Time frameDuration) {
        return new Time(frameNumber * frameDuration.timeValue, frameDuration.timeScale);
    }

    public long toFrameNumber(Time frameDuration) {
        if (this.timeScale == frameDuration.timeScale) {
            return (long)Math.floor((double)this.timeValue / (double)frameDuration.timeValue);
        }
        return (long)Math.floor(this.second / frameDuration.second);
    }

    public double toSecond() {
        return this.second;
    }

    public boolean before(Time o) {
        return this.compareTo(o) < 0;
    }

    public boolean after(Time o) {
        return this.compareTo(o) > 0;
    }

    @Override
    public int compareTo(Time o) {
        if (this.timeScale == o.timeScale) {
            long diff = this.timeValue - o.timeValue;
            return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
        }
        double diff = this.second - o.second;
        return diff > 0.0 ? 1 : (diff < 0.0 ? -1 : 0);
    }

    public Time add(Time addend) {
        if (addend.timeScale == this.timeScale) {
            return new Time(this.timeValue + addend.timeValue, this.timeScale);
        }
        return new Time((long)Math.floor((this.second + addend.second) * (double)this.timeScale), this.timeScale);
    }

    public Time subtract(Time subtrahend) {
        if (subtrahend.timeScale == this.timeScale) {
            return new Time(this.timeValue - subtrahend.timeValue, this.timeScale);
        }
        return new Time((long)Math.floor((this.second - subtrahend.second) * (double)this.timeScale), this.timeScale);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((Time)obj) == 0;
    }

    public String toString() {
        return String.valueOf(this.second);
    }
}

