/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.api;

public final class Vec2d {
    public static final Vec2d ZERO = new Vec2d(0.0, 0.0);
    public static final Vec2d POSITIVE_INFINITY = new Vec2d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Vec2d NEGATIVE_INFINITY = new Vec2d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    public final double x;
    public final double y;

    public Vec2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vec2d other = (Vec2d)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public String toString() {
        return "Vec2d [x=" + this.x + ", y=" + this.y + "]";
    }

    public static Vec2d min(Vec2d a, Vec2d b) {
        return new Vec2d(Math.min(a.x, b.x), Math.min(a.y, b.y));
    }

    public static Vec2d max(Vec2d a, Vec2d b) {
        return new Vec2d(Math.max(a.x, b.x), Math.max(a.y, b.y));
    }
}

