/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.PlanAnalyzer;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.CategoryElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IProfileChooser;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.LicenseManager;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.PlanValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.QueryProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class ProfileModificationAction
extends ProvisioningAction {
    public static final int ACTION_NOT_RUN = -1;
    String profileId;
    String userChosenProfileId;
    Policy policy;
    int result = -1;
    static /* synthetic */ Class class$0;

    protected ProfileModificationAction(Policy policy, String text, ISelectionProvider selectionProvider, String profileId) {
        super(text, selectionProvider);
        this.policy = policy;
        this.profileId = profileId;
        this.init();
    }

    public void run() {
        IInstallableUnit[] ius = this.getSelectedIUs();
        String id = this.getProfileId(true);
        if (id == null || ius.length == 0) {
            ProvUI.reportStatus(this.getNoProfileOrSelectionStatus(this.profileId, ius), 4);
            this.runCanceled();
            return;
        }
        this.run(ius, id);
    }

    protected IStatus getNoProfileOrSelectionStatus(String id, IInstallableUnit[] ius) {
        return new Status(2, "org.eclipse.equinox.p2.ui", NLS.bind((String)ProvUIMessages.ProfileModificationAction_InvalidSelections, (Object)id, (Object)new Integer(ius.length)));
    }

    protected void run(final IInstallableUnit[] ius, final String id) {
        final MultiStatus additionalStatus = this.getProfileChangeAlteredStatus();
        final ProfileChangeRequest[] request = new ProfileChangeRequest[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                request[0] = ProfileModificationAction.this.getProfileChangeRequest(ius, id, additionalStatus, (IProgressMonitor)new NullProgressMonitor());
            }
        });
        if (request[0] == null) {
            Status failureStatus;
            if (additionalStatus.getChildren().length > 0) {
                if (additionalStatus.getChildren().length == 1) {
                    failureStatus = additionalStatus.getChildren()[0];
                } else {
                    MultiStatus nullRequestStatus = new MultiStatus("org.eclipse.equinox.p2.ui", 10050, additionalStatus.getChildren(), ProvUIMessages.ProfileModificationAction_NoChangeRequestProvided, null);
                    nullRequestStatus.addAll((IStatus)additionalStatus);
                    failureStatus = nullRequestStatus;
                }
            } else {
                failureStatus = new Status(4, "org.eclipse.equinox.p2.ui", ProvUIMessages.ProfileModificationAction_NoExplanationProvided);
            }
            ProvUI.reportStatus((IStatus)failureStatus, 3);
            this.runCanceled();
            return;
        }
        final PlannerResolutionOperation operation = new PlannerResolutionOperation(ProvUIMessages.ProfileModificationAction_ResolutionOperationLabel, id, request[0], null, additionalStatus, this.isResolveUserVisible());
        this.result = 0;
        Job job = ProvisioningOperationRunner.schedule(operation, 2);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ProvisioningPlan plan = operation.getProvisioningPlan();
                if (plan != null && PlatformUI.isWorkbenchRunning()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this, plan, ius, operation){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ ProvisioningPlan val$plan;
                        private final /* synthetic */ IInstallableUnit[] val$ius;
                        private final /* synthetic */ PlannerResolutionOperation val$operation;
                        {
                            this.this$1 = var1_1;
                            this.val$plan = provisioningPlan;
                            this.val$ius = iInstallableUnitArray;
                            this.val$operation = plannerResolutionOperation;
                        }

                        public void run() {
                            if (2.access$0(this.this$1).validatePlan(this.val$plan)) {
                                2.access$0(this.this$1).performAction(this.val$ius, 2.access$0(this.this$1).getProfileId(true), this.val$operation);
                            }
                            2.access$0(this.this$1).userChosenProfileId = null;
                        }
                    });
                }
            }

            static /* synthetic */ ProfileModificationAction access$0(2 var0) {
                return var0.ProfileModificationAction.this;
            }
        });
    }

    public int getReturnCode() {
        return this.result;
    }

    protected boolean validatePlan(ProvisioningPlan plan) {
        if (plan != null) {
            if (plan.getStatus().getSeverity() == 8) {
                return false;
            }
            if (this.getPlanValidator() != null) {
                return this.getPlanValidator().continueWorkingWithPlan(plan, this.getShell());
            }
            if (plan.getStatus().isOK()) {
                return true;
            }
            ProvUI.reportStatus(plan.getStatus(), 5);
            return false;
        }
        return false;
    }

    protected abstract ProfileChangeRequest getProfileChangeRequest(IInstallableUnit[] var1, String var2, MultiStatus var3, IProgressMonitor var4);

    protected abstract int performAction(IInstallableUnit[] var1, String var2, PlannerResolutionOperation var3);

    protected abstract String getTaskName();

    protected IInstallableUnit getIU(Object element) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IInstallableUnit)ProvUI.getAdapter(element, clazz);
    }

    protected IInstallableUnit[] getSelectedIUs() {
        List elements = this.getStructuredSelection().toList();
        ArrayList<IInstallableUnit> iusList = new ArrayList<IInstallableUnit>(elements.size());
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i) instanceof IIUElement) {
                IIUElement element = (IIUElement)elements.get(i);
                if (this.isSelectable(element)) {
                    iusList.add(this.getIU(element));
                }
            } else {
                IInstallableUnit iu;
                Object e = elements.get(i);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iu = (IInstallableUnit)ProvUI.getAdapter(e, clazz)) != null && this.isSelectable(iu)) {
                    iusList.add(iu);
                }
            }
            ++i;
        }
        return iusList.toArray(new IInstallableUnit[iusList.size()]);
    }

    protected boolean isSelectable(IIUElement element) {
        return !(element instanceof CategoryElement);
    }

    protected boolean isSelectable(IInstallableUnit iu) {
        return !ProvisioningUtil.isCategory(iu);
    }

    protected LicenseManager getLicenseManager() {
        return this.policy.getLicenseManager();
    }

    protected QueryProvider getQueryProvider() {
        return this.policy.getQueryProvider();
    }

    protected PlanValidator getPlanValidator() {
        return this.policy.getPlanValidator();
    }

    protected IProfileChooser getProfileChooser() {
        return this.policy.getProfileChooser();
    }

    protected Policy getPolicy() {
        return this.policy;
    }

    protected final void checkEnablement(Object[] selections) {
        if (this.isEnabledFor(selections)) {
            String id = this.getProfileId(false);
            if (id == null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(!ProvisioningOperationRunner.hasScheduledOperationsFor(id));
            }
        } else {
            this.setEnabled(false);
        }
    }

    protected abstract boolean isEnabledFor(Object[] var1);

    protected int getLock(IProfile profile, IInstallableUnit iu) {
        if (profile == null) {
            return 0;
        }
        try {
            String value = profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.lock");
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return 0;
    }

    protected String getProfileProperty(IProfile profile, IInstallableUnit iu, String propertyName) {
        if (profile == null || iu == null) {
            return null;
        }
        return profile.getInstallableUnitProperty(iu, propertyName);
    }

    protected IProfile getProfile(boolean chooseProfile) {
        String id;
        block3: {
            try {
                id = this.getProfileId(chooseProfile);
                if (id != null) break block3;
                return null;
            }
            catch (ProvisionException provisionException) {
                return null;
            }
        }
        return ProvisioningUtil.getProfile(id);
    }

    protected String getProfileId(boolean chooseProfile) {
        if (this.profileId != null) {
            return this.profileId;
        }
        if (this.userChosenProfileId != null) {
            return this.userChosenProfileId;
        }
        if (chooseProfile && this.getProfileChooser() != null) {
            this.userChosenProfileId = this.getProfileChooser().getProfileId(this.getShell());
            return this.userChosenProfileId;
        }
        return null;
    }

    private void runCanceled() {
        this.userChosenProfileId = null;
        this.result = 1;
    }

    protected MultiStatus getProfileChangeAlteredStatus() {
        return PlanAnalyzer.getProfileChangeAlteredStatus();
    }

    protected boolean isResolveUserVisible() {
        return true;
    }
}

