/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.generator.features;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ProductFile
extends DefaultHandler {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private static final String PROGRAM_ARGS = "programArgs";
    private static final String PROGRAM_ARGS_LINUX = "programArgsLin";
    private static final String PROGRAM_ARGS_MAC = "programArgsMac";
    private static final String PROGRAM_ARGS_SOLARIS = "programArgsSol";
    private static final String PROGRAM_ARGS_WIN = "programArgsWin";
    private static final String VM_ARGS = "vmArgs";
    private static final String VM_ARGS_LINUX = "vmArgsLin";
    private static final String VM_ARGS_MAC = "vmArgsMac";
    private static final String VM_ARGS_SOLARIS = "vmArgsSol";
    private static final String VM_ARGS_WIN = "vmArgsWin";
    private static final String SOLARIS_LARGE = "solarisLarge";
    private static final String SOLARIS_MEDIUM = "solarisMedium";
    private static final String SOLARIS_SMALL = "solarisSmall";
    private static final String SOLARIS_TINY = "solarisTiny";
    private static final String WIN32_16_LOW = "winSmallLow";
    private static final String WIN32_16_HIGH = "winSmallHigh";
    private static final String WIN32_24_LOW = "win24Low";
    private static final String WIN32_32_LOW = "winMediumLow";
    private static final String WIN32_32_HIGH = "winMediumHigh";
    private static final String WIN32_48_LOW = "winLargeLow";
    private static final String WIN32_48_HIGH = "winLargeHigh";
    private static final String OS_WIN32 = "win32";
    private static final String OS_LINUX = "linux";
    private static final String OS_SOLARIS = "solaris";
    private static final String OS_MACOSX = "macosx";
    private static final String PRODUCT = "product";
    private static final String CONFIG_INI = "configIni";
    private static final String LAUNCHER = "launcher";
    private static final String LAUNCHER_ARGS = "launcherArgs";
    private static final String PLUGINS = "plugins";
    private static final String FEATURES = "features";
    private static final String P_USE_ICO = "useIco";
    private static final int STATE_START = 0;
    private static final int STATE_PRODUCT = 1;
    private static final int STATE_LAUNCHER = 2;
    private static final int STATE_LAUNCHER_ARGS = 3;
    private static final int STATE_PLUGINS = 4;
    private static final int STATE_FEATURES = 5;
    private static final int STATE_PROGRAM_ARGS = 6;
    private static final int STATE_PROGRAM_ARGS_LINUX = 7;
    private static final int STATE_PROGRAM_ARGS_MAC = 8;
    private static final int STATE_PROGRAM_ARGS_SOLARIS = 9;
    private static final int STATE_PROGRAM_ARGS_WIN = 10;
    private static final int STATE_VM_ARGS = 11;
    private static final int STATE_VM_ARGS_LINUX = 12;
    private static final int STATE_VM_ARGS_MAC = 13;
    private static final int STATE_VM_ARGS_SOLARIS = 14;
    private static final int STATE_VM_ARGS_WIN = 15;
    private static final int STATE_CONFIG_INI = 16;
    private int state = 0;
    private final SAXParser parser;
    private String currentOS = null;
    private boolean useIco = false;
    private final ArrayList result = new ArrayList(6);
    private final Map platformSpecificConfigPaths = new HashMap();
    private String configPlatform = null;
    private String platformConfigPath = null;
    private String launcherName = null;
    private String id = null;
    private String uid = null;
    private boolean useFeatures = false;
    private List plugins = null;
    private List fragments = null;
    private List features = null;
    private String productName = null;
    private String version = null;
    private Properties launcherArgs = new Properties();

    private static String normalize(String text) {
        if (text == null || text.trim().length() == 0) {
            return "";
        }
        text = text.replaceAll("\\r|\\n|\\f|\\t", " ");
        return text.replaceAll("\\s+", " ");
    }

    public ProductFile(String location, String os) throws Exception {
        this.currentOS = os;
        parserFactory.setNamespaceAware(true);
        this.parser = parserFactory.newSAXParser();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));
        try {
            this.parser.parse(new InputSource(in), (DefaultHandler)this);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    public List getPlugins() {
        return this.getPlugins(true);
    }

    public List getPlugins(boolean includeFragments) {
        List p;
        List list = p = this.plugins != null ? this.plugins : Collections.EMPTY_LIST;
        if (!includeFragments) {
            return p;
        }
        List f = this.fragments != null ? this.fragments : Collections.EMPTY_LIST;
        int size = p.size() + f.size();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList both = new ArrayList(size);
        both.addAll(p);
        both.addAll(f);
        return both;
    }

    public List getFeatures() {
        if (this.features == null) {
            return Collections.EMPTY_LIST;
        }
        return this.features;
    }

    public String getId() {
        if (this.uid != null) {
            return this.uid;
        }
        return this.id;
    }

    public String getProductId() {
        return this.id;
    }

    public String getProductName() {
        return this.productName;
    }

    public boolean useFeatures() {
        return this.useFeatures;
    }

    public String getVersion() {
        return this.version == null || this.version.length() == 0 ? "0.0.0" : this.version;
    }

    public String getLauncherName() {
        return this.launcherName;
    }

    public String getVMArguments(String os) {
        String key = null;
        if (os.equals(OS_WIN32)) {
            key = VM_ARGS_WIN;
        } else if (os.equals(OS_LINUX)) {
            key = VM_ARGS_LINUX;
        } else if (os.equals(OS_MACOSX)) {
            key = VM_ARGS_MAC;
        } else if (os.equals(OS_SOLARIS)) {
            key = VM_ARGS_SOLARIS;
        }
        String prefix = this.launcherArgs.getProperty(VM_ARGS);
        String platform = null;
        String args = null;
        if (key != null) {
            platform = this.launcherArgs.getProperty(key);
        }
        args = prefix != null ? (platform != null ? String.valueOf(prefix) + " " + platform : prefix) : (platform != null ? platform : "");
        return ProductFile.normalize(args);
    }

    public String getProgramArguments(String os) {
        String key = null;
        if (os.equals(OS_WIN32)) {
            key = PROGRAM_ARGS_WIN;
        } else if (os.equals(OS_LINUX)) {
            key = PROGRAM_ARGS_LINUX;
        } else if (os.equals(OS_MACOSX)) {
            key = PROGRAM_ARGS_MAC;
        } else if (os.equals(OS_SOLARIS)) {
            key = PROGRAM_ARGS_SOLARIS;
        }
        String prefix = this.launcherArgs.getProperty(PROGRAM_ARGS);
        String platform = null;
        String args = null;
        if (key != null) {
            platform = this.launcherArgs.getProperty(key);
        }
        args = prefix != null ? (platform != null ? String.valueOf(prefix) + " " + platform : prefix) : (platform != null ? platform : "");
        return ProductFile.normalize(args);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        switch (this.state) {
            case 0: {
                if (!PRODUCT.equals(localName)) break;
                this.processProduct(attributes);
                this.state = 1;
                break;
            }
            case 1: {
                if (CONFIG_INI.equals(localName)) {
                    this.processConfigIni(attributes);
                    this.state = 16;
                    break;
                }
                if (LAUNCHER.equals(localName)) {
                    this.processLauncher(attributes);
                    this.state = 2;
                    break;
                }
                if (PLUGINS.equals(localName)) {
                    this.state = 4;
                    break;
                }
                if (FEATURES.equals(localName)) {
                    this.state = 5;
                    break;
                }
                if (!LAUNCHER_ARGS.equals(localName)) break;
                this.state = 3;
                break;
            }
            case 16: {
                this.processConfigIniPlatform(localName, true);
                break;
            }
            case 2: {
                if (OS_SOLARIS.equals(localName)) {
                    this.processSolaris(attributes);
                } else if ("win".equals(localName)) {
                    this.processWin(attributes);
                } else if (OS_LINUX.equals(localName)) {
                    this.processLinux(attributes);
                } else if (OS_MACOSX.equals(localName)) {
                    this.processMac(attributes);
                }
                if ("ico".equals(localName)) {
                    this.processIco(attributes);
                    break;
                }
                if (!"bmp".equals(localName)) break;
                this.processBmp(attributes);
                break;
            }
            case 3: {
                if (PROGRAM_ARGS.equals(localName)) {
                    this.state = 6;
                    break;
                }
                if (PROGRAM_ARGS_LINUX.equals(localName)) {
                    this.state = 7;
                    break;
                }
                if (PROGRAM_ARGS_MAC.equals(localName)) {
                    this.state = 8;
                    break;
                }
                if (PROGRAM_ARGS_SOLARIS.equals(localName)) {
                    this.state = 9;
                    break;
                }
                if (PROGRAM_ARGS_WIN.equals(localName)) {
                    this.state = 10;
                    break;
                }
                if (VM_ARGS.equals(localName)) {
                    this.state = 11;
                    break;
                }
                if (VM_ARGS_LINUX.equals(localName)) {
                    this.state = 12;
                    break;
                }
                if (VM_ARGS_MAC.equals(localName)) {
                    this.state = 13;
                    break;
                }
                if (VM_ARGS_SOLARIS.equals(localName)) {
                    this.state = 14;
                    break;
                }
                if (!VM_ARGS_WIN.equals(localName)) break;
                this.state = 15;
                break;
            }
            case 4: {
                if (!"plugin".equals(localName)) break;
                this.processPlugin(attributes);
                break;
            }
            case 5: {
                if (!"feature".equals(localName)) break;
                this.processFeature(attributes);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) {
        switch (this.state) {
            case 4: {
                if (!PLUGINS.equals(localName)) break;
                this.state = 1;
                break;
            }
            case 5: {
                if (!FEATURES.equals(localName)) break;
                this.state = 1;
                break;
            }
            case 3: {
                if (!LAUNCHER_ARGS.equals(localName)) break;
                this.state = 1;
                break;
            }
            case 2: {
                if (!LAUNCHER.equals(localName)) break;
                this.state = 1;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.state = 3;
                break;
            }
            case 16: {
                if (CONFIG_INI.equals(localName)) {
                    this.state = 1;
                    break;
                }
                this.processConfigIniPlatform(localName, false);
            }
        }
    }

    public void characters(char[] ch, int start, int length) {
        switch (this.state) {
            case 6: {
                this.addLaunchArgumentToMap(PROGRAM_ARGS, String.valueOf(ch, start, length));
                break;
            }
            case 7: {
                this.addLaunchArgumentToMap(PROGRAM_ARGS_LINUX, String.valueOf(ch, start, length));
                break;
            }
            case 8: {
                this.addLaunchArgumentToMap(PROGRAM_ARGS_MAC, String.valueOf(ch, start, length));
                break;
            }
            case 9: {
                this.addLaunchArgumentToMap(PROGRAM_ARGS_SOLARIS, String.valueOf(ch, start, length));
                break;
            }
            case 10: {
                this.addLaunchArgumentToMap(PROGRAM_ARGS_WIN, String.valueOf(ch, start, length));
                break;
            }
            case 11: {
                this.addLaunchArgumentToMap(VM_ARGS, String.valueOf(ch, start, length));
                break;
            }
            case 12: {
                this.addLaunchArgumentToMap(VM_ARGS_LINUX, String.valueOf(ch, start, length));
                break;
            }
            case 13: {
                this.addLaunchArgumentToMap(VM_ARGS_MAC, String.valueOf(ch, start, length));
                break;
            }
            case 14: {
                this.addLaunchArgumentToMap(VM_ARGS_SOLARIS, String.valueOf(ch, start, length));
                break;
            }
            case 15: {
                this.addLaunchArgumentToMap(VM_ARGS_WIN, String.valueOf(ch, start, length));
                break;
            }
            case 16: {
                if (this.platformConfigPath == null) break;
                this.platformConfigPath = String.valueOf(this.platformConfigPath) + String.valueOf(ch, start, length);
            }
        }
    }

    private void addLaunchArgumentToMap(String key, String value) {
        String oldValue;
        if (this.launcherArgs == null) {
            this.launcherArgs = new Properties();
        }
        if ((oldValue = this.launcherArgs.getProperty(key)) != null) {
            this.launcherArgs.setProperty(key, String.valueOf(oldValue) + value);
        } else {
            this.launcherArgs.setProperty(key, value);
        }
    }

    private void processPlugin(Attributes attributes) {
        String fragment = attributes.getValue("fragment");
        if (fragment != null && new Boolean(fragment).booleanValue()) {
            if (this.fragments == null) {
                this.fragments = new ArrayList();
            }
            this.fragments.add(attributes.getValue("id"));
        } else {
            if (this.plugins == null) {
                this.plugins = new ArrayList();
            }
            this.plugins.add(attributes.getValue("id"));
        }
    }

    private void processFeature(Attributes attributes) {
        if (this.features == null) {
            this.features = new ArrayList();
        }
        this.features.add(attributes.getValue("id"));
    }

    private void processProduct(Attributes attributes) {
        this.id = attributes.getValue("id");
        this.uid = attributes.getValue("uid");
        this.productName = attributes.getValue("name");
        String use = attributes.getValue("useFeatures");
        if (use != null) {
            this.useFeatures = Boolean.valueOf(use);
        }
        this.version = attributes.getValue("version");
    }

    private void processConfigIni(Attributes attributes) {
        String os;
        String path = null;
        if ("custom".equals(attributes.getValue("use"))) {
            path = attributes.getValue("path");
        }
        if ((os = attributes.getValue("os")) != null && os.length() > 0 && path != null) {
            this.platformSpecificConfigPaths.put(os, path);
        }
    }

    private void processConfigIniPlatform(String key, boolean begin) {
        if (begin) {
            this.configPlatform = key;
            this.platformConfigPath = "";
        } else if (this.configPlatform.equals(key) && this.platformConfigPath.length() > 0) {
            this.platformSpecificConfigPaths.put(key, this.platformConfigPath);
            this.platformConfigPath = null;
        }
    }

    private void processLauncher(Attributes attributes) {
        this.launcherName = attributes.getValue("name");
    }

    private boolean osMatch(String os) {
        if (os == this.currentOS) {
            return true;
        }
        if (os == null) {
            return false;
        }
        return os.equals(this.currentOS);
    }

    private void processSolaris(Attributes attributes) {
        if (!this.osMatch(OS_SOLARIS)) {
            return;
        }
        this.result.add(attributes.getValue(SOLARIS_LARGE));
        this.result.add(attributes.getValue(SOLARIS_MEDIUM));
        this.result.add(attributes.getValue(SOLARIS_SMALL));
        this.result.add(attributes.getValue(SOLARIS_TINY));
    }

    private void processWin(Attributes attributes) {
        if (!this.osMatch(OS_WIN32)) {
            return;
        }
        this.useIco = Boolean.valueOf(attributes.getValue(P_USE_ICO));
    }

    private void processIco(Attributes attributes) {
        if (!this.osMatch(OS_WIN32) || !this.useIco) {
            return;
        }
        this.result.add(attributes.getValue("path"));
    }

    private void processBmp(Attributes attributes) {
        if (!this.osMatch(OS_WIN32) || this.useIco) {
            return;
        }
        this.result.add(attributes.getValue(WIN32_16_HIGH));
        this.result.add(attributes.getValue(WIN32_16_LOW));
        this.result.add(attributes.getValue(WIN32_24_LOW));
        this.result.add(attributes.getValue(WIN32_32_HIGH));
        this.result.add(attributes.getValue(WIN32_32_LOW));
        this.result.add(attributes.getValue(WIN32_48_HIGH));
        this.result.add(attributes.getValue(WIN32_48_LOW));
    }

    private void processLinux(Attributes attributes) {
        if (!this.osMatch(OS_LINUX)) {
            return;
        }
        this.result.add(attributes.getValue("icon"));
    }

    private void processMac(Attributes attributes) {
        if (!this.osMatch(OS_MACOSX)) {
            return;
        }
        this.result.add(attributes.getValue("icon"));
    }
}

