/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects;

import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.BlendMode;
import ch.kuramo.javie.effects.VideoEffectUtil;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlendModeShaders {
    public static final String BLEND_FUNCTIONS = "ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions";
    private final IVideoEffectContext context;
    private final IShaderRegistry shaders;
    private final Class<?> shadersClass;
    private final Map<BlendMode, IShaderProgram> programs = new HashMap<BlendMode, IShaderProgram>();

    public static BlendModeShaders forPremult(IVideoEffectContext context, IShaderRegistry shaders) {
        return new BlendModeShaders(context, shaders, Premult.class);
    }

    public static BlendModeShaders forSrcUnmult(IVideoEffectContext context, IShaderRegistry shaders) {
        return new BlendModeShaders(context, shaders, SrcUnmult.class);
    }

    public BlendModeShaders(IVideoEffectContext context, IShaderRegistry shaders, Class<?> shadersClass) {
        this.context = context;
        this.shaders = shaders;
        this.shadersClass = shadersClass;
        BlendMode[] blendModeArray = BlendMode.values();
        int n = blendModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BlendMode blendMode = blendModeArray[n2];
            IShaderProgram program = shaders.getProgram(shadersClass, blendMode.name());
            if (program == null) {
                throw new IllegalArgumentException(String.format("no shader program found for BlendMode %s in class %s", blendMode.name(), shadersClass.getName()));
            }
            this.programs.put(blendMode, program);
            ++n2;
        }
    }

    public void replace(BlendMode blendMode, IShaderProgram program) {
        if (program == null) {
            program = this.shaders.getProgram(this.shadersClass, blendMode.name());
        }
        this.programs.put(blendMode, program);
    }

    public IVideoBuffer blend(IVideoBuffer src, IVideoBuffer dst, final BlendMode blendMode, final double opacity) {
        IVideoBuffer buffer = null;
        try {
            VideoBounds bounds = src.getBounds();
            buffer = this.context.createVideoBuffer(bounds);
            final GL2 gl = this.context.getGL().getGL2();
            final int w = bounds.width;
            final int h = bounds.height;
            VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
            gl.glFramebufferTexture2D(36160, 36064, 34037, buffer.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glPushAttrib(262144);
            try {
                if (blendMode != BlendMode.NONE) {
                    gl.glActiveTexture(33984);
                    gl.glBindTexture(34037, dst.getTexture());
                }
                gl.glActiveTexture(33985);
                gl.glBindTexture(34037, src.getTexture());
                final IShaderProgram program = this.programs.get((Object)blendMode);
                program.useProgram(new Runnable(){

                    public void run() {
                        if (blendMode != BlendMode.NONE) {
                            gl.glUniform1i(program.getUniformLocation("texDst"), 0);
                        }
                        gl.glUniform1i(program.getUniformLocation("texSrc"), 1);
                        gl.glUniform1f(program.getUniformLocation("opacity"), (float)opacity);
                        gl.glBegin(7);
                        gl.glTexCoord2f(0.0f, 0.0f);
                        gl.glVertex2f(0.0f, 0.0f);
                        gl.glTexCoord2f((float)w, 0.0f);
                        gl.glVertex2f((float)w, 0.0f);
                        gl.glTexCoord2f((float)w, (float)h);
                        gl.glVertex2f((float)w, (float)h);
                        gl.glTexCoord2f(0.0f, (float)h);
                        gl.glVertex2f(0.0f, (float)h);
                        gl.glEnd();
                    }
                });
            }
            finally {
                gl.glPopAttrib();
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            }
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    public static class Premult {
        @ShaderSource
        public static final String[] NONE = new String[]{"uniform sampler2DRect texSrc;", "uniform float opacity;", "", "void main(void)", "{", "\tvec4 src = texture2DRect(texSrc, gl_TexCoord[0].st);", "\tgl_FragColor = src * opacity;", "}"};
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] NORMAL = Premult.createSource("normal");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DARKEN = Premult.createSource("darken");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] MULTIPLY = Premult.createSource("multiply");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR_BURN = Premult.createSource("color_burn");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_BURN = Premult.createSource("linear_burn");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DARKER_COLOR = Premult.createSource("darker_color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] ADD = Premult.createSource("add");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LIGHTEN = Premult.createSource("lighten");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SCREEN = Premult.createSource("screen");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR_DODGE = Premult.createSource("color_dodge");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_DODGE = Premult.createSource("linear_dodge");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LIGHTER_COLOR = Premult.createSource("lighter_color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] OVERLAY = Premult.createSource("overlay");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SOFT_LIGHT = Premult.createSource("soft_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HARD_LIGHT = Premult.createSource("hard_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_LIGHT = Premult.createSource("linear_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] VIVID_LIGHT = Premult.createSource("vivid_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] PIN_LIGHT = Premult.createSource("pin_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HARD_MIX = Premult.createSource("hard_mix");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DIFFERENCE = Premult.createSource("difference");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] EXCLUSION = Premult.createSource("exclusion");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HUE = Premult.createSource("hue");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SATURATION = Premult.createSource("saturation");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR = Premult.createSource("color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LUMINOSITY = Premult.createSource("luminosity");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] STENCIL_ALPHA = Premult.createSource("stencil_alpha");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] STENCIL_LUMA = Premult.createSource("stencil_luma");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SILHOUETTE_ALPHA = Premult.createSource("silhouette_alpha");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SILHOUETTE_LUMA = Premult.createSource("silhouette_luma");

        private static String[] createSource(String name) {
            return new String[]{"uniform sampler2DRect texDst;", "uniform sampler2DRect texSrc;", "uniform float opacity;", "", String.format("vec4 blend_%s(vec4 pDst, vec4 pSrc, float opacity);", name), "", "void main(void)", "{", "\tvec2 texCoord = gl_TexCoord[0].st;", "\tvec4 dst = texture2DRect(texDst, texCoord);", "\tvec4 src = texture2DRect(texSrc, texCoord);", String.format("\tgl_FragColor = blend_%s(dst, src, opacity);", name), "}"};
        }
    }

    public static class SrcUnmult {
        @ShaderSource
        public static final String[] NONE = new String[]{"uniform sampler2DRect texSrc;", "uniform float opacity;", "", "void main(void)", "{", "\tvec4 src = texture2DRect(texSrc, gl_TexCoord[0].st);", "\tgl_FragColor = vec4(src.rgb*src.a, src.a) * opacity;", "}"};
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] NORMAL = SrcUnmult.createSource("normal");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DARKEN = SrcUnmult.createSource("darken");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] MULTIPLY = SrcUnmult.createSource("multiply");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR_BURN = SrcUnmult.createSource("color_burn");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_BURN = SrcUnmult.createSource("linear_burn");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DARKER_COLOR = SrcUnmult.createSource("darker_color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] ADD = SrcUnmult.createSource("add");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LIGHTEN = SrcUnmult.createSource("lighten");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SCREEN = SrcUnmult.createSource("screen");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR_DODGE = SrcUnmult.createSource("color_dodge");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_DODGE = SrcUnmult.createSource("linear_dodge");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LIGHTER_COLOR = SrcUnmult.createSource("lighter_color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] OVERLAY = SrcUnmult.createSource("overlay");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SOFT_LIGHT = SrcUnmult.createSource("soft_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HARD_LIGHT = SrcUnmult.createSource("hard_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_LIGHT = SrcUnmult.createSource("linear_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] VIVID_LIGHT = SrcUnmult.createSource("vivid_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] PIN_LIGHT = SrcUnmult.createSource("pin_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HARD_MIX = SrcUnmult.createSource("hard_mix");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DIFFERENCE = SrcUnmult.createSource("difference");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] EXCLUSION = SrcUnmult.createSource("exclusion");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HUE = SrcUnmult.createSource("hue");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SATURATION = SrcUnmult.createSource("saturation");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR = SrcUnmult.createSource("color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LUMINOSITY = SrcUnmult.createSource("luminosity");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] STENCIL_ALPHA = SrcUnmult.createSource("stencil_alpha");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] STENCIL_LUMA = SrcUnmult.createSource("stencil_luma");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SILHOUETTE_ALPHA = SrcUnmult.createSource("silhouette_alpha");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SILHOUETTE_LUMA = SrcUnmult.createSource("silhouette_luma");

        private static String[] createSource(String name) {
            return new String[]{"uniform sampler2DRect texDst;", "uniform sampler2DRect texSrc;", "uniform float opacity;", "", String.format("vec4 blend_%s(vec4 pDst, vec4 pSrc, float opacity);", name), "", "void main(void)", "{", "\tvec2 texCoord = gl_TexCoord[0].st;", "\tvec4 dst = texture2DRect(texDst, texCoord);", "\tvec4 src = texture2DRect(texSrc, texCoord);", String.format("\tgl_FragColor = blend_%s(dst, vec4(src.rgb*src.a, src.a), opacity);", name), "}"};
        }
    }
}

