/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.colorCorrection;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import com.google.inject.Inject;
import javax.media.opengl.GL2;

@Effect(id="ch.kuramo.javie.BrightnessAndContrast", category="ch.kuramo.javie.api.effectCategory.colorCorrection")
public class BrightnessAndContrast {
    @ShaderSource
    public static final String[] BRIGHTNESS_AND_CONTRAST = new String[]{"uniform sampler2DRect texture;", "uniform float brightness;", "uniform float contrastSlope;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tvec3 rgb = color.rgb/color.a;", "\trgb = (rgb+brightness-0.5)*contrastSlope+0.5;", "\tgl_FragColor = vec4(rgb*color.a, color.a);", "}"};
    @Property(min="-255", max="255")
    private IAnimatableDouble brightness;
    @Property(min="-100", max="100")
    private IAnimatableDouble contrast;
    private final IVideoEffectContext context;
    private final IShaderProgram program;

    @Inject
    public BrightnessAndContrast(IVideoEffectContext context, IShaderRegistry shaders) {
        this.context = context;
        this.program = shaders.getProgram(BrightnessAndContrast.class, "BRIGHTNESS_AND_CONTRAST");
    }

    public IVideoBuffer doVideoEffect() {
        final double brightness = (Double)this.context.value((IAnimatableValue)this.brightness);
        double contrast = (Double)this.context.value((IAnimatableValue)this.contrast);
        if (brightness == 0.0 && contrast == 0.0) {
            return null;
        }
        final double contrastSlope = contrast >= 0.0 ? 100.0 / (100.0 - contrast) : (100.0 + contrast) / 100.0;
        IVideoBuffer input = null;
        IVideoBuffer buffer = null;
        try {
            IVideoBuffer iVideoBuffer;
            input = this.context.doPreviousEffect();
            VideoBounds bounds = input.getBounds();
            if (bounds.isEmpty()) {
                IVideoBuffer output = input;
                input = null;
                IVideoBuffer iVideoBuffer2 = output;
                return iVideoBuffer2;
            }
            final GL2 gl = this.context.getGL().getGL2();
            gl.glPushAttrib(262145);
            try {
                final int w = bounds.width;
                final int h = bounds.height;
                VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
                buffer = this.context.createVideoBuffer(bounds);
                gl.glFramebufferTexture2D(36160, 36064, 34037, buffer.getTexture(), 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, input.getTexture());
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                this.program.useProgram(new Runnable(){

                    public void run() {
                        gl.glUniform1i(BrightnessAndContrast.this.program.getUniformLocation("texture"), 0);
                        gl.glUniform1f(BrightnessAndContrast.this.program.getUniformLocation("brightness"), (float)(brightness / 255.0));
                        gl.glUniform1f(BrightnessAndContrast.this.program.getUniformLocation("contrastSlope"), (float)contrastSlope);
                        gl.glBegin(7);
                        gl.glTexCoord2f(0.0f, 0.0f);
                        gl.glVertex2f(0.0f, 0.0f);
                        gl.glTexCoord2f((float)w, 0.0f);
                        gl.glVertex2f((float)w, 0.0f);
                        gl.glTexCoord2f((float)w, (float)h);
                        gl.glVertex2f((float)w, (float)h);
                        gl.glTexCoord2f(0.0f, (float)h);
                        gl.glVertex2f(0.0f, (float)h);
                        gl.glEnd();
                    }
                });
                IVideoBuffer output = buffer;
                buffer = null;
                iVideoBuffer = output;
            }
            catch (Throwable throwable) {
                gl.glPopAttrib();
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                throw throwable;
            }
            gl.glPopAttrib();
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            return iVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }
}

