/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.colorCorrection;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import com.google.inject.Inject;
import javax.media.opengl.GL2;

@Effect(id="ch.kuramo.javie.Monochrome", category="ch.kuramo.javie.api.effectCategory.colorCorrection")
public class Monochrome {
    @ShaderSource
    public static final String[] MONOCHROME = new String[]{"uniform sampler2DRect texture;", "uniform vec3 highlight;", "uniform vec3 shadow;", "uniform float blend;", "", "const vec3 yvec = vec3(0.299, 0.587, 0.114);", "", "void main(void)", "{", "\tvec4 src = texture2DRect(texture, gl_TexCoord[0].st);", "\tfloat y = (src.a != 0.0) ? dot(src.rgb/src.a, yvec) : 0.0;", "\tvec3 rgb = shadow*(1.0-y) + highlight*y;", "\tfloat a = src.a*(1.0-blend);", "\tgl_FragColor = src*blend + vec4(rgb*a, a);", "}"};
    @Property(value="1,1,1")
    private IAnimatableColor highlight;
    @Property(value="0,0,0")
    private IAnimatableColor shadow;
    @Property(min="0", max="100")
    private IAnimatableDouble blendWithOriginal;
    private final IVideoEffectContext context;
    private final IShaderProgram program;

    @Inject
    public Monochrome(IVideoEffectContext context, IShaderRegistry shaders) {
        this.context = context;
        this.program = shaders.getProgram(Monochrome.class, "MONOCHROME");
    }

    public IVideoBuffer doVideoEffect() {
        final double blend = (Double)this.context.value((IAnimatableValue)this.blendWithOriginal) / 100.0;
        if (blend == 1.0) {
            return null;
        }
        final Color highlight = (Color)this.context.value((IAnimatableValue)this.highlight);
        final Color shadow = (Color)this.context.value((IAnimatableValue)this.shadow);
        IVideoBuffer input = null;
        IVideoBuffer buffer = null;
        try {
            IVideoBuffer iVideoBuffer;
            input = this.context.doPreviousEffect();
            VideoBounds bounds = input.getBounds();
            if (bounds.isEmpty()) {
                IVideoBuffer output = input;
                input = null;
                IVideoBuffer iVideoBuffer2 = output;
                return iVideoBuffer2;
            }
            final GL2 gl = this.context.getGL().getGL2();
            gl.glPushAttrib(262145);
            try {
                final int w = bounds.width;
                final int h = bounds.height;
                VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
                buffer = this.context.createVideoBuffer(bounds);
                gl.glFramebufferTexture2D(36160, 36064, 34037, buffer.getTexture(), 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, input.getTexture());
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                this.program.useProgram(new Runnable(){

                    public void run() {
                        gl.glUniform1i(Monochrome.this.program.getUniformLocation("texture"), 0);
                        gl.glUniform3f(Monochrome.this.program.getUniformLocation("highlight"), (float)highlight.r, (float)highlight.g, (float)highlight.b);
                        gl.glUniform3f(Monochrome.this.program.getUniformLocation("shadow"), (float)shadow.r, (float)shadow.g, (float)shadow.b);
                        gl.glUniform1f(Monochrome.this.program.getUniformLocation("blend"), (float)blend);
                        gl.glBegin(7);
                        gl.glTexCoord2f(0.0f, 0.0f);
                        gl.glVertex2f(0.0f, 0.0f);
                        gl.glTexCoord2f((float)w, 0.0f);
                        gl.glVertex2f((float)w, 0.0f);
                        gl.glTexCoord2f((float)w, (float)h);
                        gl.glVertex2f((float)w, (float)h);
                        gl.glTexCoord2f(0.0f, (float)h);
                        gl.glVertex2f(0.0f, (float)h);
                        gl.glEnd();
                    }
                });
                IVideoBuffer output = buffer;
                buffer = null;
                iVideoBuffer = output;
            }
            catch (Throwable throwable) {
                gl.glPopAttrib();
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                throw throwable;
            }
            gl.glPopAttrib();
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            return iVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }
}

