/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.BlendMode;
import ch.kuramo.javie.effects.BlendModeShaders;
import ch.kuramo.javie.effects.VideoEffectUtil;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public abstract class AudioDrawing {
    private static volatile double maxSmoothThickness;
    protected final IVideoEffectContext context;
    protected final BlendModeShaders blendModeShaders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double getMaxSmoothThickness(GL2 gl) {
        double max = maxSmoothThickness;
        if (max != 0.0) return max;
        Class<AudioDrawing> clazz = AudioDrawing.class;
        synchronized (AudioDrawing.class) {
            max = maxSmoothThickness;
            if (max != 0.0) return max;
            float[] range = new float[2];
            gl.glGetFloatv(2850, range, 0);
            max = range[1];
            gl.glGetFloatv(2834, range, 0);
            maxSmoothThickness = max = Math.min(max, (double)range[1]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return max;
        }
    }

    protected AudioDrawing(IVideoEffectContext context, IShaderRegistry shaders) {
        this.context = context;
        this.blendModeShaders = BlendModeShaders.forSrcUnmult(context, shaders);
    }

    protected IVideoBuffer doDrawing(BlendMode blendMode, double opacity) {
        IVideoBuffer original = null;
        IVideoBuffer drawing = null;
        try {
            VideoBounds bounds;
            if (blendMode == BlendMode.NONE) {
                bounds = this.context.getPreviousBounds();
            } else {
                original = this.context.doPreviousEffect();
                bounds = original.getBounds();
            }
            if (bounds.isEmpty()) {
                IVideoBuffer result;
                if (original != null) {
                    result = original;
                    original = null;
                } else {
                    result = this.context.createVideoBuffer(bounds);
                }
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            GL2 gl = this.context.getGL().getGL2();
            GLU glu = this.context.getGLU();
            drawing = this.context.createVideoBuffer(bounds);
            VideoEffectUtil.clearTexture(drawing, gl);
            this.draw(drawing, gl, glu);
            IVideoBuffer iVideoBuffer = this.blendModeShaders.blend(drawing, original, blendMode, opacity);
            return iVideoBuffer;
        }
        finally {
            if (original != null) {
                original.dispose();
            }
            if (drawing != null) {
                drawing.dispose();
            }
        }
    }

    protected abstract void draw(IVideoBuffer var1, GL2 var2, GLU var3);

    protected void draw(DataProvider dataProvider, IVideoBuffer dst, Vec2d startPoint, Vec2d endPoint, double height, double thickness, Color color, Style style, boolean smoothing, GL2 gl, GLU glu) {
        if (smoothing) {
            thickness = Math.min(thickness, AudioDrawing.getMaxSmoothThickness(gl));
        }
        thickness = Math.max(1.0E-10, thickness);
        double dx = endPoint.x - startPoint.x;
        double dy = endPoint.y - startPoint.y;
        VideoBounds bounds = dst.getBounds();
        VideoEffectUtil.ortho2D(gl, glu, bounds.width, bounds.height);
        gl.glTranslatef((float)(-bounds.x), (float)(-bounds.y), 0.0f);
        gl.glTranslatef((float)startPoint.x, (float)startPoint.y, 0.0f);
        gl.glRotatef((float)Math.toDegrees(Math.atan2(dy, dx)), 0.0f, 0.0f, 1.0f);
        gl.glScalef((float)Math.sqrt(dx * dx + dy * dy), (float)height, 1.0f);
        gl.glFramebufferTexture2D(36160, 36064, 34037, dst.getTexture(), 0);
        gl.glDrawBuffer(36064);
        gl.glPushAttrib(57607);
        try {
            if (smoothing) {
                gl.glDisable(2929);
                gl.glEnable(2848);
                gl.glEnable(2832);
                gl.glHint(3154, 4354);
                gl.glHint(3153, 4354);
                gl.glEnable(3042);
                gl.glBlendFunc(1, 1);
                gl.glBlendEquation(32776);
            }
            gl.glLineWidth((float)thickness);
            gl.glPointSize((float)thickness);
            float a = (float)color.a;
            float r = (float)color.r * a;
            float g = (float)color.g * a;
            float b = (float)color.b * a;
            gl.glColor4f(r, g, b, a);
            int dataCount = dataProvider.getDataCount();
            switch (style) {
                case BARS: {
                    float adjustment = (float)(smoothing ? 0.0 : 1.0 / height);
                    gl.glBegin(1);
                    int i = 0;
                    while (i < dataCount) {
                        gl.glVertex2f((float)i / (float)(dataCount - 1), dataProvider.getDataLower(i));
                        gl.glVertex2f((float)i / (float)(dataCount - 1), dataProvider.getDataUpper(i) - adjustment);
                        ++i;
                    }
                    gl.glEnd();
                    if (smoothing) {
                        gl.glBegin(0);
                        i = 0;
                        while (i < dataCount) {
                            gl.glVertex2f((float)i / (float)(dataCount - 1), dataProvider.getDataLower(i));
                            gl.glVertex2f((float)i / (float)(dataCount - 1), dataProvider.getDataUpper(i) - adjustment);
                            ++i;
                        }
                        gl.glEnd();
                    }
                    break;
                }
                case LINES: {
                    gl.glBegin(3);
                    if (dataCount > 1) {
                        int i = 0;
                        while (i < dataCount) {
                            gl.glVertex2f((float)i / (float)(dataCount - 1), dataProvider.getData(i));
                            ++i;
                        }
                    } else {
                        float data = dataProvider.getData(0);
                        gl.glVertex2f(0.0f, data);
                        gl.glVertex2f(1.0f, data);
                    }
                    gl.glEnd();
                    if (!smoothing) break;
                }
                case DOTS: {
                    gl.glBegin(0);
                    if (dataCount > 1) {
                        int i = 0;
                        while (i < dataCount) {
                            gl.glVertex2f((float)i / (float)(dataCount - 1), dataProvider.getData(i));
                            ++i;
                        }
                    } else if (style == Style.LINES) {
                        float data = dataProvider.getData(0);
                        gl.glVertex2f(0.0f, data);
                        gl.glVertex2f(1.0f, data);
                    } else {
                        gl.glVertex2f(0.5f, dataProvider.getData(0));
                    }
                    gl.glEnd();
                }
                default: {
                    break;
                }
            }
        }
        finally {
            gl.glPopAttrib();
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Channel {
        MONO,
        LEFT,
        RIGHT;

    }

    protected static interface DataProvider {
        public int getDataCount();

        public float getDataLower(int var1);

        public float getDataUpper(int var1);

        public float getData(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        BARS,
        LINES,
        DOTS;

    }
}

