/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ca.uol.aig.fftpack.RealDoubleFFT;
import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.BlendMode;
import ch.kuramo.javie.effects.generate.AudioDrawing;
import com.google.inject.Inject;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Effect(id="ch.kuramo.javie.AudioSpectrum", category="ch.kuramo.javie.api.effectCategory.generate")
public class AudioSpectrum
extends AudioDrawing {
    @Property
    private IAnimatableLayerReference audioLayer;
    @Property
    private IAnimatableVec2d startPoint;
    @Property
    private IAnimatableVec2d endPoint;
    @Property(value="20", min="1", max="48000")
    private IAnimatableDouble startFrequency;
    @Property(value="2000", min="1", max="48000")
    private IAnimatableDouble endFrequency;
    @Property(value="64", min="1", max="4096")
    private IAnimatableInteger frequencyBands;
    @Property(value="120", min="1")
    private IAnimatableDouble height;
    @Property(value="90", min="0", max="30000")
    private IAnimatableDouble audioDuration;
    @Property(value="0", min="-30000", max="30000")
    private IAnimatableDouble audioOffset;
    @Property(value="3", min="0", max="100")
    private IAnimatableDouble thickness;
    @Property(value="0,1,0")
    private IAnimatableColor color;
    @Property(value="MONO")
    private IAnimatableEnum<AudioDrawing.Channel> channel;
    @Property(value="BARS")
    private IAnimatableEnum<AudioDrawing.Style> style;
    @Property(value="true")
    private IAnimatableBoolean smoothing;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableEnum<BlendMode> blendMode;
    private final IArrayPools arrayPools;

    @Inject
    public AudioSpectrum(IVideoEffectContext context, IShaderRegistry shaders, IArrayPools arrayPools) {
        super(context, shaders);
        this.arrayPools = arrayPools;
    }

    public IVideoBuffer doVideoEffect() {
        return this.doDrawing((BlendMode)((Object)this.context.value(this.blendMode)), (Double)this.context.value((IAnimatableValue)this.opacity) / 100.0);
    }

    @Override
    protected void draw(IVideoBuffer drawing, GL2 gl, GLU glu) {
        IAudioBuffer audio = null;
        IArray bands = null;
        try {
            Resolution resolution = this.context.getVideoResolution();
            Vec2d startPoint = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.startPoint));
            Vec2d endPoint = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.endPoint));
            double startFreq = (Double)this.context.value((IAnimatableValue)this.startFrequency);
            double endFreq = Math.max(startFreq, (Double)this.context.value((IAnimatableValue)this.endFrequency));
            final int freqBands = (Integer)this.context.value((IAnimatableValue)this.frequencyBands);
            double height = resolution.scale(((Double)this.context.value((IAnimatableValue)this.height)).doubleValue());
            double audioDuration = (Double)this.context.value((IAnimatableValue)this.audioDuration) / 1000.0;
            double audioOffset = (Double)this.context.value((IAnimatableValue)this.audioOffset) / 1000.0;
            double thickness = resolution.scale(((Double)this.context.value((IAnimatableValue)this.thickness)).doubleValue());
            Color color = (Color)this.context.value((IAnimatableValue)this.color);
            AudioDrawing.Channel channel = (AudioDrawing.Channel)((Object)this.context.value(this.channel));
            AudioDrawing.Style style = (AudioDrawing.Style)((Object)this.context.value(this.style));
            boolean smoothing = (Boolean)this.context.value((IAnimatableValue)this.smoothing);
            AudioMode audioMode = this.context.getAudioMode();
            Time startOffset = new Time((long)((audioOffset - audioDuration / 2.0) * (double)audioMode.sampleRate), audioMode.sampleRate);
            Time startTime = startOffset.add(this.context.getTime());
            int audioFrameCount = (int)(audioDuration * (double)audioMode.sampleRate);
            audioFrameCount = (audioFrameCount + 3) / 4 * 4;
            this.context.setTime(startTime);
            this.context.setAudioFrameCount(audioFrameCount);
            audio = this.context.getLayerAudioChunk(this.audioLayer);
            bands = this.arrayPools.getDoubleArray(freqBands);
            if (audio == null) {
                bands.clear();
            } else {
                this.fft(audio, (IArray<double[]>)bands, startFreq, endFreq, channel);
            }
            final double[] bandsArray = (double[])bands.getArray();
            AudioDrawing.DataProvider dp = new AudioDrawing.DataProvider(){

                public int getDataCount() {
                    return freqBands;
                }

                public float getDataLower(int index) {
                    return 0.0f;
                }

                public float getDataUpper(int index) {
                    return (float)(-bandsArray[index]);
                }

                public float getData(int index) {
                    return (float)(-bandsArray[index]);
                }
            };
            this.draw(dp, drawing, startPoint, endPoint, height, thickness, color, style, smoothing, gl, glu);
        }
        finally {
            if (audio != null) {
                audio.dispose();
            }
            if (bands != null) {
                bands.release();
            }
        }
    }

    private void fft(IAudioBuffer audio, IArray<double[]> bands, double startFreq, double endFreq, AudioDrawing.Channel channel) {
        int n = audio.getFrameCount();
        RealDoubleFFT fft = new RealDoubleFFT(n);
        IArray fftData = null;
        try {
            double f;
            int j;
            fftData = this.arrayPools.getDoubleArray(n);
            double[] fftDataArray = (double[])fftData.getArray();
            switch (audio.getAudioMode().dataType) {
                case SHORT: {
                    Object[] audioArray = (short[])audio.getData();
                    double left = channel == AudioDrawing.Channel.RIGHT ? 0.0 : 3.051850947599719E-5;
                    double right = channel == AudioDrawing.Channel.LEFT ? 0.0 : 3.051850947599719E-5;
                    int i = 0;
                    while (i < n) {
                        fftDataArray[i] = 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)i / (double)(n - 1))) * (left * (double)audioArray[i * 2] + right * (double)audioArray[i * 2 + 1]);
                        ++i;
                    }
                    break;
                }
                case INT: {
                    Object[] audioArray = (int[])audio.getData();
                    double left = channel == AudioDrawing.Channel.RIGHT ? 0.0 : 4.656612875245797E-10;
                    double right = channel == AudioDrawing.Channel.LEFT ? 0.0 : 4.656612875245797E-10;
                    int i = 0;
                    while (i < n) {
                        fftDataArray[i] = 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)i / (double)(n - 1))) * (left * (double)audioArray[i * 2] + right * (double)audioArray[i * 2 + 1]);
                        ++i;
                    }
                    break;
                }
                case FLOAT: {
                    Object[] audioArray = (float[])audio.getData();
                    double left = channel != AudioDrawing.Channel.RIGHT ? 1 : 0;
                    double right = channel != AudioDrawing.Channel.LEFT ? 1 : 0;
                    int i = 0;
                    while (i < n) {
                        fftDataArray[i] = 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)i / (double)(n - 1))) * (left * (double)audioArray[i * 2] + right * (double)audioArray[i * 2 + 1]);
                        ++i;
                    }
                    break;
                }
            }
            fft.ft(fftDataArray, n);
            bands.clear();
            int numBands = bands.getLength();
            double[] bandsArray = (double[])bands.getArray();
            double bandWidth = (endFreq - startFreq) / (double)numBands;
            double baseFreq = (double)audio.getAudioMode().sampleRate / (double)n;
            int i = 1;
            while (i < n - 1) {
                double f2 = (double)((i + 1) / 2) * baseFreq;
                int j2 = (int)Math.floor((f2 - startFreq) / bandWidth);
                if (j2 >= 0 && j2 < numBands) {
                    double a = fftDataArray[i] / (double)n * 2.0;
                    double b = fftDataArray[i + 1] / (double)n * 2.0;
                    int n2 = j2;
                    bandsArray[n2] = bandsArray[n2] + (a * a + b * b);
                }
                i += 2;
            }
            if (n % 2 == 0 && (j = (int)Math.floor(((f = (double)(n / 2) * baseFreq) - startFreq) / bandWidth)) >= 0 && j < numBands) {
                double a = fftDataArray[n - 1] / (double)n * 2.0;
                int n3 = j;
                bandsArray[n3] = bandsArray[n3] + a * a;
            }
            i = 0;
            while (i < numBands) {
                bandsArray[i] = 10.0 * Math.sqrt(bandsArray[i]);
                ++i;
            }
        }
        finally {
            if (fftData != null) {
                fftData.release();
            }
        }
    }
}

