/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.BlendMode;
import ch.kuramo.javie.effects.generate.AudioDrawing;
import com.google.inject.Inject;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Effect(id="ch.kuramo.javie.AudioWaveform", category="ch.kuramo.javie.api.effectCategory.generate")
public class AudioWaveform
extends AudioDrawing {
    @Property
    private IAnimatableLayerReference audioLayer;
    @Property
    private IAnimatableVec2d startPoint;
    @Property
    private IAnimatableVec2d endPoint;
    @Property(value="120", min="1", max="96000")
    private IAnimatableInteger displayedSamples;
    @Property(value="120", min="1")
    private IAnimatableDouble height;
    @Property(value="125", min="0", max="30000")
    private IAnimatableDouble audioDuration;
    @Property(value="0", min="-30000", max="30000")
    private IAnimatableDouble audioOffset;
    @Property(value="3", min="0", max="100")
    private IAnimatableDouble thickness;
    @Property(value="0,1,0")
    private IAnimatableColor color;
    @Property(value="MONO")
    private IAnimatableEnum<AudioDrawing.Channel> channel;
    @Property(value="LINES")
    private IAnimatableEnum<AudioDrawing.Style> style;
    @Property(value="true")
    private IAnimatableBoolean smoothing;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableEnum<BlendMode> blendMode;
    private final IArrayPools arrayPools;

    @Inject
    public AudioWaveform(IVideoEffectContext context, IShaderRegistry shaders, IArrayPools arrayPools) {
        super(context, shaders);
        this.arrayPools = arrayPools;
    }

    public IVideoBuffer doVideoEffect() {
        return this.doDrawing((BlendMode)((Object)this.context.value(this.blendMode)), (Double)this.context.value((IAnimatableValue)this.opacity) / 100.0);
    }

    @Override
    protected void draw(IVideoBuffer drawing, GL2 gl, GLU glu) {
        IAudioBuffer audio = null;
        IArray samples = null;
        try {
            Resolution resolution = this.context.getVideoResolution();
            Vec2d startPoint = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.startPoint));
            Vec2d endPoint = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.endPoint));
            final int displayedSamples = (Integer)this.context.value((IAnimatableValue)this.displayedSamples);
            double height = resolution.scale(((Double)this.context.value((IAnimatableValue)this.height)).doubleValue());
            double audioDuration = (Double)this.context.value((IAnimatableValue)this.audioDuration) / 1000.0;
            double audioOffset = (Double)this.context.value((IAnimatableValue)this.audioOffset) / 1000.0;
            double thickness = resolution.scale(((Double)this.context.value((IAnimatableValue)this.thickness)).doubleValue());
            Color color = (Color)this.context.value((IAnimatableValue)this.color);
            AudioDrawing.Channel channel = (AudioDrawing.Channel)((Object)this.context.value(this.channel));
            AudioDrawing.Style style = (AudioDrawing.Style)((Object)this.context.value(this.style));
            boolean smoothing = (Boolean)this.context.value((IAnimatableValue)this.smoothing);
            AudioMode audioMode = this.context.getAudioMode();
            int audioFrameCount = (int)(audioDuration * (double)audioMode.sampleRate);
            double sampleInterval = (double)audioFrameCount / (double)displayedSamples;
            Time startOffset = new Time((long)((audioOffset - audioDuration / 2.0) * (double)audioMode.sampleRate), audioMode.sampleRate);
            Time startTime = startOffset.add(this.context.getTime());
            int startIndex = (int)Math.floor((double)startTime.timeValue / sampleInterval);
            startTime = new Time(Math.round((double)startIndex * sampleInterval), startTime.timeScale);
            this.context.setTime(startTime);
            this.context.setAudioFrameCount(audioFrameCount);
            audio = this.context.getLayerAudioChunk(this.audioLayer);
            samples = this.arrayPools.getFloatArray(displayedSamples * 2);
            if (audio == null) {
                samples.clear();
            } else {
                this.sample(audio, (IArray<float[]>)samples, channel);
            }
            final float[] sampleArray = (float[])samples.getArray();
            final int evenOdd = Math.abs(startIndex) % 2;
            AudioDrawing.DataProvider dp = new AudioDrawing.DataProvider(){

                public int getDataCount() {
                    return displayedSamples;
                }

                public float getDataUpper(int index) {
                    return sampleArray[index * 2];
                }

                public float getDataLower(int index) {
                    return sampleArray[index * 2 + 1];
                }

                public float getData(int index) {
                    return sampleArray[index * 2 + (evenOdd + index) % 2];
                }
            };
            this.draw(dp, drawing, startPoint, endPoint, height, thickness, color, style, smoothing, gl, glu);
        }
        finally {
            if (audio != null) {
                audio.dispose();
            }
            if (samples != null) {
                samples.release();
            }
        }
    }

    private void sample(IAudioBuffer audio, IArray<float[]> samples, AudioDrawing.Channel channel) {
        Object audioData = audio.getData();
        int audioFrames = audio.getFrameCount();
        float[] sampleArray = (float[])samples.getArray();
        int numSamples = samples.getLength() / 2;
        switch (audio.getAudioMode().dataType) {
            case SHORT: {
                short[] audioArray = (short[])audioData;
                float left = channel == AudioDrawing.Channel.RIGHT ? 0.0f : 3.051851E-5f;
                float right = channel == AudioDrawing.Channel.LEFT ? 0.0f : 3.051851E-5f;
                int i = 0;
                while (i < numSamples) {
                    int p = i * 2;
                    int q = p + 1;
                    sampleArray[p] = Float.POSITIVE_INFINITY;
                    sampleArray[q] = Float.NEGATIVE_INFINITY;
                    int j = i * audioFrames / numSamples * 2;
                    int k = (i + 1) * audioFrames / numSamples * 2;
                    while (j < k) {
                        float sample = left * (float)audioArray[j] + right * (float)audioArray[j + 1];
                        sampleArray[p] = Math.min(sampleArray[p], sample);
                        sampleArray[q] = Math.max(sampleArray[q], sample);
                        j += 2;
                    }
                    ++i;
                }
                break;
            }
            case INT: {
                int[] audioArray = (int[])audioData;
                float left = channel == AudioDrawing.Channel.RIGHT ? 0.0f : 4.656613E-10f;
                float right = channel == AudioDrawing.Channel.LEFT ? 0.0f : 4.656613E-10f;
                int i = 0;
                while (i < numSamples) {
                    int p = i * 2;
                    int q = p + 1;
                    sampleArray[p] = Float.POSITIVE_INFINITY;
                    sampleArray[q] = Float.NEGATIVE_INFINITY;
                    int j = i * audioFrames / numSamples * 2;
                    int k = (i + 1) * audioFrames / numSamples * 2;
                    while (j < k) {
                        float sample = left * (float)audioArray[j] + right * (float)audioArray[j + 1];
                        sampleArray[p] = Math.min(sampleArray[p], sample);
                        sampleArray[q] = Math.max(sampleArray[q], sample);
                        j += 2;
                    }
                    ++i;
                }
                break;
            }
            case FLOAT: {
                float[] audioArray = (float[])audioData;
                float left = channel != AudioDrawing.Channel.RIGHT ? 1 : 0;
                float right = channel != AudioDrawing.Channel.LEFT ? 1 : 0;
                int i = 0;
                while (i < numSamples) {
                    int p = i * 2;
                    int q = p + 1;
                    sampleArray[p] = Float.POSITIVE_INFINITY;
                    sampleArray[q] = Float.NEGATIVE_INFINITY;
                    int j = i * audioFrames / numSamples * 2;
                    int k = (i + 1) * audioFrames / numSamples * 2;
                    while (j < k) {
                        float sample = left * audioArray[j] + right * audioArray[j + 1];
                        sampleArray[p] = Math.min(sampleArray[p], sample);
                        sampleArray[q] = Math.max(sampleArray[q], sample);
                        j += 2;
                    }
                    ++i;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audio.getAudioMode().dataType);
            }
        }
    }
}

