/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.BlendMode;
import ch.kuramo.javie.effects.BlendModeShaders;
import ch.kuramo.javie.effects.VideoEffectUtil;
import com.google.inject.Inject;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;

@Effect(id="ch.kuramo.javie.Circle", category="ch.kuramo.javie.api.effectCategory.generate")
public class Circle {
    @Property
    private IAnimatableVec2d location;
    @Property(value="75", min="0")
    private IAnimatableDouble radius;
    @Property(value="0.5")
    private IAnimatableVec2d anchor;
    @Property
    private IAnimatableEnum<Edge> edge;
    @Property(value="10", min="0")
    private IAnimatableDouble edgeRadius;
    @Property(value="10", min="0", max="4000")
    private IAnimatableDouble thickness;
    @Property(min="0", max="4000")
    private IAnimatableDouble outerFeather;
    @Property(min="0", max="4000")
    private IAnimatableDouble innerFeather;
    @Property
    private IAnimatableBoolean invert;
    @Property(value="1,1,1")
    private IAnimatableColor color;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableEnum<BlendMode> blendMode;
    private final IVideoEffectContext context;
    private final IArrayPools arrayPools;
    private final IShaderProgram circleSamplerProgram;
    private final IShaderProgram invertSamplerProgram;
    private final BlendModeShaders blendModeShaders;
    @ShaderSource
    public static final String[] CIRCLE_SAMPLER = Circle.createSamplerProgram(false);
    @ShaderSource
    public static final String[] INVERT_SAMPLER = Circle.createSamplerProgram(true);

    @Inject
    public Circle(IVideoEffectContext context, IArrayPools arrayPools, IShaderRegistry shaders) {
        this.context = context;
        this.arrayPools = arrayPools;
        this.circleSamplerProgram = shaders.getProgram(Circle.class, "CIRCLE_SAMPLER");
        this.invertSamplerProgram = shaders.getProgram(Circle.class, "INVERT_SAMPLER");
        this.blendModeShaders = BlendModeShaders.forPremult(context, shaders);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IVideoBuffer doVideoEffect() {
        IVideoBuffer iVideoBuffer;
        double outerMiddle;
        double innerMiddle;
        double outerRadius;
        double innerRadius;
        VideoBounds bounds;
        BlendMode blendMode;
        GLUquadric quadric;
        int[] tex1d;
        IVideoBuffer circle;
        IVideoBuffer original;
        GLU glu;
        GL2 gl;
        block35: {
            IVideoBuffer iVideoBuffer2;
            block36: {
                gl = this.context.getGL().getGL2();
                glu = this.context.getGLU();
                original = null;
                circle = null;
                tex1d = null;
                quadric = null;
                blendMode = (BlendMode)((Object)this.context.value(this.blendMode));
                if (blendMode == BlendMode.NONE) {
                    bounds = this.context.getPreviousBounds();
                } else {
                    original = this.context.doPreviousEffect();
                    bounds = original.getBounds();
                }
                if (!bounds.isEmpty()) break block35;
                if (original == null) {
                    original = this.context.createVideoBuffer(bounds);
                }
                IVideoBuffer result = original;
                original = null;
                iVideoBuffer2 = result;
                if (original == null) break block36;
                {
                    catch (Throwable throwable) {
                        if (original != null) {
                            original.dispose();
                        }
                        if (circle != null) {
                            circle.dispose();
                        }
                        if (tex1d != null) {
                            gl.glDeleteTextures(2, tex1d, 0);
                        }
                        if (quadric != null) {
                            glu.gluDeleteQuadric(quadric);
                        }
                        throw throwable;
                    }
                }
                original.dispose();
            }
            if (circle != null) {
                circle.dispose();
            }
            if (tex1d != null) {
                gl.glDeleteTextures(2, tex1d, 0);
            }
            if (quadric != null) {
                glu.gluDeleteQuadric(quadric);
            }
            return iVideoBuffer2;
        }
        Resolution resolution = this.context.getVideoResolution();
        Vec2d location = (Vec2d)this.context.value((IAnimatableValue)this.location);
        double radius = (Double)this.context.value((IAnimatableValue)this.radius);
        Vec2d anchor = (Vec2d)this.context.value((IAnimatableValue)this.anchor);
        final Vec2d center = resolution.scale(new Vec2d(location.x - radius * (anchor.x - 0.5) * 2.0, location.y - radius * (anchor.y - 0.5) * 2.0));
        radius = resolution.scale(radius);
        Edge edge = (Edge)((Object)this.context.value(this.edge));
        boolean invert = (Boolean)this.context.value((IAnimatableValue)this.invert);
        Color color = (Color)this.context.value((IAnimatableValue)this.color);
        double opacity = (Double)this.context.value((IAnimatableValue)this.opacity) / 100.0;
        double edgeRadius = 0.0;
        double thickness = 0.0;
        double innerFeather = 0.0;
        double outerFeather = 0.0;
        switch (edge) {
            case NONE: {
                outerFeather = resolution.scale(((Double)this.context.value((IAnimatableValue)this.outerFeather)).doubleValue());
                break;
            }
            case EDGE_RADIUS: {
                edgeRadius = resolution.scale(((Double)this.context.value((IAnimatableValue)this.edgeRadius)).doubleValue());
                if (edgeRadius > radius) {
                    double tmp = edgeRadius;
                    edgeRadius = radius;
                    radius = tmp;
                }
                innerFeather = resolution.scale(((Double)this.context.value((IAnimatableValue)this.innerFeather)).doubleValue());
                outerFeather = resolution.scale(((Double)this.context.value((IAnimatableValue)this.outerFeather)).doubleValue());
                break;
            }
            case THICKNESS: {
                thickness = resolution.scale(((Double)this.context.value((IAnimatableValue)this.thickness)).doubleValue());
                innerFeather = resolution.scale(((Double)this.context.value((IAnimatableValue)this.innerFeather)).doubleValue());
                outerFeather = resolution.scale(((Double)this.context.value((IAnimatableValue)this.outerFeather)).doubleValue());
                break;
            }
            case P_THICKNESS: {
                thickness = (Double)this.context.value((IAnimatableValue)this.thickness) * radius / 100.0;
                innerFeather = resolution.scale(((Double)this.context.value((IAnimatableValue)this.innerFeather)).doubleValue());
                outerFeather = resolution.scale(((Double)this.context.value((IAnimatableValue)this.outerFeather)).doubleValue());
                break;
            }
            case P_THICKNESS_P_FEATHER: {
                thickness = (Double)this.context.value((IAnimatableValue)this.thickness) * radius / 100.0;
                innerFeather = (Double)this.context.value((IAnimatableValue)this.innerFeather) * radius / 100.0;
                outerFeather = (Double)this.context.value((IAnimatableValue)this.outerFeather) * radius / 100.0;
                break;
            }
        }
        final int[] texSize = new int[2];
        switch (edge) {
            case NONE: {
                innerRadius = 0.0;
                outerRadius = radius + outerFeather;
                innerMiddle = 0.0;
                outerMiddle = radius;
                tex1d = this.createCircleTextures(texSize, 0.0, 0.0, outerFeather, gl);
                break;
            }
            case EDGE_RADIUS: {
                innerRadius = Math.max(0.0, edgeRadius - innerFeather);
                outerRadius = radius + outerFeather;
                innerMiddle = edgeRadius;
                outerMiddle = radius;
                tex1d = this.createCircleTextures(texSize, innerMiddle, innerFeather, outerFeather, gl);
                break;
            }
            default: {
                innerRadius = Math.max(0.0, radius - thickness * 0.5 - innerFeather);
                outerRadius = radius + thickness * 0.5 + outerFeather;
                innerMiddle = radius - thickness * 0.5;
                outerMiddle = radius + thickness * 0.5;
                tex1d = this.createCircleTextures(texSize, innerMiddle, innerFeather, outerFeather, gl);
            }
        }
        gl.glPushAttrib(262145);
        try {
            IVideoBuffer result;
            circle = this.context.createVideoBuffer(bounds);
            VideoEffectUtil.clearTexture(circle, gl);
            int w = bounds.width;
            int h = bounds.height;
            VideoEffectUtil.ortho2D(gl, glu, w, h);
            gl.glFramebufferTexture2D(36160, 36064, 34037, circle.getTexture(), 0);
            gl.glDrawBuffer(36064);
            final float a = (float)(color.a * (blendMode == BlendMode.NONE ? opacity : 1.0));
            final float r = (float)color.r * a;
            final float g = (float)color.g * a;
            final float b = (float)color.b * a;
            gl.glColor4f(r, g, b, a);
            if (invert) {
                gl.glBegin(7);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glVertex2f((float)w, 0.0f);
                gl.glVertex2f((float)w, (float)h);
                gl.glVertex2f(0.0f, (float)h);
                gl.glEnd();
            }
            gl.glTranslatef((float)(center.x - bounds.x), (float)(center.y - bounds.y), 0.0f);
            gl.glActiveTexture(33984);
            gl.glBindTexture(3552, tex1d[0]);
            gl.glActiveTexture(33985);
            gl.glBindTexture(3552, tex1d[1]);
            quadric = glu.gluNewQuadric();
            glu.gluQuadricDrawStyle(quadric, 100012);
            glu.gluQuadricNormals(quadric, 100002);
            final GLUquadric q = quadric;
            final IShaderProgram program = invert ? this.invertSamplerProgram : this.circleSamplerProgram;
            program.useProgram(new Runnable(){

                public void run() {
                    gl.glUniform1i(program.getUniformLocation("texInner"), 0);
                    gl.glUniform1i(program.getUniformLocation("texOuter"), 1);
                    gl.glUniform2f(program.getUniformLocation("texSize"), (float)texSize[0], (float)texSize[1]);
                    gl.glUniform2f(program.getUniformLocation("texOffset"), (float)((double)texSize[0] * 0.5 - innerMiddle), (float)((double)texSize[1] * 0.5 - outerMiddle));
                    gl.glUniform2f(program.getUniformLocation("center"), (float)(center.x - bounds.x), (float)(center.y - bounds.y));
                    gl.glUniform4f(program.getUniformLocation("color"), r, g, b, a);
                    int slices = (int)Math.ceil(Math.PI * 2 * outerRadius);
                    glu.gluDisk(q, Math.max(0.0, innerRadius - 2.0), outerRadius + 2.0, slices, 1);
                }
            });
            if (blendMode == BlendMode.NONE) {
                result = circle;
                circle = null;
            } else {
                result = this.blendModeShaders.blend(circle, original, blendMode, opacity);
            }
            iVideoBuffer = result;
        }
        catch (Throwable throwable) {
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            gl.glPopAttrib();
            throw throwable;
        }
        gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
        gl.glPopAttrib();
        if (original != null) {
            original.dispose();
        }
        if (circle != null) {
            circle.dispose();
        }
        if (tex1d != null) {
            gl.glDeleteTextures(2, tex1d, 0);
        }
        if (quadric != null) {
            glu.gluDeleteQuadric(quadric);
        }
        return iVideoBuffer;
    }

    private int[] createCircleTextures(int[] texSize, double innerMiddle, double innerFeather, double outerFeather, GL2 gl) {
        int[] tex1d = null;
        try {
            tex1d = new int[2];
            gl.glGenTextures(2, tex1d, 0);
            if (innerMiddle <= 0.0 && innerFeather == 0.0) {
                this.copyTextureData(new float[]{1.0f, 1.0f}, 2, tex1d[0], gl);
                texSize[0] = 2;
            } else {
                texSize[0] = this.createCircleTexture(true, innerFeather, tex1d[0], gl);
            }
            texSize[1] = this.createCircleTexture(false, outerFeather, tex1d[1], gl);
            int[] result = tex1d;
            tex1d = null;
            int[] nArray = result;
            return nArray;
        }
        finally {
            if (tex1d != null) {
                gl.glDeleteTextures(2, tex1d, 0);
            }
        }
    }

    private int createCircleTexture(boolean inner, double feather, int tex1d, GL2 gl) {
        IArray data = null;
        try {
            int halfLen = (int)Math.ceil(feather) + 1;
            data = this.arrayPools.getFloatArray(halfLen * 2);
            float[] array = (float[])data.getArray();
            int arrayLen = data.getLength();
            double lowerOutside = !inner ? 1 : 0;
            double upperOutside = inner ? 1 : 0;
            double offset = (double)halfLen + (inner ? -feather : feather);
            int i = 0;
            while (i < arrayLen) {
                double r = (double)i + 0.5;
                double d = r <= (double)halfLen - feather ? lowerOutside : (r >= (double)halfLen + feather ? upperOutside : 0.5 * (1.0 - Math.cos(Math.PI * 2 * (r - offset) / (4.0 * feather))));
                array[i] = (float)d;
                ++i;
            }
            this.copyTextureData(array, arrayLen, tex1d, gl);
            int n = arrayLen;
            return n;
        }
        finally {
            if (data != null) {
                data.release();
            }
        }
    }

    private void copyTextureData(float[] array, int arrayLen, int tex1d, GL2 gl) {
        try {
            gl.glActiveTexture(33984);
            gl.glBindTexture(3552, tex1d);
            gl.glTexParameteri(3552, 10241, 9729);
            gl.glTexParameteri(3552, 10240, 9729);
            gl.glTexParameteri(3552, 10242, 33071);
            gl.glTexParameteri(3552, 10243, 33071);
            FloatBuffer buffer = FloatBuffer.wrap(array, 0, arrayLen);
            switch (this.context.getColorMode()) {
                case RGBA8: {
                    gl.glTexImage1D(3552, 0, 32828, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA16: {
                    gl.glTexImage1D(3552, 0, 32830, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA16_FLOAT: {
                    gl.glTexImage1D(3552, 0, 34844, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA32_FLOAT: {
                    gl.glTexImage1D(3552, 0, 34838, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown ColorMode: " + this.context.getColorMode());
                }
            }
        }
        finally {
            gl.glActiveTexture(33984);
            gl.glBindTexture(3552, 0);
        }
    }

    private static final String[] createSamplerProgram(boolean invert) {
        return new String[]{"uniform sampler1D texInner;", "uniform sampler1D texOuter;", "uniform vec2 texSize;", "uniform vec2 texOffset;", "uniform vec2 center;", "uniform vec4 color;", "", "void main(void)", "{", "\tfloat d = distance(center, gl_FragCoord.st);", "\tvec2 texCoord = (vec2(d, d) + texOffset) / texSize;", "", "\tfloat inner = texture1D(texInner, texCoord.x).a;", "\tfloat outer = texture1D(texOuter, texCoord.y).a;", "", invert ? "\tgl_FragColor = color * (1.0-inner*outer);" : "\tgl_FragColor = color * (inner*outer);", "}"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Edge {
        NONE,
        EDGE_RADIUS,
        THICKNESS,
        P_THICKNESS,
        P_THICKNESS_P_FEATHER;

    }
}

