/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.BlendMode;
import ch.kuramo.javie.effects.BlendModeShaders;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.media.opengl.GL2;

public abstract class GradientBase {
    protected final IVideoEffectContext context;
    protected final IArrayPools arrayPools;
    protected final BlendModeShaders blendModeShaders;
    private static final float[] FLOAT0000 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};

    protected GradientBase(IVideoEffectContext context, IArrayPools arrayPools, IShaderRegistry shaders) {
        this.context = context;
        this.arrayPools = arrayPools;
        this.blendModeShaders = BlendModeShaders.forPremult(context, shaders);
    }

    protected IVideoBuffer doGradientEffect(BlendMode blendMode, double opacity) {
        IVideoBuffer original = null;
        IVideoBuffer gradient = null;
        try {
            IVideoBuffer result;
            VideoBounds bounds;
            if (blendMode == BlendMode.NONE) {
                bounds = this.context.getPreviousBounds();
            } else {
                original = this.context.doPreviousEffect();
                bounds = original.getBounds();
            }
            if (bounds.isEmpty()) {
                if (original == null) {
                    original = this.context.createVideoBuffer(bounds);
                }
                IVideoBuffer result2 = original;
                original = null;
                IVideoBuffer iVideoBuffer = result2;
                return iVideoBuffer;
            }
            gradient = this.createGradient(bounds);
            if (blendMode == BlendMode.NONE && opacity == 1.0) {
                result = gradient;
                gradient = null;
            } else {
                result = this.blendModeShaders.blend(gradient, original, blendMode, opacity);
            }
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (original != null) {
                original.dispose();
            }
            if (gradient != null) {
                gradient.dispose();
            }
        }
    }

    protected abstract IVideoBuffer createGradient(VideoBounds var1);

    protected int[] createRGBGradientTexture(Color colorA, Color colorB, int texSize, RepeatMode repeatMode, GL2 gl) {
        if (texSize <= 0) {
            throw new IllegalArgumentException("texSize must be greater than 0");
        }
        IArray data = null;
        int[] tex1d = null;
        try {
            data = this.arrayPools.getFloatArray(texSize * 4);
            float[] array = (float[])data.getArray();
            if (texSize == 1) {
                double a = colorA.a * 0.5 + colorB.a * 0.5;
                array[0] = (float)((colorA.r * 0.5 + colorB.r * 0.5) * a);
                array[1] = (float)((colorA.g * 0.5 + colorB.g * 0.5) * a);
                array[2] = (float)((colorA.b * 0.5 + colorB.b * 0.5) * a);
                array[3] = (float)a;
            } else {
                int i = 0;
                while (i < texSize) {
                    double t = (double)i / ((double)texSize - 1.0);
                    double a = colorA.a * (1.0 - t) + colorB.a * t;
                    array[i * 4] = (float)((colorA.r * (1.0 - t) + colorB.r * t) * a);
                    array[i * 4 + 1] = (float)((colorA.g * (1.0 - t) + colorB.g * t) * a);
                    array[i * 4 + 2] = (float)((colorA.b * (1.0 - t) + colorB.b * t) * a);
                    array[i * 4 + 3] = (float)a;
                    ++i;
                }
            }
            tex1d = new int[1];
            gl.glGenTextures(1, tex1d, 0);
            this.copyTextureData(array, data.getLength(), repeatMode, tex1d[0], gl);
            int[] result = tex1d;
            tex1d = null;
            int[] nArray = result;
            return nArray;
        }
        finally {
            if (data != null) {
                data.release();
            }
            if (tex1d != null) {
                gl.glDeleteTextures(1, tex1d, 0);
            }
        }
    }

    protected int[] createHSLGradientTexture(Color colorA, Color colorB, boolean reverseHue, int texSize, RepeatMode repeatMode, GL2 gl) {
        if (texSize <= 0) {
            throw new IllegalArgumentException("texSize must be greater than 0");
        }
        IArray data = null;
        int[] tex1d = null;
        try {
            data = this.arrayPools.getFloatArray(texSize * 4);
            float[] array = (float[])data.getArray();
            double[] hslA = new double[3];
            double[] hslB = new double[3];
            this.rgb2hsl(colorA, hslA);
            this.rgb2hsl(colorB, hslB);
            if (reverseHue) {
                if (hslA[0] <= hslB[0]) {
                    hslA[0] = hslA[0] + 1.0;
                }
            } else if (hslA[0] > hslB[0]) {
                hslB[0] = hslB[0] + 1.0;
            }
            double[] hsl = new double[3];
            double[] rgb = new double[3];
            if (texSize == 1) {
                hsl[0] = hslA[0] * 0.5 + hslB[0] * 0.5;
                hsl[1] = hslA[1] * 0.5 + hslB[1] * 0.5;
                hsl[2] = hslA[2] * 0.5 + hslB[2] * 0.5;
                this.hsl2rgb(hsl, rgb);
                double a = colorA.a * 0.5 + colorB.a * 0.5;
                array[0] = (float)(rgb[0] * a);
                array[1] = (float)(rgb[1] * a);
                array[2] = (float)(rgb[2] * a);
                array[3] = (float)a;
            } else {
                int i = 0;
                while (i < texSize) {
                    double t = (double)i / ((double)texSize - 1.0);
                    hsl[0] = hslA[0] * (1.0 - t) + hslB[0] * t;
                    hsl[1] = hslA[1] * (1.0 - t) + hslB[1] * t;
                    hsl[2] = hslA[2] * (1.0 - t) + hslB[2] * t;
                    this.hsl2rgb(hsl, rgb);
                    double a = colorA.a * (1.0 - t) + colorB.a * t;
                    array[i * 4] = (float)(rgb[0] * a);
                    array[i * 4 + 1] = (float)(rgb[1] * a);
                    array[i * 4 + 2] = (float)(rgb[2] * a);
                    array[i * 4 + 3] = (float)a;
                    ++i;
                }
            }
            tex1d = new int[1];
            gl.glGenTextures(1, tex1d, 0);
            this.copyTextureData(array, data.getLength(), repeatMode, tex1d[0], gl);
            int[] result = tex1d;
            tex1d = null;
            int[] nArray = result;
            return nArray;
        }
        finally {
            if (data != null) {
                data.release();
            }
            if (tex1d != null) {
                gl.glDeleteTextures(1, tex1d, 0);
            }
        }
    }

    private void rgb2hsl(Color rgb, double[] hsl) {
        double hue;
        double sat;
        double min = Math.min(Math.min(rgb.r, rgb.g), rgb.b);
        double max = Math.max(Math.max(rgb.r, rgb.g), rgb.b);
        double dmax = max - min;
        double luma = (max + min) * 0.5;
        if (dmax == 0.0) {
            sat = 0.0;
            hue = 0.0;
        } else {
            sat = luma < 0.5 ? dmax / (max + min) : dmax / (2.0 - max - min);
            double dr = ((max - rgb.r) / 6.0 + dmax / 2.0) / dmax;
            double dg = ((max - rgb.g) / 6.0 + dmax / 2.0) / dmax;
            double db = ((max - rgb.b) / 6.0 + dmax / 2.0) / dmax;
            double d = rgb.r == max ? db - dg : (hue = rgb.g == max ? 0.3333333333333333 + dr - db : 0.6666666666666666 + dg - dr);
            if (hue < 0.0) {
                hue += 1.0;
            } else if (hue > 1.0) {
                hue -= 1.0;
            }
        }
        hsl[0] = hue;
        hsl[1] = sat;
        hsl[2] = luma;
    }

    private void hsl2rgb(double[] hsl, double[] rgb) {
        double hue = hsl[0];
        double sat = hsl[1];
        double luma = hsl[2];
        if (hue > 1.0) {
            hue -= 1.0;
        }
        if (sat == 0.0) {
            rgb[1] = rgb[2] = luma;
            rgb[0] = rgb[2];
        } else {
            double t2 = luma < 0.5 ? luma * (1.0 + sat) : luma + sat - luma * sat;
            double t1 = luma * 2.0 - t2;
            rgb[0] = this.hue2rgb(t1, t2, hue + 0.3333333333333333);
            rgb[1] = this.hue2rgb(t1, t2, hue);
            rgb[2] = this.hue2rgb(t1, t2, hue - 0.3333333333333333);
        }
    }

    private double hue2rgb(double t1, double t2, double hue) {
        if (hue < 0.0) {
            hue += 1.0;
        } else if (hue > 1.0) {
            hue -= 1.0;
        }
        return hue * 6.0 < 1.0 ? t1 + (t2 - t1) * 6.0 * hue : (hue * 2.0 < 1.0 ? t2 : (hue * 3.0 < 2.0 ? t1 + (t2 - t1) * (0.6666666666666666 - hue) * 6.0 : t1));
    }

    protected void copyTextureData(float[] array, int arrayLen, RepeatMode repeatMode, int tex1d, GL2 gl) {
        try {
            int wrapMode;
            switch (repeatMode) {
                case CLAMP_TO_EDGE: {
                    wrapMode = 33071;
                    break;
                }
                case SAWTOOTH: {
                    wrapMode = 10497;
                    break;
                }
                case TRIANGLE: {
                    wrapMode = 33648;
                    break;
                }
                default: {
                    wrapMode = 33069;
                }
            }
            gl.glActiveTexture(33984);
            gl.glBindTexture(3552, tex1d);
            gl.glTexParameteri(3552, 10241, 9729);
            gl.glTexParameteri(3552, 10240, 9729);
            gl.glTexParameteri(3552, 10242, wrapMode);
            gl.glTexParameteri(3552, 10243, 33071);
            if (wrapMode == 33069) {
                gl.glTexParameterfv(3552, 4100, FLOAT0000, 0);
            }
            int width = arrayLen / 4;
            FloatBuffer buffer = FloatBuffer.wrap(array, 0, arrayLen);
            switch (this.context.getColorMode()) {
                case RGBA8: {
                    gl.glTexImage1D(3552, 0, 32856, width, 0, 6408, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA16: {
                    gl.glTexImage1D(3552, 0, 32859, width, 0, 6408, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA16_FLOAT: {
                    gl.glTexImage1D(3552, 0, 34842, width, 0, 6408, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA32_FLOAT: {
                    gl.glTexImage1D(3552, 0, 34836, width, 0, 6408, 5126, (Buffer)buffer);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown ColorMode: " + this.context.getColorMode());
                }
            }
        }
        finally {
            gl.glActiveTexture(33984);
            gl.glBindTexture(3552, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorSpace {
        RGB,
        HSL,
        HSL_REVERSE_HUE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RepeatMode {
        NONE,
        CLAMP_TO_EDGE,
        SAWTOOTH,
        TRIANGLE;

    }
}

