/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.BlendMode;
import ch.kuramo.javie.effects.BlendModeShaders;
import ch.kuramo.javie.effects.VideoEffectUtil;
import com.google.inject.Inject;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.media.opengl.GL2;

@Effect(id="ch.kuramo.javie.Grid", category="ch.kuramo.javie.api.effectCategory.generate")
public class Grid {
    @Property
    private IAnimatableVec2d anchor;
    @Property(value="100", min="0", max="4000")
    private IAnimatableVec2d gridSize;
    @Property(value="5", min="0", max="4000")
    private IAnimatableVec2d border;
    @Property(value="0", min="0", max="400")
    private IAnimatableVec2d feather;
    @Property
    private IAnimatableBoolean invert;
    @Property(value="1,1,1")
    private IAnimatableColor color;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableEnum<BlendMode> blendMode;
    private final IVideoEffectContext context;
    private final IArrayPools arrayPools;
    private final IShaderProgram gridSamplerProgram;
    private final IShaderProgram invertSamplerProgram;
    private final BlendModeShaders blendModeShaders;
    @ShaderSource
    public static final String[] GRID_SAMPLER = Grid.createSamplerProgram(false);
    @ShaderSource
    public static final String[] INVERT_SAMPLER = Grid.createSamplerProgram(true);

    @Inject
    public Grid(IVideoEffectContext context, IArrayPools arrayPools, IShaderRegistry shaders) {
        this.context = context;
        this.arrayPools = arrayPools;
        this.gridSamplerProgram = shaders.getProgram(Grid.class, "GRID_SAMPLER");
        this.invertSamplerProgram = shaders.getProgram(Grid.class, "INVERT_SAMPLER");
        this.blendModeShaders = BlendModeShaders.forPremult(context, shaders);
    }

    public IVideoBuffer doVideoEffect() {
        final GL2 gl = this.context.getGL().getGL2();
        IVideoBuffer original = null;
        IVideoBuffer grid = null;
        int[] tex1d = null;
        try {
            IVideoBuffer iVideoBuffer;
            VideoBounds bounds;
            BlendMode blendMode = (BlendMode)((Object)this.context.value(this.blendMode));
            if (blendMode == BlendMode.NONE) {
                bounds = this.context.getPreviousBounds();
            } else {
                original = this.context.doPreviousEffect();
                bounds = original.getBounds();
            }
            if (bounds.isEmpty()) {
                if (original == null) {
                    original = this.context.createVideoBuffer(bounds);
                }
                IVideoBuffer result = original;
                original = null;
                IVideoBuffer iVideoBuffer2 = result;
                return iVideoBuffer2;
            }
            Resolution resolution = this.context.getVideoResolution();
            final Vec2d anchor = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.anchor));
            final Vec2d gridSize = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.gridSize));
            final Vec2d border = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.border));
            Vec2d feather = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.feather));
            boolean invert = (Boolean)this.context.value((IAnimatableValue)this.invert);
            Color color = (Color)this.context.value((IAnimatableValue)this.color);
            double opacity = (Double)this.context.value((IAnimatableValue)this.opacity) / 100.0;
            final int[] texSize = new int[2];
            tex1d = this.createGridTextures(texSize, feather, gl);
            gl.glPushAttrib(262145);
            try {
                IVideoBuffer result;
                grid = this.context.createVideoBuffer(bounds);
                VideoEffectUtil.clearTexture(grid, gl);
                final int w = bounds.width;
                final int h = bounds.height;
                VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
                gl.glFramebufferTexture2D(36160, 36064, 34037, grid.getTexture(), 0);
                gl.glDrawBuffer(36064);
                final float a = (float)(color.a * (blendMode == BlendMode.NONE ? opacity : 1.0));
                final float r = (float)color.r * a;
                final float g = (float)color.g * a;
                final float b = (float)color.b * a;
                gl.glColor4f(r, g, b, a);
                gl.glActiveTexture(33984);
                gl.glBindTexture(3552, tex1d[0]);
                gl.glActiveTexture(33985);
                gl.glBindTexture(3552, tex1d[1]);
                final IShaderProgram program = invert ? this.invertSamplerProgram : this.gridSamplerProgram;
                program.useProgram(new Runnable(){

                    public void run() {
                        gl.glUniform1i(program.getUniformLocation("texX"), 0);
                        gl.glUniform1i(program.getUniformLocation("texY"), 1);
                        gl.glUniform4f(program.getUniformLocation("texSize"), (float)texSize[0], (float)texSize[1], (float)texSize[0], (float)texSize[1]);
                        gl.glUniform4f(program.getUniformLocation("texOffset"), (float)((gridSize.x - border.x - (double)texSize[0]) * 0.5), (float)((gridSize.y - border.y - (double)texSize[1]) * 0.5), (float)((gridSize.x + border.x - (double)texSize[0]) * 0.5), (float)((gridSize.y + border.y - (double)texSize[1]) * 0.5));
                        float gridSizeX = Math.max((float)gridSize.x, 1.0E-10f);
                        float gridSizeY = Math.max((float)gridSize.y, 1.0E-10f);
                        gl.glUniform4f(program.getUniformLocation("gridSize"), gridSizeX, gridSizeY, gridSizeX, gridSizeY);
                        gl.glUniform2f(program.getUniformLocation("anchor"), (float)(anchor.x - bounds.x), (float)(anchor.y - bounds.y));
                        gl.glUniform4f(program.getUniformLocation("color"), r, g, b, a);
                        gl.glBegin(7);
                        gl.glVertex2f(0.0f, 0.0f);
                        gl.glVertex2f((float)w, 0.0f);
                        gl.glVertex2f((float)w, (float)h);
                        gl.glVertex2f(0.0f, (float)h);
                        gl.glEnd();
                    }
                });
                if (blendMode == BlendMode.NONE) {
                    result = grid;
                    grid = null;
                } else {
                    result = this.blendModeShaders.blend(grid, original, blendMode, opacity);
                }
                iVideoBuffer = result;
            }
            catch (Throwable throwable) {
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                gl.glPopAttrib();
                throw throwable;
            }
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            gl.glPopAttrib();
            return iVideoBuffer;
        }
        finally {
            if (original != null) {
                original.dispose();
            }
            if (grid != null) {
                grid.dispose();
            }
            if (tex1d != null) {
                gl.glDeleteTextures(2, tex1d, 0);
            }
        }
    }

    private int[] createGridTextures(int[] texSize, Vec2d feather, GL2 gl) {
        int[] tex1d = null;
        try {
            tex1d = new int[2];
            gl.glGenTextures(2, tex1d, 0);
            texSize[0] = this.createGridTexture(feather.x, tex1d[0], gl);
            texSize[1] = this.createGridTexture(feather.y, tex1d[1], gl);
            int[] result = tex1d;
            tex1d = null;
            int[] nArray = result;
            return nArray;
        }
        finally {
            if (tex1d != null) {
                gl.glDeleteTextures(2, tex1d, 0);
            }
        }
    }

    private int createGridTexture(double feather, int tex1d, GL2 gl) {
        IArray data = null;
        try {
            int halfLen = (int)Math.ceil(feather) + 1;
            data = this.arrayPools.getFloatArray(halfLen * 2);
            float[] array = (float[])data.getArray();
            int arrayLen = data.getLength();
            int i = 0;
            while (i < arrayLen) {
                double t = (double)i + 0.5;
                double d = t <= (double)halfLen - feather ? 0.0 : (t >= (double)halfLen + feather ? 1.0 : 0.5 * (1.0 - Math.cos(Math.PI * 2 * (t - ((double)halfLen - feather)) / (4.0 * feather))));
                array[i] = (float)d;
                ++i;
            }
            this.copyTextureData(array, arrayLen, tex1d, gl);
            int n = arrayLen;
            return n;
        }
        finally {
            if (data != null) {
                data.release();
            }
        }
    }

    private void copyTextureData(float[] array, int arrayLen, int tex1d, GL2 gl) {
        try {
            gl.glActiveTexture(33984);
            gl.glBindTexture(3552, tex1d);
            gl.glTexParameteri(3552, 10241, 9729);
            gl.glTexParameteri(3552, 10240, 9729);
            gl.glTexParameteri(3552, 10242, 33071);
            gl.glTexParameteri(3552, 10243, 33071);
            FloatBuffer buffer = FloatBuffer.wrap(array, 0, arrayLen);
            switch (this.context.getColorMode()) {
                case RGBA8: {
                    gl.glTexImage1D(3552, 0, 32828, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA16: {
                    gl.glTexImage1D(3552, 0, 32830, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA16_FLOAT: {
                    gl.glTexImage1D(3552, 0, 34844, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA32_FLOAT: {
                    gl.glTexImage1D(3552, 0, 34838, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown ColorMode: " + this.context.getColorMode());
                }
            }
        }
        finally {
            gl.glActiveTexture(33984);
            gl.glBindTexture(3552, 0);
        }
    }

    private static final String[] createSamplerProgram(boolean invert) {
        return new String[]{"uniform sampler1D texX;", "uniform sampler1D texY;", "uniform vec4 texSize;", "uniform vec4 texOffset;", "uniform vec4 gridSize;", "uniform vec2 anchor;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec2 gridCoord = gl_FragCoord.st - anchor;", "\tgridCoord = gridCoord / gridSize.st + 0.5;", "\tgridCoord -= floor(gridCoord);", "\tgridCoord *= gridSize.st;", "", "\tvec4 texCoord = (vec4(gridCoord, gridCoord) - texOffset) / texSize;", "", "\tvec2 a1 = vec2(texture1D(texX, texCoord.x).a, texture1D(texY, texCoord.y).a);", "\tvec2 a2 = vec2(texture1D(texX, texCoord.z).a, texture1D(texY, texCoord.w).a);", "\tvec2 a = 1.0 - a1*(1.0-a2);", "", invert ? "\tgl_FragColor = color * a.x*a.y;" : "\tgl_FragColor = color * (1.0-a.x*a.y);", "}"};
    }
}

