/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.BlendMode;
import ch.kuramo.javie.effects.VideoEffectUtil;
import ch.kuramo.javie.effects.generate.GradientBase;
import com.google.inject.Inject;
import javax.media.opengl.GL2;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;

@Effect(id="ch.kuramo.javie.LinearGradient", category="ch.kuramo.javie.api.effectCategory.generate")
public class LinearGradient
extends GradientBase {
    @Property
    private IAnimatableVec2d startPoint;
    @Property
    private IAnimatableVec2d endPoint;
    @Property(value="1,1,1")
    private IAnimatableColor startColor;
    @Property(value="0,0,0")
    private IAnimatableColor endColor;
    @Property(value="RGB")
    private IAnimatableEnum<GradientBase.ColorSpace> colorSpace;
    @Property(value="CLAMP_TO_EDGE")
    private IAnimatableEnum<GradientBase.RepeatMode> repeatMode;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableEnum<BlendMode> blendMode;

    @Inject
    public LinearGradient(IVideoEffectContext context, IArrayPools arrayPools, IShaderRegistry shaders) {
        super(context, arrayPools, shaders);
    }

    public IVideoBuffer doVideoEffect() {
        return this.doGradientEffect((BlendMode)((Object)this.context.value(this.blendMode)), (Double)this.context.value((IAnimatableValue)this.opacity) / 100.0);
    }

    protected IVideoBuffer createGradient(VideoBounds bounds) {
        GL2 gl = this.context.getGL().getGL2();
        IVideoBuffer gradient = null;
        int[] tex1d = null;
        gl.glPushAttrib(270337);
        try {
            Resolution resolution = this.context.getVideoResolution();
            Vec2d startPoint = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.startPoint));
            Vec2d endPoint = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.endPoint));
            Color startColor = (Color)this.context.value((IAnimatableValue)this.startColor);
            Color endColor = (Color)this.context.value((IAnimatableValue)this.endColor);
            GradientBase.ColorSpace colorSpace = (GradientBase.ColorSpace)((Object)this.context.value(this.colorSpace));
            GradientBase.RepeatMode repeatMode = (GradientBase.RepeatMode)((Object)this.context.value(this.repeatMode));
            double dx = endPoint.x - startPoint.x;
            double dy = endPoint.y - startPoint.y;
            int texSize = Math.min(4000, (int)Math.ceil(Math.sqrt(dx * dx + dy * dy)));
            if (texSize == 0) {
                IVideoBuffer result = this.context.createVideoBuffer(bounds);
                VideoEffectUtil.clearTexture(result, gl);
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            texSize = Math.max(10, texSize);
            switch (colorSpace) {
                case RGB: {
                    tex1d = this.createRGBGradientTexture(startColor, endColor, texSize, repeatMode, gl);
                    break;
                }
                case HSL: {
                    tex1d = this.createHSLGradientTexture(startColor, endColor, false, texSize, repeatMode, gl);
                    break;
                }
                case HSL_REVERSE_HUE: {
                    tex1d = this.createHSLGradientTexture(startColor, endColor, true, texSize, repeatMode, gl);
                }
            }
            gradient = this.context.createVideoBuffer(bounds);
            VideoEffectUtil.clearTexture(gradient, gl);
            double x = bounds.x;
            double y = bounds.y;
            int w = bounds.width;
            int h = bounds.height;
            Point2d center = new Point2d(x + (double)w * 0.5, y + (double)h * 0.5);
            Vector2d startToEnd = new Vector2d(endPoint.x - startPoint.x, endPoint.y - startPoint.y);
            double theta = Math.atan2(startToEnd.y, startToEnd.x);
            double w2 = (double)w * Math.abs(Math.cos(theta)) + (double)h * Math.abs(Math.sin(theta));
            double h2 = (double)h * Math.abs(Math.cos(theta)) + (double)w * Math.abs(Math.sin(theta));
            double angle = Math.toDegrees(theta);
            Vector2d startToCenter = new Vector2d(center.x - startPoint.x, center.y - startPoint.y);
            Vector2d endToCenter = new Vector2d(center.x - endPoint.x, center.y - endPoint.y);
            double lenOfStartToEnd = startToEnd.length();
            double coord0 = -(w2 * 0.5 - startToCenter.dot(startToEnd) / lenOfStartToEnd) / lenOfStartToEnd;
            double coord1 = 1.0 + (w2 * 0.5 + endToCenter.dot(startToEnd) / lenOfStartToEnd) / lenOfStartToEnd;
            VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
            gl.glTranslatef((float)(center.x - x), (float)(center.y - y), 0.0f);
            gl.glRotatef((float)angle, 0.0f, 0.0f, 1.0f);
            gl.glScalef((float)(w2 / (double)w), (float)(h2 / (double)h), 1.0f);
            gl.glTranslatef((float)(-(center.x - x)), (float)(-(center.y - y)), 0.0f);
            gl.glFramebufferTexture2D(36160, 36064, 34037, gradient.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(3552, tex1d[0]);
            gl.glEnable(3552);
            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            gl.glBegin(7);
            gl.glTexCoord1f((float)coord0);
            gl.glVertex2f(0.0f, 0.0f);
            gl.glTexCoord1f((float)coord1);
            gl.glVertex2f((float)w, 0.0f);
            gl.glTexCoord1f((float)coord1);
            gl.glVertex2f((float)w, (float)h);
            gl.glTexCoord1f((float)coord0);
            gl.glVertex2f(0.0f, (float)h);
            gl.glEnd();
            IVideoBuffer result = gradient;
            gradient = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            gl.glPopAttrib();
            if (gradient != null) {
                gradient.dispose();
            }
            if (tex1d != null) {
                gl.glDeleteTextures(1, tex1d, 0);
            }
        }
    }
}

