/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.BlendMode;
import ch.kuramo.javie.effects.VideoEffectUtil;
import ch.kuramo.javie.effects.generate.GradientBase;
import com.google.inject.Inject;
import javax.media.opengl.GL2;

@Effect(id="ch.kuramo.javie.RadialGradient", category="ch.kuramo.javie.api.effectCategory.generate")
public class RadialGradient
extends GradientBase {
    @Property
    private IAnimatableVec2d center;
    @Property(value="100", min="0", max="4000")
    private IAnimatableDouble radius;
    @Property(value="1,1,1")
    private IAnimatableColor centerColor;
    @Property(value="0,0,0")
    private IAnimatableColor edgeColor;
    @Property(value="RGB")
    private IAnimatableEnum<GradientBase.ColorSpace> colorSpace;
    @Property(value="CLAMP_TO_EDGE")
    private IAnimatableEnum<GradientBase.RepeatMode> repeatMode;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableEnum<BlendMode> blendMode;
    private final IShaderProgram radialSamplerProgram;
    @ShaderSource
    public static final String[] RADIAL_SAMPLER = new String[]{"uniform sampler1D texture;", "uniform vec2 center;", "uniform float radius;", "", "void main(void)", "{", "\tfloat d = distance(center, gl_FragCoord.st);", "\tgl_FragColor = texture1D(texture, d/radius);", "}"};

    @Inject
    public RadialGradient(IVideoEffectContext context, IArrayPools arrayPools, IShaderRegistry shaders) {
        super(context, arrayPools, shaders);
        this.radialSamplerProgram = shaders.getProgram(RadialGradient.class, "RADIAL_SAMPLER");
    }

    public IVideoBuffer doVideoEffect() {
        return this.doGradientEffect((BlendMode)((Object)this.context.value(this.blendMode)), (Double)this.context.value((IAnimatableValue)this.opacity) / 100.0);
    }

    protected IVideoBuffer createGradient(VideoBounds bounds) {
        final GL2 gl = this.context.getGL().getGL2();
        IVideoBuffer gradient = null;
        int[] tex1d = null;
        gl.glPushAttrib(262145);
        try {
            Resolution resolution = this.context.getVideoResolution();
            final Vec2d center = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.center));
            final double radius = resolution.scale(((Double)this.context.value((IAnimatableValue)this.radius)).doubleValue());
            Color centerColor = (Color)this.context.value((IAnimatableValue)this.centerColor);
            Color edgeColor = (Color)this.context.value((IAnimatableValue)this.edgeColor);
            GradientBase.ColorSpace colorSpace = (GradientBase.ColorSpace)((Object)this.context.value(this.colorSpace));
            GradientBase.RepeatMode repeatMode = (GradientBase.RepeatMode)((Object)this.context.value(this.repeatMode));
            int texSize = Math.max(10, Math.min(4000, (int)Math.ceil(radius)));
            switch (colorSpace) {
                case RGB: {
                    tex1d = this.createRGBGradientTexture(centerColor, edgeColor, texSize, repeatMode, gl);
                    break;
                }
                case HSL: {
                    tex1d = this.createHSLGradientTexture(centerColor, edgeColor, false, texSize, repeatMode, gl);
                    break;
                }
                case HSL_REVERSE_HUE: {
                    tex1d = this.createHSLGradientTexture(centerColor, edgeColor, true, texSize, repeatMode, gl);
                }
            }
            gradient = this.context.createVideoBuffer(bounds);
            VideoEffectUtil.clearTexture(gradient, gl);
            final double x = bounds.x;
            final double y = bounds.y;
            final int w = bounds.width;
            final int h = bounds.height;
            VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
            gl.glFramebufferTexture2D(36160, 36064, 34037, gradient.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(3552, tex1d[0]);
            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.radialSamplerProgram.useProgram(new Runnable(){

                public void run() {
                    gl.glUniform1i(RadialGradient.this.radialSamplerProgram.getUniformLocation("texture"), 0);
                    gl.glUniform2f(RadialGradient.this.radialSamplerProgram.getUniformLocation("center"), (float)(center.x - x), (float)(center.y - y));
                    gl.glUniform1f(RadialGradient.this.radialSamplerProgram.getUniformLocation("radius"), (float)radius);
                    gl.glBegin(7);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glVertex2f((float)w, 0.0f);
                    gl.glVertex2f((float)w, (float)h);
                    gl.glVertex2f(0.0f, (float)h);
                    gl.glEnd();
                }
            });
            IVideoBuffer result = gradient;
            gradient = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            gl.glPopAttrib();
            if (gradient != null) {
                gradient.dispose();
            }
            if (tex1d != null) {
                gl.glDeleteTextures(1, tex1d, 0);
            }
        }
    }
}

