/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.BlendMode;
import ch.kuramo.javie.effects.BlendModeShaders;
import ch.kuramo.javie.effects.VideoEffectUtil;
import com.google.inject.Inject;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.media.opengl.GL2;

@Effect(id="ch.kuramo.javie.Rectangle", category="ch.kuramo.javie.api.effectCategory.generate")
public class Rectangle {
    @Property
    private IAnimatableVec2d location;
    @Property(value="150", min="0")
    private IAnimatableVec2d size;
    @Property(value="0.5")
    private IAnimatableVec2d anchor;
    @Property
    private IAnimatableEnum<Edge> edge;
    @Property(value="10", min="0", max="4000")
    private IAnimatableDouble thickness;
    @Property(min="0", max="4000")
    private IAnimatableDouble outerFeather;
    @Property(min="0", max="4000")
    private IAnimatableDouble innerFeather;
    @Property
    private IAnimatableBoolean invert;
    @Property(value="1,1,1")
    private IAnimatableColor color;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableEnum<BlendMode> blendMode;
    private final IVideoEffectContext context;
    private final IArrayPools arrayPools;
    private final IShaderProgram rectangleSamplerProgram;
    private final IShaderProgram invertSamplerProgram;
    private final BlendModeShaders blendModeShaders;
    @ShaderSource
    public static final String[] RECTANGLE_SAMPLER = Rectangle.createSamplerProgram(false);
    @ShaderSource
    public static final String[] INVERT_SAMPLER = Rectangle.createSamplerProgram(true);

    @Inject
    public Rectangle(IVideoEffectContext context, IArrayPools arrayPools, IShaderRegistry shaders) {
        this.context = context;
        this.arrayPools = arrayPools;
        this.rectangleSamplerProgram = shaders.getProgram(Rectangle.class, "RECTANGLE_SAMPLER");
        this.invertSamplerProgram = shaders.getProgram(Rectangle.class, "INVERT_SAMPLER");
        this.blendModeShaders = BlendModeShaders.forPremult(context, shaders);
    }

    public IVideoBuffer doVideoEffect() {
        final GL2 gl = this.context.getGL().getGL2();
        IVideoBuffer original = null;
        IVideoBuffer rectangle = null;
        int[] tex1d = null;
        try {
            IVideoBuffer iVideoBuffer;
            double outerMiddleY;
            double outerMiddleX;
            double innerMiddleY;
            double innerMiddleX;
            double halfHeight;
            double halfWidth;
            VideoBounds bounds;
            BlendMode blendMode = (BlendMode)((Object)this.context.value(this.blendMode));
            if (blendMode == BlendMode.NONE) {
                bounds = this.context.getPreviousBounds();
            } else {
                original = this.context.doPreviousEffect();
                bounds = original.getBounds();
            }
            if (bounds.isEmpty()) {
                if (original == null) {
                    original = this.context.createVideoBuffer(bounds);
                }
                IVideoBuffer result = original;
                original = null;
                IVideoBuffer iVideoBuffer2 = result;
                return iVideoBuffer2;
            }
            Resolution resolution = this.context.getVideoResolution();
            Vec2d location = (Vec2d)this.context.value((IAnimatableValue)this.location);
            Vec2d size = (Vec2d)this.context.value((IAnimatableValue)this.size);
            Vec2d anchor = (Vec2d)this.context.value((IAnimatableValue)this.anchor);
            double halfDiag = Math.sqrt(size.x * size.x + size.y * size.y) * 0.5;
            final Vec2d center = resolution.scale(new Vec2d(location.x - size.x * (anchor.x - 0.5), location.y - size.y * (anchor.y - 0.5)));
            size = resolution.scale(size);
            Edge edge = (Edge)((Object)this.context.value(this.edge));
            boolean invert = (Boolean)this.context.value((IAnimatableValue)this.invert);
            Color color = (Color)this.context.value((IAnimatableValue)this.color);
            double opacity = (Double)this.context.value((IAnimatableValue)this.opacity) / 100.0;
            double thickness = 0.0;
            double innerFeather = 0.0;
            double outerFeather = 0.0;
            switch (edge) {
                case NONE: {
                    outerFeather = resolution.scale(((Double)this.context.value((IAnimatableValue)this.outerFeather)).doubleValue());
                    break;
                }
                case THICKNESS: {
                    thickness = resolution.scale(((Double)this.context.value((IAnimatableValue)this.thickness)).doubleValue());
                    innerFeather = resolution.scale(((Double)this.context.value((IAnimatableValue)this.innerFeather)).doubleValue());
                    outerFeather = resolution.scale(((Double)this.context.value((IAnimatableValue)this.outerFeather)).doubleValue());
                    break;
                }
                case P_THICKNESS: {
                    thickness = resolution.scale(((Double)this.context.value((IAnimatableValue)this.thickness)).doubleValue()) * halfDiag / 100.0;
                    innerFeather = resolution.scale(((Double)this.context.value((IAnimatableValue)this.innerFeather)).doubleValue());
                    outerFeather = resolution.scale(((Double)this.context.value((IAnimatableValue)this.outerFeather)).doubleValue());
                    break;
                }
                case P_THICKNESS_P_FEATHER: {
                    thickness = resolution.scale(((Double)this.context.value((IAnimatableValue)this.thickness)).doubleValue()) * halfDiag / 100.0;
                    innerFeather = resolution.scale(((Double)this.context.value((IAnimatableValue)this.innerFeather)).doubleValue()) * halfDiag / 100.0;
                    outerFeather = resolution.scale(((Double)this.context.value((IAnimatableValue)this.outerFeather)).doubleValue()) * halfDiag / 100.0;
                }
            }
            final int[] texSize = new int[3];
            switch (edge) {
                case NONE: {
                    halfWidth = size.x * 0.5 + outerFeather;
                    halfHeight = size.y * 0.5 + outerFeather;
                    innerMiddleX = 0.0;
                    innerMiddleY = 0.0;
                    outerMiddleX = size.x * 0.5;
                    outerMiddleY = size.y * 0.5;
                    tex1d = this.createRectangleTextures(texSize, 0.0, 0.0, 0.0, outerFeather, gl);
                    break;
                }
                default: {
                    halfWidth = size.x * 0.5 + thickness * 0.5 + outerFeather;
                    halfHeight = size.y * 0.5 + thickness * 0.5 + outerFeather;
                    innerMiddleX = size.x * 0.5 - thickness * 0.5;
                    innerMiddleY = size.y * 0.5 - thickness * 0.5;
                    outerMiddleX = size.x * 0.5 + thickness * 0.5;
                    outerMiddleY = size.y * 0.5 + thickness * 0.5;
                    tex1d = this.createRectangleTextures(texSize, innerMiddleX, innerMiddleY, innerFeather, outerFeather, gl);
                }
            }
            gl.glPushAttrib(262145);
            try {
                IVideoBuffer result;
                rectangle = this.context.createVideoBuffer(bounds);
                VideoEffectUtil.clearTexture(rectangle, gl);
                int w = bounds.width;
                int h = bounds.height;
                VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
                gl.glFramebufferTexture2D(36160, 36064, 34037, rectangle.getTexture(), 0);
                gl.glDrawBuffer(36064);
                final float a = (float)(color.a * (blendMode == BlendMode.NONE ? opacity : 1.0));
                final float r = (float)color.r * a;
                final float g = (float)color.g * a;
                final float b = (float)color.b * a;
                gl.glColor4f(r, g, b, a);
                if (invert) {
                    gl.glBegin(7);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glVertex2f((float)w, 0.0f);
                    gl.glVertex2f((float)w, (float)h);
                    gl.glVertex2f(0.0f, (float)h);
                    gl.glEnd();
                }
                gl.glTranslatef((float)(center.x - bounds.x), (float)(center.y - bounds.y), 0.0f);
                gl.glActiveTexture(33984);
                gl.glBindTexture(3552, tex1d[0]);
                gl.glActiveTexture(33985);
                gl.glBindTexture(3552, tex1d[1]);
                gl.glActiveTexture(33986);
                gl.glBindTexture(3552, tex1d[2]);
                final IShaderProgram program = invert ? this.invertSamplerProgram : this.rectangleSamplerProgram;
                program.useProgram(new Runnable(){

                    public void run() {
                        gl.glUniform1i(program.getUniformLocation("texInnerX"), 0);
                        gl.glUniform1i(program.getUniformLocation("texInnerY"), 1);
                        gl.glUniform1i(program.getUniformLocation("texOuter"), 2);
                        gl.glUniform4f(program.getUniformLocation("texSize"), (float)texSize[0], (float)texSize[1], (float)texSize[2], (float)texSize[2]);
                        gl.glUniform4f(program.getUniformLocation("texOffset"), (float)((double)texSize[0] * 0.5 - innerMiddleX), (float)((double)texSize[1] * 0.5 - innerMiddleY), (float)((double)texSize[2] * 0.5 - outerMiddleX), (float)((double)texSize[2] * 0.5 - outerMiddleY));
                        gl.glUniform2f(program.getUniformLocation("center"), (float)(center.x - bounds.x), (float)(center.y - bounds.y));
                        gl.glUniform4f(program.getUniformLocation("color"), r, g, b, a);
                        gl.glBegin(7);
                        gl.glVertex2f((float)(-(halfWidth + 2.0)), (float)(-(halfHeight + 2.0)));
                        gl.glVertex2f((float)(halfWidth + 2.0), (float)(-(halfHeight + 2.0)));
                        gl.glVertex2f((float)(halfWidth + 2.0), (float)(halfHeight + 2.0));
                        gl.glVertex2f((float)(-(halfWidth + 2.0)), (float)(halfHeight + 2.0));
                        gl.glEnd();
                    }
                });
                if (blendMode == BlendMode.NONE) {
                    result = rectangle;
                    rectangle = null;
                } else {
                    result = this.blendModeShaders.blend(rectangle, original, blendMode, opacity);
                }
                iVideoBuffer = result;
            }
            catch (Throwable throwable) {
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                gl.glPopAttrib();
                throw throwable;
            }
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            gl.glPopAttrib();
            return iVideoBuffer;
        }
        finally {
            if (original != null) {
                original.dispose();
            }
            if (rectangle != null) {
                rectangle.dispose();
            }
            if (tex1d != null) {
                gl.glDeleteTextures(3, tex1d, 0);
            }
        }
    }

    private int[] createRectangleTextures(int[] texSize, double innerMiddleX, double innerMiddleY, double innerFeather, double outerFeather, GL2 gl) {
        int[] tex1d = null;
        try {
            tex1d = new int[3];
            gl.glGenTextures(3, tex1d, 0);
            if (innerMiddleX <= 0.0 && innerFeather == 0.0) {
                this.copyTextureData(new float[]{0.0f, 0.0f}, 2, tex1d[0], gl);
                texSize[0] = 2;
            } else {
                texSize[0] = this.createRectangleTexture(innerFeather, tex1d[0], gl);
            }
            if (innerMiddleY <= 0.0 && innerFeather == 0.0) {
                this.copyTextureData(new float[]{0.0f, 0.0f}, 2, tex1d[1], gl);
                texSize[1] = 2;
            } else {
                texSize[1] = this.createRectangleTexture(innerFeather, tex1d[1], gl);
            }
            texSize[2] = this.createRectangleTexture(outerFeather, tex1d[2], gl);
            int[] result = tex1d;
            tex1d = null;
            int[] nArray = result;
            return nArray;
        }
        finally {
            if (tex1d != null) {
                gl.glDeleteTextures(3, tex1d, 0);
            }
        }
    }

    private int createRectangleTexture(double feather, int tex1d, GL2 gl) {
        IArray data = null;
        try {
            int halfLen = (int)Math.ceil(feather) + 1;
            data = this.arrayPools.getFloatArray(halfLen * 2);
            float[] array = (float[])data.getArray();
            int arrayLen = data.getLength();
            int i = 0;
            while (i < arrayLen) {
                double r = (double)i + 0.5;
                double d = r <= (double)halfLen - feather ? 1.0 : (r >= (double)halfLen + feather ? 0.0 : 0.5 * (1.0 - Math.cos(Math.PI * 2 * (r - ((double)halfLen + feather)) / (4.0 * feather))));
                array[i] = (float)d;
                ++i;
            }
            this.copyTextureData(array, arrayLen, tex1d, gl);
            int n = arrayLen;
            return n;
        }
        finally {
            if (data != null) {
                data.release();
            }
        }
    }

    private void copyTextureData(float[] array, int arrayLen, int tex1d, GL2 gl) {
        try {
            gl.glActiveTexture(33984);
            gl.glBindTexture(3552, tex1d);
            gl.glTexParameteri(3552, 10241, 9729);
            gl.glTexParameteri(3552, 10240, 9729);
            gl.glTexParameteri(3552, 10242, 33071);
            gl.glTexParameteri(3552, 10243, 33071);
            FloatBuffer buffer = FloatBuffer.wrap(array, 0, arrayLen);
            switch (this.context.getColorMode()) {
                case RGBA8: {
                    gl.glTexImage1D(3552, 0, 32828, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA16: {
                    gl.glTexImage1D(3552, 0, 32830, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA16_FLOAT: {
                    gl.glTexImage1D(3552, 0, 34844, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA32_FLOAT: {
                    gl.glTexImage1D(3552, 0, 34838, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown ColorMode: " + this.context.getColorMode());
                }
            }
        }
        finally {
            gl.glActiveTexture(33984);
            gl.glBindTexture(3552, 0);
        }
    }

    private static final String[] createSamplerProgram(boolean invert) {
        return new String[]{"uniform sampler1D texInnerX;", "uniform sampler1D texInnerY;", "uniform sampler1D texOuter;", "uniform vec4 texSize;", "uniform vec4 texOffset;", "uniform vec2 center;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec2 delta = abs(gl_FragCoord.st - center);", "\tvec4 texCoord = (vec4(delta, delta) + texOffset) / texSize;", "", "\tfloat a0 = texture1D(texInnerX, texCoord.x).a;", "\tfloat a1 = texture1D(texInnerY, texCoord.y).a;", "\tfloat a2 = texture1D(texOuter, texCoord.z).a;", "\tfloat a3 = texture1D(texOuter, texCoord.w).a;", "", invert ? "\tgl_FragColor = color * (1.0 - (1.0-a0*a1)*(a2*a3));" : "\tgl_FragColor = color * (1.0-a0*a1)*(a2*a3);", "}"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Edge {
        NONE,
        THICKNESS,
        P_THICKNESS,
        P_THICKNESS_P_FEATHER;

    }
}

