/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.keying;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import ch.kuramo.javie.effects.keying.KeyingShaders;
import ch.kuramo.javie.effects.keying.Smoothing;
import javax.media.opengl.GL2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlueGreenScreenKeyBase {
    private final IVideoEffectContext context;
    private final IShaderProgram keyingProgram;
    private final IShaderProgram maskOnlyProgram;
    private final IShaderProgram smoothingLowProgram;
    private final IShaderProgram smoothingHighProgram;

    protected BlueGreenScreenKeyBase(IVideoEffectContext context, IShaderRegistry shaders, boolean blue) {
        this.context = context;
        if (blue) {
            this.keyingProgram = shaders.getProgram(KeyingShaders.class, "BLUE_SCREEN_KEY");
            this.maskOnlyProgram = shaders.getProgram(KeyingShaders.class, "BLUE_SCREEN_KEY_MASK_ONLY");
        } else {
            this.keyingProgram = shaders.getProgram(KeyingShaders.class, "GREEN_SCREEN_KEY");
            this.maskOnlyProgram = shaders.getProgram(KeyingShaders.class, "GREEN_SCREEN_KEY_MASK_ONLY");
        }
        this.smoothingLowProgram = shaders.getProgram(KeyingShaders.class, "SMOOTHING_LOW");
        this.smoothingHighProgram = shaders.getProgram(KeyingShaders.class, "SMOOTHING_HIGH");
    }

    protected IVideoBuffer doKeying(IAnimatableDouble threshold, IAnimatableDouble cutoff, IAnimatableBoolean maskOnly, IAnimatableEnum<Smoothing> smoothing) {
        double t = (Double)this.context.value((IAnimatableValue)threshold) / 100.0;
        double c = (Double)this.context.value((IAnimatableValue)cutoff) / 100.0;
        boolean mask = (Boolean)this.context.value((IAnimatableValue)maskOnly);
        Smoothing sm = mask ? Smoothing.NONE : (Smoothing)((Object)this.context.value(smoothing));
        double t_minus_c = t - c;
        if (t_minus_c == 0.0) {
            if (t == 0.0) {
                t_minus_c = Double.POSITIVE_INFINITY;
            } else if (t == 1.0) {
                t = Double.POSITIVE_INFINITY;
            }
        }
        final float ft = (float)t;
        final float ftc = (float)t_minus_c;
        IVideoBuffer input = null;
        IVideoBuffer buf = null;
        try {
            IShaderProgram program2;
            input = this.context.doPreviousEffect();
            VideoBounds bounds = input.getBounds();
            if (bounds.isEmpty()) {
                IVideoBuffer output = input;
                input = null;
                IVideoBuffer iVideoBuffer = output;
                return iVideoBuffer;
            }
            final int w = bounds.width;
            final int h = bounds.height;
            buf = this.context.createVideoBuffer(bounds);
            final GL2 gl = this.context.getGL().getGL2();
            VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
            gl.glFramebufferTexture2D(36160, 36064, 34037, buf.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, input.getTexture());
            final IShaderProgram program1 = mask ? this.maskOnlyProgram : this.keyingProgram;
            program1.useProgram(new Runnable(){

                public void run() {
                    gl.glUniform1i(program1.getUniformLocation("texture"), 0);
                    gl.glUniform1f(program1.getUniformLocation("threshold"), ft);
                    gl.glUniform1f(program1.getUniformLocation("t_minus_c"), ftc);
                    gl.glBegin(7);
                    gl.glTexCoord2f(0.0f, 0.0f);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glTexCoord2f((float)w, 0.0f);
                    gl.glVertex2f((float)w, 0.0f);
                    gl.glTexCoord2f((float)w, (float)h);
                    gl.glVertex2f((float)w, (float)h);
                    gl.glTexCoord2f(0.0f, (float)h);
                    gl.glVertex2f(0.0f, (float)h);
                    gl.glEnd();
                }
            });
            switch (sm) {
                case LOW: {
                    program2 = this.smoothingLowProgram;
                    break;
                }
                case HIGH: {
                    program2 = this.smoothingHighProgram;
                    break;
                }
                default: {
                    program2 = null;
                }
            }
            if (program2 != null) {
                IVideoBuffer tmp = input;
                input = buf;
                buf = tmp;
                gl.glFramebufferTexture2D(36160, 36064, 34037, buf.getTexture(), 0);
                gl.glBindTexture(34037, input.getTexture());
                program2.useProgram(new Runnable(){

                    public void run() {
                        gl.glUniform1i(program2.getUniformLocation("texture"), 0);
                        gl.glBegin(7);
                        gl.glTexCoord2f(0.0f, 0.0f);
                        gl.glVertex2f(0.0f, 0.0f);
                        gl.glTexCoord2f((float)w, 0.0f);
                        gl.glVertex2f((float)w, 0.0f);
                        gl.glTexCoord2f((float)w, (float)h);
                        gl.glVertex2f((float)w, (float)h);
                        gl.glTexCoord2f(0.0f, (float)h);
                        gl.glVertex2f(0.0f, (float)h);
                        gl.glEnd();
                    }
                });
            }
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            IVideoBuffer output = buf;
            buf = null;
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
            if (buf != null) {
                buf.dispose();
            }
        }
    }
}

