/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.keying;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import ch.kuramo.javie.effects.keying.KeyingShaders;
import ch.kuramo.javie.effects.keying.Smoothing;
import com.google.inject.Inject;
import javax.media.opengl.GL2;

@Effect(id="ch.kuramo.javie.ChromaKey", category="ch.kuramo.javie.api.effectCategory.keying")
public class ChromaKey {
    @Property(value="1,1,1")
    private IAnimatableColor keyColor;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble similarity;
    @Property(value="10", min="0", max="100")
    private IAnimatableDouble blend;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble threshold;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble cutoff;
    @Property
    private IAnimatableEnum<Smoothing> smoothing;
    @Property
    private IAnimatableBoolean maskOnly;
    private final IVideoEffectContext context;
    private final IShaderProgram keyingProgram;
    private final IShaderProgram maskOnlyProgram;
    private final IShaderProgram smoothingLowProgram;
    private final IShaderProgram smoothingHighProgram;

    @Inject
    public ChromaKey(IVideoEffectContext context, IShaderRegistry shaders) {
        this.context = context;
        this.keyingProgram = shaders.getProgram(KeyingShaders.class, "CHROMA_KEY");
        this.maskOnlyProgram = shaders.getProgram(KeyingShaders.class, "CHROMA_KEY_MASK_ONLY");
        this.smoothingLowProgram = shaders.getProgram(KeyingShaders.class, "CHROMA_KEY_SMOOTHING_LOW");
        this.smoothingHighProgram = shaders.getProgram(KeyingShaders.class, "CHROMA_KEY_SMOOTHING_HIGH");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer input = null;
        IVideoBuffer keyedOut = null;
        IVideoBuffer smoothMask = null;
        try {
            IShaderProgram program2;
            int h;
            int w;
            GL2 gl;
            Smoothing smoothing;
            block19: {
                IVideoBuffer iVideoBuffer;
                input = this.context.doPreviousEffect();
                VideoBounds bounds = input.getBounds();
                if (bounds.isEmpty()) {
                    IVideoBuffer output = input;
                    input = null;
                    IVideoBuffer iVideoBuffer2 = output;
                    return iVideoBuffer2;
                }
                Color keyColor = (Color)this.context.value((IAnimatableValue)this.keyColor);
                final double similarity = (Double)this.context.value((IAnimatableValue)this.similarity) / 100.0 * 0.4;
                final double blend = (Double)this.context.value((IAnimatableValue)this.blend) / 100.0 * 0.4;
                final double threshold = (Double)this.context.value((IAnimatableValue)this.threshold) / 100.0;
                final double cutoff = (Double)this.context.value((IAnimatableValue)this.cutoff) / 100.0;
                smoothing = (Smoothing)((Object)this.context.value(this.smoothing));
                boolean maskOnly = (Boolean)this.context.value((IAnimatableValue)this.maskOnly);
                double r = keyColor.r;
                double g = keyColor.g;
                double b = keyColor.b;
                final double u = -0.14713 * r - 0.28886 * g + 0.436 * b;
                final double v = 0.615 * r - 0.51499 * g - 0.10001 * b;
                gl = this.context.getGL().getGL2();
                gl.glPushAttrib(262145);
                try {
                    w = bounds.width;
                    h = bounds.height;
                    VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
                    keyedOut = this.context.createVideoBuffer(bounds);
                    gl.glFramebufferTexture2D(36160, 36064, 34037, keyedOut.getTexture(), 0);
                    if (smoothing == Smoothing.NONE || maskOnly) {
                        gl.glDrawBuffer(36064);
                    } else {
                        smoothMask = this.context.createVideoBuffer(bounds);
                        gl.glFramebufferTexture2D(36160, 36065, 34037, smoothMask.getTexture(), 0);
                        gl.glDrawBuffers(2, new int[]{36064, 36065}, 0);
                    }
                    gl.glActiveTexture(33984);
                    gl.glBindTexture(34037, input.getTexture());
                    gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                    final IShaderProgram program1 = maskOnly ? this.maskOnlyProgram : this.keyingProgram;
                    program1.useProgram(new Runnable(){

                        public void run() {
                            gl.glUniform1i(program1.getUniformLocation("texture"), 0);
                            gl.glUniform2f(program1.getUniformLocation("keyUV"), (float)u, (float)v);
                            gl.glUniform1f(program1.getUniformLocation("similarity"), (float)similarity);
                            gl.glUniform1f(program1.getUniformLocation("blend"), (float)blend);
                            gl.glUniform1f(program1.getUniformLocation("t_minus_c"), (float)(threshold - cutoff));
                            gl.glUniform1f(program1.getUniformLocation("cutoff"), (float)cutoff);
                            gl.glBegin(7);
                            gl.glTexCoord2f(0.0f, 0.0f);
                            gl.glVertex2f(0.0f, 0.0f);
                            gl.glTexCoord2f((float)w, 0.0f);
                            gl.glVertex2f((float)w, 0.0f);
                            gl.glTexCoord2f((float)w, (float)h);
                            gl.glVertex2f((float)w, (float)h);
                            gl.glTexCoord2f(0.0f, (float)h);
                            gl.glVertex2f(0.0f, (float)h);
                            gl.glEnd();
                        }
                    });
                    if (smoothMask != null) break block19;
                    IVideoBuffer output = keyedOut;
                    keyedOut = null;
                    iVideoBuffer = output;
                }
                catch (Throwable throwable) {
                    gl.glPopAttrib();
                    gl.glFramebufferTexture2D(36160, 36065, 34037, 0, 0);
                    gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                    throw throwable;
                }
                gl.glPopAttrib();
                gl.glFramebufferTexture2D(36160, 36065, 34037, 0, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return iVideoBuffer;
            }
            switch (smoothing) {
                case LOW: {
                    program2 = this.smoothingLowProgram;
                    break;
                }
                case HIGH: {
                    program2 = this.smoothingHighProgram;
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            gl.glFramebufferTexture2D(36160, 36064, 34037, input.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, keyedOut.getTexture());
            gl.glActiveTexture(33985);
            gl.glBindTexture(34037, smoothMask.getTexture());
            program2.useProgram(new Runnable(){

                public void run() {
                    gl.glUniform1i(program2.getUniformLocation("tex0"), 0);
                    gl.glUniform1i(program2.getUniformLocation("tex1"), 1);
                    gl.glBegin(7);
                    gl.glTexCoord2f(0.0f, 0.0f);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glTexCoord2f((float)w, 0.0f);
                    gl.glVertex2f((float)w, 0.0f);
                    gl.glTexCoord2f((float)w, (float)h);
                    gl.glVertex2f((float)w, (float)h);
                    gl.glTexCoord2f(0.0f, (float)h);
                    gl.glVertex2f(0.0f, (float)h);
                    gl.glEnd();
                }
            });
            IVideoBuffer output = input;
            input = null;
            IVideoBuffer iVideoBuffer = output;
            gl.glPopAttrib();
            gl.glFramebufferTexture2D(36160, 36065, 34037, 0, 0);
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            return iVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
            if (keyedOut != null) {
                keyedOut.dispose();
            }
            if (smoothMask != null) {
                smoothMask.dispose();
            }
        }
    }
}

