/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.keying;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import com.google.inject.Inject;
import javax.media.opengl.GL2;

@Effect(id="ch.kuramo.javie.ColorChart", category="ch.kuramo.javie.api.effectCategory.keying")
public class ColorChart {
    @Property(value="HSL")
    private IAnimatableEnum<ChartType> chartType;
    @Property(value="0.5", min="0", max="1.0")
    private IAnimatableDouble luma;
    @Property
    private IAnimatableVec2d location;
    @Property(value="100", min="0")
    private IAnimatableDouble size;
    private final IVideoEffectContext context;
    private final IShaderProgram yuvProgram;
    private final IShaderProgram hslProgram;
    @ShaderSource
    public static final String[] YUV_CHART = new String[]{"uniform vec2 location;", "uniform float size;", "uniform float luma;", "", "", "const vec3 rVec = vec3(1.0,  0.0    , -1.13983);", "const vec3 gVec = vec3(1.0, -0.39465,  0.58060);", "const vec3 bVec = vec3(1.0,  2.03211,  0.0);", "", "const vec3 vec3_000 = vec3(0.0);", "const vec3 vec3_111 = vec3(1.0);", "", "void main(void)", "{", "\tvec3 yuv = vec3(luma, (gl_FragCoord.xy-location)/size-0.5);", "\tvec3 rgb = vec3(dot(yuv, rVec), dot(yuv, gVec), dot(yuv, bVec));", "", "\tif (all(greaterThanEqual(rgb, vec3_000)) && all(lessThanEqual(rgb, vec3_111))) {", "\t\tgl_FragColor = vec4(rgb, 1.0);", "\t} else {", "\t\tgl_FragColor = vec4(0.5, 0.5, 0.5, 1.0);", "\t}", "}"};
    @ShaderSource(attach={"ch.kuramo.javie.effects.noiseGrain.FractalNoise.hsl2rgb"})
    public static final String[] HSL_CHART = new String[]{"uniform vec2 center;", "uniform float radius;", "uniform float luma;", "", "const float PI2 = 2.0*3.14159265358979323846264;", "vec3 hsl2rgb(vec3 hsl);", "", "void main(void)", "{", "\tvec2 xy = gl_FragCoord.xy-center;", "\tfloat h = -0.25-atan(xy.y, xy.x)/PI2;", "\tfloat s = distance(gl_FragCoord.xy, center)/radius;", "\tif (s <= 1.0) {", "\t\tvec3 hsl = vec3(h-floor(h), s, luma);", "\t\tvec3 rgb = hsl2rgb(hsl);", "\t\tgl_FragColor = vec4(rgb, 1.0);", "\t} else {", "\t\tgl_FragColor = vec4(0.5, 0.5, 0.5, 1.0);", "\t}", "}"};

    @Inject
    public ColorChart(IVideoEffectContext context, IShaderRegistry shaders) {
        this.context = context;
        this.yuvProgram = shaders.getProgram(ColorChart.class, "YUV_CHART");
        this.hslProgram = shaders.getProgram(ColorChart.class, "HSL_CHART");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer input = null;
        try {
            input = this.context.doPreviousEffect();
            VideoBounds bounds = input.getBounds();
            if (bounds.isEmpty()) {
                IVideoBuffer output = input;
                input = null;
                IVideoBuffer iVideoBuffer = output;
                return iVideoBuffer;
            }
            ChartType chartType = (ChartType)((Object)this.context.value(this.chartType));
            double luma = (Double)this.context.value((IAnimatableValue)this.luma);
            Resolution resolution = this.context.getVideoResolution();
            Vec2d location = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.location));
            double size = resolution.scale(((Double)this.context.value((IAnimatableValue)this.size)).doubleValue());
            GL2 gl = this.context.getGL().getGL2();
            gl.glPushAttrib(1);
            try {
                int w = bounds.width;
                int h = bounds.height;
                VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
                gl.glFramebufferTexture2D(36160, 36064, 34037, input.getTexture(), 0);
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                switch (chartType) {
                    case YUV: {
                        this.drawYUVChart(location, size, luma, gl);
                        break;
                    }
                    case HSL: {
                        this.drawHSLChart(location, size, luma, gl);
                    }
                }
            }
            finally {
                gl.glPopAttrib();
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            }
            IVideoBuffer result = input;
            input = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
        }
    }

    private void drawYUVChart(final Vec2d location, final double size, final double luma, final GL2 gl) {
        this.yuvProgram.useProgram(new Runnable(){

            public void run() {
                gl.glUniform2f(ColorChart.this.yuvProgram.getUniformLocation("location"), (float)location.x, (float)location.y);
                gl.glUniform1f(ColorChart.this.yuvProgram.getUniformLocation("size"), (float)size);
                gl.glUniform1f(ColorChart.this.yuvProgram.getUniformLocation("luma"), (float)luma);
                gl.glBegin(7);
                gl.glVertex2f((float)location.x, (float)location.y);
                gl.glVertex2f((float)(location.x + size), (float)location.y);
                gl.glVertex2f((float)(location.x + size), (float)(location.y + size));
                gl.glVertex2f((float)location.x, (float)(location.y + size));
                gl.glEnd();
            }
        });
    }

    private void drawHSLChart(final Vec2d location, final double size, final double luma, final GL2 gl) {
        this.hslProgram.useProgram(new Runnable(){

            public void run() {
                double radius = size * 0.5;
                gl.glUniform2f(ColorChart.this.hslProgram.getUniformLocation("center"), (float)(location.x + radius), (float)(location.y + radius));
                gl.glUniform1f(ColorChart.this.hslProgram.getUniformLocation("radius"), (float)radius);
                gl.glUniform1f(ColorChart.this.hslProgram.getUniformLocation("luma"), (float)luma);
                gl.glBegin(7);
                gl.glVertex2f((float)location.x, (float)location.y);
                gl.glVertex2f((float)(location.x + size), (float)location.y);
                gl.glVertex2f((float)(location.x + size), (float)(location.y + size));
                gl.glVertex2f((float)location.x, (float)(location.y + size));
                gl.glEnd();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChartType {
        HSL,
        YUV;

    }
}

