/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.keying;

import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import ch.kuramo.javie.effects.blurSharpen.BlurUtil;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;

public class GarbageMatteBase {
    protected final IVideoEffectContext context;
    protected final IAntiAliasSupport aaSupport;
    protected final IShaderRegistry shaders;

    protected GarbageMatteBase(IVideoEffectContext context, IAntiAliasSupport aaSupport, IShaderRegistry shaders) {
        this.context = context;
        this.aaSupport = aaSupport;
        this.shaders = shaders;
    }

    protected IVideoBuffer doMask(final boolean invert, final Vec2d ... points) {
        IVideoBuffer iVideoBuffer;
        IVideoBuffer dst;
        IVideoBuffer src;
        block16: {
            VideoBounds bounds;
            GLUtessellator tessellator;
            block13: {
                IVideoBuffer iVideoBuffer2;
                block14: {
                    src = null;
                    dst = null;
                    tessellator = null;
                    try {
                        src = this.context.doPreviousEffect();
                        bounds = src.getBounds();
                        if (!bounds.isEmpty()) break block13;
                        IVideoBuffer result = src;
                        src = null;
                        iVideoBuffer2 = result;
                        if (tessellator == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (tessellator != null) {
                            GLU.gluDeleteTess(tessellator);
                        }
                        if (dst != null) {
                            dst.dispose();
                        }
                        if (src != null) {
                            src.dispose();
                        }
                        throw throwable;
                    }
                    GLU.gluDeleteTess(tessellator);
                }
                if (dst != null) {
                    dst.dispose();
                }
                if (src != null) {
                    src.dispose();
                }
                return iVideoBuffer2;
            }
            GL2 gl = this.context.getGL().getGL2();
            GLU glu = this.context.getGLU();
            dst = this.context.createVideoBuffer(bounds);
            VideoEffectUtil.clearTexture(dst, gl);
            tessellator = GLU.gluNewTess();
            TessellatorCallback callback = new TessellatorCallback(-bounds.x, -bounds.y, gl, glu);
            GLU.gluTessCallback((GLUtessellator)tessellator, (int)100100, (GLUtessellatorCallback)callback);
            GLU.gluTessCallback((GLUtessellator)tessellator, (int)100102, (GLUtessellatorCallback)callback);
            GLU.gluTessCallback((GLUtessellator)tessellator, (int)100101, (GLUtessellatorCallback)callback);
            GLU.gluTessCallback((GLUtessellator)tessellator, (int)100105, (GLUtessellatorCallback)callback);
            GLU.gluTessCallback((GLUtessellator)tessellator, (int)100103, (GLUtessellatorCallback)callback);
            gl.glPushAttrib(270337);
            try {
                final double x = bounds.x;
                final double y = bounds.y;
                final int w = bounds.width;
                final int h = bounds.height;
                VideoEffectUtil.ortho2D(gl, glu, w, h);
                gl.glTranslatef((float)(-x), (float)(-y), 0.0f);
                gl.glFramebufferTexture2D(36160, 36064, 34037, dst.getTexture(), 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, src.getTexture());
                gl.glEnable(34037);
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                final GLUtessellator tess = tessellator;
                this.aaSupport.antiAlias(w, h, new Runnable(){

                    public void run() {
                        int n;
                        int n2;
                        Object object;
                        GLU.gluTessBeginPolygon((GLUtessellator)tess, null);
                        if (invert) {
                            GLU.gluTessBeginContour((GLUtessellator)tess);
                            double[][] dArrayArray = new double[][]{{x, y, 0.0}, {x + (double)w, y, 0.0}, {x + (double)w, y + (double)h, 0.0}, {x, y + (double)h, 0.0}};
                            object = dArrayArray;
                            n2 = dArrayArray.length;
                            n = 0;
                            while (n < n2) {
                                Vec2d vertex = object[n];
                                GLU.gluTessVertex((GLUtessellator)tess, (double[])vertex, (int)0, (Object)vertex);
                                ++n;
                            }
                            GLU.gluTessEndContour((GLUtessellator)tess);
                        }
                        GLU.gluTessBeginContour((GLUtessellator)tess);
                        object = points;
                        n2 = points.length;
                        n = 0;
                        while (n < n2) {
                            Vec2d pt = object[n];
                            double[] vertex = new double[]{pt.x, pt.y, 0.0};
                            GLU.gluTessVertex((GLUtessellator)tess, (double[])vertex, (int)0, (Object)vertex);
                            ++n;
                        }
                        GLU.gluTessEndContour((GLUtessellator)tess);
                        GLU.gluTessEndPolygon((GLUtessellator)tess);
                    }
                });
            }
            finally {
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                gl.glPopAttrib();
            }
            IVideoBuffer result = dst;
            dst = null;
            iVideoBuffer = result;
            if (tessellator == null) break block16;
            GLU.gluDeleteTess((GLUtessellator)tessellator);
        }
        if (dst != null) {
            dst.dispose();
        }
        if (src != null) {
            src.dispose();
        }
        return iVideoBuffer;
    }

    protected IVideoBuffer doMask(final boolean invert, double feather, final Vec2d ... points) {
        IVideoBuffer iVideoBuffer;
        IVideoBuffer mask;
        IVideoBuffer src;
        block16: {
            VideoBounds bounds;
            GLUtessellator tessellator;
            block13: {
                IVideoBuffer iVideoBuffer2;
                block14: {
                    src = null;
                    mask = null;
                    tessellator = null;
                    try {
                        src = this.context.doPreviousEffect();
                        bounds = src.getBounds();
                        if (!bounds.isEmpty()) break block13;
                        IVideoBuffer result = src;
                        src = null;
                        iVideoBuffer2 = result;
                        if (tessellator == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (tessellator != null) {
                            GLU.gluDeleteTess(tessellator);
                        }
                        if (mask != null) {
                            mask.dispose();
                        }
                        if (src != null) {
                            src.dispose();
                        }
                        throw throwable;
                    }
                    GLU.gluDeleteTess(tessellator);
                }
                if (mask != null) {
                    mask.dispose();
                }
                if (src != null) {
                    src.dispose();
                }
                return iVideoBuffer2;
            }
            GL2 gl = this.context.getGL().getGL2();
            GLU glu = this.context.getGLU();
            mask = this.context.createVideoBuffer(bounds);
            VideoEffectUtil.clearTexture(mask, gl);
            tessellator = GLU.gluNewTess();
            TessellatorCallback callback = new TessellatorCallback(gl, glu);
            GLU.gluTessCallback((GLUtessellator)tessellator, (int)100100, (GLUtessellatorCallback)callback);
            GLU.gluTessCallback((GLUtessellator)tessellator, (int)100102, (GLUtessellatorCallback)callback);
            GLU.gluTessCallback((GLUtessellator)tessellator, (int)100101, (GLUtessellatorCallback)callback);
            GLU.gluTessCallback((GLUtessellator)tessellator, (int)100105, (GLUtessellatorCallback)callback);
            GLU.gluTessCallback((GLUtessellator)tessellator, (int)100103, (GLUtessellatorCallback)callback);
            gl.glPushAttrib(286721);
            try {
                final double x = bounds.x;
                final double y = bounds.y;
                final int w = bounds.width;
                final int h = bounds.height;
                VideoEffectUtil.ortho2D(gl, glu, w, h);
                gl.glTranslatef((float)(-x), (float)(-y), 0.0f);
                gl.glFramebufferTexture2D(36160, 36064, 34037, mask.getTexture(), 0);
                gl.glDrawBuffer(36064);
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                final GLUtessellator tess = tessellator;
                this.aaSupport.antiAlias(w, h, new Runnable(){

                    public void run() {
                        int n;
                        int n2;
                        Object object;
                        GLU.gluTessBeginPolygon((GLUtessellator)tess, null);
                        if (invert) {
                            GLU.gluTessBeginContour((GLUtessellator)tess);
                            double[][] dArrayArray = new double[][]{{x, y, 0.0}, {x + (double)w, y, 0.0}, {x + (double)w, y + (double)h, 0.0}, {x, y + (double)h, 0.0}};
                            object = dArrayArray;
                            n2 = dArrayArray.length;
                            n = 0;
                            while (n < n2) {
                                Vec2d vertex = object[n];
                                GLU.gluTessVertex((GLUtessellator)tess, (double[])vertex, (int)0, (Object)vertex);
                                ++n;
                            }
                            GLU.gluTessEndContour((GLUtessellator)tess);
                        }
                        GLU.gluTessBeginContour((GLUtessellator)tess);
                        object = points;
                        n2 = points.length;
                        n = 0;
                        while (n < n2) {
                            Vec2d pt = object[n];
                            double[] vertex = new double[]{pt.x, pt.y, 0.0};
                            GLU.gluTessVertex((GLUtessellator)tess, (double[])vertex, (int)0, (Object)vertex);
                            ++n;
                        }
                        GLU.gluTessEndContour((GLUtessellator)tess);
                        GLU.gluTessEndPolygon((GLUtessellator)tess);
                    }
                });
                mask = this.blur(mask, feather, gl, glu);
                VideoEffectUtil.ortho2D(gl, glu, w, h);
                gl.glFramebufferTexture2D(36160, 36064, 34037, src.getTexture(), 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, mask.getTexture());
                gl.glEnable(34037);
                gl.glEnable(3042);
                gl.glBlendFuncSeparate(0, 770, 0, 770);
                gl.glBlendEquation(32774);
                gl.glBegin(7);
                gl.glTexCoord2f(0.0f, 0.0f);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glTexCoord2f((float)w, 0.0f);
                gl.glVertex2f((float)w, 0.0f);
                gl.glTexCoord2f((float)w, (float)h);
                gl.glVertex2f((float)w, (float)h);
                gl.glTexCoord2f(0.0f, (float)h);
                gl.glVertex2f(0.0f, (float)h);
                gl.glEnd();
            }
            finally {
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                gl.glPopAttrib();
            }
            IVideoBuffer result = src;
            src = null;
            iVideoBuffer = result;
            if (tessellator == null) break block16;
            GLU.gluDeleteTess((GLUtessellator)tessellator);
        }
        if (mask != null) {
            mask.dispose();
        }
        if (src != null) {
            src.dispose();
        }
        return iVideoBuffer;
    }

    private IVideoBuffer blur(IVideoBuffer input, double blur, GL2 gl, GLU glu) {
        return this.blur(input, blur, true, true, true, true, gl, glu);
    }

    private IVideoBuffer blur(IVideoBuffer input, double blur, boolean repeatEdgePixels, boolean horz, boolean vert, boolean fast, GL2 gl, GLU glu) {
        VideoBounds inputBounds = input.getBounds();
        int sampleRatio = 1;
        if (fast) {
            VideoBounds bounds = inputBounds;
            int[] nArray = BlurUtil.getDownSampleFactors(blur);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int factor = nArray[n2];
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(input, gl);
                }
                int hFactor = horz ? factor : 1;
                int vFactor = vert ? factor : 1;
                bounds = new VideoBounds(bounds.x / (double)hFactor, bounds.y / (double)vFactor, (bounds.width + hFactor - 1) / hFactor, (bounds.height + vFactor - 1) / vFactor);
                IVideoBuffer buf = this.context.createVideoBuffer(bounds);
                BlurUtil.doDownSample(input, buf, hFactor, vFactor, gl, glu, this.shaders);
                input.dispose();
                input = buf;
                sampleRatio *= factor;
                ++n2;
            }
            blur /= (double)sampleRatio;
        }
        int radius = (int)Math.ceil(blur);
        double sigma = blur / 2.5;
        double sigmaSquare = sigma * sigma;
        float[] kernel = new float[radius * 2 + 1];
        float sum = 0.0f;
        int i = 1;
        while (i <= radius) {
            float f = (float)Math.exp((double)(-i * i) / (2.0 * sigmaSquare));
            kernel[radius - i] = f;
            sum += 2.0f * f;
            ++i;
        }
        kernel[radius] = 1.0f / (sum += 1.0f);
        i = 1;
        while (i <= radius) {
            int n = radius - i;
            float f = kernel[n] / sum;
            kernel[n] = f;
            kernel[radius + i] = f;
            ++i;
        }
        IVideoBuffer buf1 = null;
        IVideoBuffer buf2 = null;
        IVideoBuffer buf3 = null;
        try {
            VideoBounds bounds;
            if (horz) {
                bounds = input.getBounds();
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(input, gl);
                } else {
                    bounds = VideoEffectUtil.expandBounds(bounds, radius, true, false);
                }
                buf1 = this.context.createVideoBuffer(bounds);
                VideoEffectUtil.convolution1D(input, buf1, true, radius, kernel, gl, glu, this.shaders);
            } else {
                buf1 = input;
                input = null;
            }
            if (vert) {
                bounds = buf1.getBounds();
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(buf1, gl);
                } else {
                    bounds = VideoEffectUtil.expandBounds(bounds, radius, false, true);
                }
                buf2 = this.context.createVideoBuffer(bounds);
                VideoEffectUtil.convolution1D(buf1, buf2, false, radius, kernel, gl, glu, this.shaders);
            } else {
                buf2 = buf1;
                buf1 = null;
            }
            if (sampleRatio != 1) {
                VideoBounds bounds2;
                int vRatio;
                int hRatio = horz ? sampleRatio : 1;
                int n = vRatio = vert ? sampleRatio : 1;
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(buf2, gl);
                    bounds2 = inputBounds;
                } else {
                    bounds2 = buf2.getBounds();
                    bounds2 = new VideoBounds(bounds2.x * (double)hRatio, bounds2.y * (double)vRatio, bounds2.width * hRatio, bounds2.height * vRatio);
                }
                buf3 = this.context.createVideoBuffer(bounds2);
                BlurUtil.doUpSample(buf2, buf3, hRatio, vRatio, gl, glu);
            } else {
                buf3 = buf2;
                buf2 = null;
            }
            IVideoBuffer iVideoBuffer = buf3;
            return iVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
            if (buf1 != null) {
                buf1.dispose();
            }
            if (buf2 != null) {
                buf2.dispose();
            }
        }
    }

    private static class TessellatorCallback
    extends GLUtessellatorCallbackAdapter {
        private final double[] texOffset;
        private final GL2 gl;
        private final GLU glu;

        private TessellatorCallback(GL2 gl, GLU glu) {
            this(null, gl, glu);
        }

        private TessellatorCallback(double texOffsetX, double texOffsetY, GL2 gl, GLU glu) {
            this(new double[]{texOffsetX, texOffsetY}, gl, glu);
        }

        private TessellatorCallback(double[] texOffset, GL2 gl, GLU glu) {
            this.texOffset = texOffset;
            this.gl = gl;
            this.glu = glu;
        }

        public void begin(int type) {
            this.gl.glBegin(type);
        }

        public void end() {
            this.gl.glEnd();
        }

        public void vertex(Object vertexData) {
            double[] vertex = (double[])vertexData;
            if (this.texOffset != null) {
                this.gl.glTexCoord2d(vertex[0] + this.texOffset[0], vertex[1] + this.texOffset[1]);
            }
            this.gl.glVertex2dv(vertex, 0);
        }

        public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
            outData[0] = new double[]{coords[0], coords[1], coords[2]};
        }

        public void error(int errnum) {
            System.err.println("Tessellation Error: " + this.glu.gluErrorString(errnum));
        }
    }
}

