/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.keying;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import ch.kuramo.javie.effects.keying.KeyingShaders;
import ch.kuramo.javie.effects.keying.Smoothing;
import com.google.inject.Inject;
import javax.media.opengl.GL2;

@Effect(id="ch.kuramo.javie.HSLKey", category="ch.kuramo.javie.api.effectCategory.keying")
public class HSLKey {
    @Property(value="1,1,1")
    private IAnimatableColor keyColor;
    @Property(value="10", min="0", max="360")
    private IAnimatableVec2d similarityHue;
    @Property(value="10", min="0", max="200")
    private IAnimatableVec2d similaritySat;
    @Property(value="10", min="0", max="100")
    private IAnimatableVec2d similarityLuma;
    @Property(value="10", min="0", max="360")
    private IAnimatableVec2d blendHue;
    @Property(value="10", min="0", max="200")
    private IAnimatableVec2d blendSat;
    @Property(value="10", min="0", max="100")
    private IAnimatableVec2d blendLuma;
    @Property(value="1", min="0", max="3")
    private IAnimatableVec2d correctionHue;
    @Property(value="1", min="0", max="2")
    private IAnimatableDouble correctionSat;
    @Property(value="1", min="0", max="1")
    private IAnimatableDouble correctionAlpha;
    @Property
    private IAnimatableEnum<Smoothing> smoothing;
    @Property
    private IAnimatableBoolean maskOnly;
    private final IVideoEffectContext context;
    private final IShaderProgram keyingProgram;
    private final IShaderProgram maskOnlyProgram;
    private final IShaderProgram smoothingLowProgram;
    private final IShaderProgram smoothingHighProgram;

    @Inject
    public HSLKey(IVideoEffectContext context, IShaderRegistry shaders) {
        this.context = context;
        this.keyingProgram = shaders.getProgram(KeyingShaders.class, "HSL_KEY");
        this.maskOnlyProgram = shaders.getProgram(KeyingShaders.class, "HSL_KEY_MASK_ONLY");
        this.smoothingLowProgram = shaders.getProgram(KeyingShaders.class, "SMOOTHING_LOW");
        this.smoothingHighProgram = shaders.getProgram(KeyingShaders.class, "SMOOTHING_HIGH");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer input = null;
        IVideoBuffer keyedOut = null;
        try {
            IShaderProgram smoothingProgram;
            int h;
            int w;
            GL2 gl;
            Smoothing smoothing;
            block16: {
                IVideoBuffer iVideoBuffer;
                input = this.context.doPreviousEffect();
                VideoBounds bounds = input.getBounds();
                if (bounds.isEmpty()) {
                    IVideoBuffer output = input;
                    input = null;
                    IVideoBuffer iVideoBuffer2 = output;
                    return iVideoBuffer2;
                }
                final Color keyColor = (Color)this.context.value((IAnimatableValue)this.keyColor);
                final Vec2d similarityHue = (Vec2d)this.context.value((IAnimatableValue)this.similarityHue);
                final Vec2d similaritySat = (Vec2d)this.context.value((IAnimatableValue)this.similaritySat);
                final Vec2d similarityLuma = (Vec2d)this.context.value((IAnimatableValue)this.similarityLuma);
                final Vec2d blendHue = (Vec2d)this.context.value((IAnimatableValue)this.blendHue);
                final Vec2d blendSat = (Vec2d)this.context.value((IAnimatableValue)this.blendSat);
                final Vec2d blendLuma = (Vec2d)this.context.value((IAnimatableValue)this.blendLuma);
                final Vec2d correctionHue = (Vec2d)this.context.value((IAnimatableValue)this.correctionHue);
                final double correctionSat = (Double)this.context.value((IAnimatableValue)this.correctionSat);
                final double correctionAlpha = (Double)this.context.value((IAnimatableValue)this.correctionAlpha);
                smoothing = (Smoothing)((Object)this.context.value(this.smoothing));
                boolean maskOnly = (Boolean)this.context.value((IAnimatableValue)this.maskOnly);
                gl = this.context.getGL().getGL2();
                gl.glPushAttrib(262145);
                try {
                    w = bounds.width;
                    h = bounds.height;
                    VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
                    keyedOut = this.context.createVideoBuffer(bounds);
                    gl.glFramebufferTexture2D(36160, 36064, 34037, keyedOut.getTexture(), 0);
                    gl.glDrawBuffer(36064);
                    gl.glActiveTexture(33984);
                    gl.glBindTexture(34037, input.getTexture());
                    gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                    final IShaderProgram program = maskOnly ? this.maskOnlyProgram : this.keyingProgram;
                    program.useProgram(new Runnable(){

                        public void run() {
                            double[] keyHSL = new double[3];
                            HSLKey.this.rgb2hsl(keyColor, keyHSL);
                            double hueMin = keyHSL[0] - similarityHue.x / 360.0;
                            double hueMax = keyHSL[0] + similarityHue.y / 360.0;
                            double satMin = keyHSL[1] - similaritySat.x / 100.0;
                            double satMax = keyHSL[1] + similaritySat.y / 100.0;
                            double lumaMin = keyHSL[2] - similarityLuma.x / 100.0;
                            double lumaMax = keyHSL[2] + similarityLuma.y / 100.0;
                            double blendHueMin = Math.max(blendHue.x / 360.0, (double)1.0E-10f);
                            double blendHueMax = Math.max(blendHue.y / 360.0, (double)1.0E-10f);
                            double blendSatMin = Math.max(blendSat.x / 100.0, (double)1.0E-10f);
                            double blendSatMax = Math.max(blendSat.y / 100.0, (double)1.0E-10f);
                            double blendLumaMin = Math.max(blendLuma.x / 100.0, (double)1.0E-10f);
                            double blendLumaMax = Math.max(blendLuma.y / 100.0, (double)1.0E-10f);
                            gl.glUniform1i(program.getUniformLocation("texture"), 0);
                            gl.glUniform3f(program.getUniformLocation("similarityMin"), (float)hueMin, (float)satMin, (float)lumaMin);
                            gl.glUniform3f(program.getUniformLocation("similarityMax"), (float)hueMax, (float)satMax, (float)lumaMax);
                            gl.glUniform3f(program.getUniformLocation("blendMin"), (float)blendHueMin, (float)blendSatMin, (float)blendLumaMin);
                            gl.glUniform3f(program.getUniformLocation("blendMax"), (float)blendHueMax, (float)blendSatMax, (float)blendLumaMax);
                            double[] bleachHSL = new double[]{keyHSL[0], 1.0, 0.5};
                            double[] bleachRGB = new double[3];
                            HSLKey.this.hsl2rgb(bleachHSL, bleachRGB);
                            gl.glUniform3f(program.getUniformLocation("bleachHSL"), (float)bleachHSL[0], (float)bleachHSL[1], (float)bleachHSL[2]);
                            gl.glUniform3f(program.getUniformLocation("bleachRGB"), (float)bleachRGB[0], (float)bleachRGB[1], (float)bleachRGB[2]);
                            gl.glUniform2f(program.getUniformLocation("correctionHue"), (float)correctionHue.x, (float)correctionHue.y);
                            gl.glUniform1f(program.getUniformLocation("correctionSat"), (float)(2.0 - correctionSat));
                            gl.glUniform1f(program.getUniformLocation("correctionAlpha"), (float)correctionAlpha);
                            gl.glBegin(7);
                            gl.glTexCoord2f(0.0f, 0.0f);
                            gl.glVertex2f(0.0f, 0.0f);
                            gl.glTexCoord2f((float)w, 0.0f);
                            gl.glVertex2f((float)w, 0.0f);
                            gl.glTexCoord2f((float)w, (float)h);
                            gl.glVertex2f((float)w, (float)h);
                            gl.glTexCoord2f(0.0f, (float)h);
                            gl.glVertex2f(0.0f, (float)h);
                            gl.glEnd();
                        }
                    });
                    if (smoothing != Smoothing.NONE && !maskOnly) break block16;
                    IVideoBuffer output = keyedOut;
                    keyedOut = null;
                    iVideoBuffer = output;
                }
                catch (Throwable throwable) {
                    gl.glPopAttrib();
                    gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                    throw throwable;
                }
                gl.glPopAttrib();
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return iVideoBuffer;
            }
            switch (smoothing) {
                case LOW: {
                    smoothingProgram = this.smoothingLowProgram;
                    break;
                }
                case HIGH: {
                    smoothingProgram = this.smoothingHighProgram;
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            gl.glFramebufferTexture2D(36160, 36064, 34037, input.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, keyedOut.getTexture());
            smoothingProgram.useProgram(new Runnable(){

                public void run() {
                    gl.glUniform1i(smoothingProgram.getUniformLocation("texture"), 0);
                    gl.glBegin(7);
                    gl.glTexCoord2f(0.0f, 0.0f);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glTexCoord2f((float)w, 0.0f);
                    gl.glVertex2f((float)w, 0.0f);
                    gl.glTexCoord2f((float)w, (float)h);
                    gl.glVertex2f((float)w, (float)h);
                    gl.glTexCoord2f(0.0f, (float)h);
                    gl.glVertex2f(0.0f, (float)h);
                    gl.glEnd();
                }
            });
            IVideoBuffer output = input;
            input = null;
            IVideoBuffer iVideoBuffer = output;
            gl.glPopAttrib();
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            return iVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
            if (keyedOut != null) {
                keyedOut.dispose();
            }
        }
    }

    private void rgb2hsl(Color rgb, double[] hsl) {
        double hue;
        double sat;
        double min = Math.min(Math.min(rgb.r, rgb.g), rgb.b);
        double max = Math.max(Math.max(rgb.r, rgb.g), rgb.b);
        double dmax = max - min;
        double luma = (max + min) * 0.5;
        if (dmax == 0.0) {
            sat = 0.0;
            hue = 0.0;
        } else {
            sat = luma < 0.5 ? dmax / (max + min) : dmax / (2.0 - max - min);
            double dr = ((max - rgb.r) / 6.0 + dmax / 2.0) / dmax;
            double dg = ((max - rgb.g) / 6.0 + dmax / 2.0) / dmax;
            double db = ((max - rgb.b) / 6.0 + dmax / 2.0) / dmax;
            double d = rgb.r == max ? db - dg : (hue = rgb.g == max ? 0.3333333333333333 + dr - db : 0.6666666666666666 + dg - dr);
            if (hue < 0.0) {
                hue += 1.0;
            } else if (hue > 1.0) {
                hue -= 1.0;
            }
        }
        hsl[0] = hue;
        hsl[1] = sat;
        hsl[2] = luma;
    }

    private void hsl2rgb(double[] hsl, double[] rgb) {
        double hue = hsl[0];
        double sat = hsl[1];
        double luma = hsl[2];
        if (hue > 1.0) {
            hue -= 1.0;
        }
        if (sat == 0.0) {
            rgb[1] = rgb[2] = luma;
            rgb[0] = rgb[2];
        } else {
            double t2 = luma < 0.5 ? luma * (1.0 + sat) : luma + sat - luma * sat;
            double t1 = luma * 2.0 - t2;
            rgb[0] = this.hue2rgb(t1, t2, hue + 0.3333333333333333);
            rgb[1] = this.hue2rgb(t1, t2, hue);
            rgb[2] = this.hue2rgb(t1, t2, hue - 0.3333333333333333);
        }
    }

    private double hue2rgb(double t1, double t2, double hue) {
        if (hue < 0.0) {
            hue += 1.0;
        } else if (hue > 1.0) {
            hue -= 1.0;
        }
        return hue * 6.0 < 1.0 ? t1 + (t2 - t1) * 6.0 * hue : (hue * 2.0 < 1.0 ? t2 : (hue * 3.0 < 2.0 ? t1 + (t2 - t1) * (0.6666666666666666 - hue) * 6.0 : t1));
    }
}

