/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.keying;

import ch.kuramo.javie.api.annotations.ShaderSource;
import java.util.ArrayList;
import java.util.Arrays;

public class KeyingShaders {
    @ShaderSource
    public static final String[] BLUE_SCREEN_KEY = new String[]{"uniform sampler2DRect texture;", "uniform float threshold;", "uniform float t_minus_c;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tvec3 rgb = color.rgb/color.a;", "\tcolor.a = min(color.a, color.a*(threshold-rgb.b*(1.0-rgb.r))/t_minus_c);", "\trgb.b = min(rgb.b, rgb.g);", "\tgl_FragColor = vec4(rgb, 1.0)*color.a;", "}"};
    @ShaderSource
    public static final String[] BLUE_SCREEN_KEY_MASK_ONLY = new String[]{"uniform sampler2DRect texture;", "uniform float threshold;", "uniform float t_minus_c;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tvec3 rgb = color.rgb/color.a;", "\tfloat a = min(color.a, color.a*(threshold-rgb.b*(1.0-rgb.r))/t_minus_c);", "\tgl_FragColor = vec4(a, a, a, 1.0);", "}"};
    @ShaderSource
    public static final String[] GREEN_SCREEN_KEY = new String[]{"uniform sampler2DRect texture;", "uniform float threshold;", "uniform float t_minus_c;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tvec3 rgb = color.rgb/color.a;", "\tcolor.a = min(color.a, color.a*(threshold-rgb.g*(1.0-rgb.r))/t_minus_c);", "\trgb.g = min(rgb.g, rgb.r);", "\tgl_FragColor = vec4(rgb, 1.0)*color.a;", "}"};
    @ShaderSource
    public static final String[] GREEN_SCREEN_KEY_MASK_ONLY = new String[]{"uniform sampler2DRect texture;", "uniform float threshold;", "uniform float t_minus_c;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tvec3 rgb = color.rgb/color.a;", "\tfloat a = min(color.a, color.a*(threshold-rgb.g*(1.0-rgb.r))/t_minus_c);", "\tgl_FragColor = vec4(a, a, a, 1.0);", "}"};
    @ShaderSource
    public static final String[] SMOOTHING_LOW = new String[]{"uniform sampler2DRect texture;", "", "void main(void)", "{", "\tvec2 coord = gl_TexCoord[0].st;", "\tvec4 sum = vec4(0.0);", "\tint n = 0;", "\tvec4 c;", "\tc = texture2DRect(texture, coord+vec2(-1.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.0625 * c; }", "\tc = texture2DRect(texture, coord+vec2( 0.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.1250 * c; }", "\tc = texture2DRect(texture, coord+vec2( 1.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.0625 * c; }", "\tc = texture2DRect(texture, coord+vec2(-1.0,  0.0)); if (c.a != 0.0) { ++n; sum += 0.1250 * c; }", "\tc = texture2DRect(texture, coord+vec2( 1.0,  0.0)); if (c.a != 0.0) { ++n; sum += 0.1250 * c; }", "\tc = texture2DRect(texture, coord+vec2(-1.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.0625 * c; }", "\tc = texture2DRect(texture, coord+vec2( 0.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.1250 * c; }", "\tc = texture2DRect(texture, coord+vec2( 1.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.0625 * c; }", "\tc = texture2DRect(texture, coord                 ); if (c.a != 0.0) { ++n; sum += 0.2500 * c; }", "", "\tgl_FragColor = (n > 0 && n < 9) ? sum : c;", "}"};
    @ShaderSource
    public static final String[] SMOOTHING_HIGH = new String[]{"uniform sampler2DRect texture;", "", "void main(void)", "{", "\tvec2 coord = gl_TexCoord[0].st;", "\tvec4 sum = vec4(0.0);", "\tint n = 0;", "\tvec4 c;", "\tc = texture2DRect(texture, coord+vec2(-2.0, -2.0)); if (c.a != 0.0) { ++n; sum += 0.003663 * c; }", "\tc = texture2DRect(texture, coord+vec2(-1.0, -2.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }", "\tc = texture2DRect(texture, coord+vec2( 0.0, -2.0)); if (c.a != 0.0) { ++n; sum += 0.025641 * c; }", "\tc = texture2DRect(texture, coord+vec2( 1.0, -2.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }", "\tc = texture2DRect(texture, coord+vec2( 2.0, -2.0)); if (c.a != 0.0) { ++n; sum += 0.003663 * c; }", "\tc = texture2DRect(texture, coord+vec2(-2.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }", "\tc = texture2DRect(texture, coord+vec2(-1.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.058608 * c; }", "\tc = texture2DRect(texture, coord+vec2( 0.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.095238 * c; }", "\tc = texture2DRect(texture, coord+vec2( 1.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.058608 * c; }", "\tc = texture2DRect(texture, coord+vec2( 2.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }", "\tc = texture2DRect(texture, coord+vec2(-2.0,  0.0)); if (c.a != 0.0) { ++n; sum += 0.025641 * c; }", "\tc = texture2DRect(texture, coord+vec2(-1.0,  0.0)); if (c.a != 0.0) { ++n; sum += 0.095238 * c; }", "\tc = texture2DRect(texture, coord+vec2( 1.0,  0.0)); if (c.a != 0.0) { ++n; sum += 0.095238 * c; }", "\tc = texture2DRect(texture, coord+vec2( 2.0,  0.0)); if (c.a != 0.0) { ++n; sum += 0.025641 * c; }", "\tc = texture2DRect(texture, coord+vec2(-2.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }", "\tc = texture2DRect(texture, coord+vec2(-1.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.058608 * c; }", "\tc = texture2DRect(texture, coord+vec2( 0.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.095238 * c; }", "\tc = texture2DRect(texture, coord+vec2( 1.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.058608 * c; }", "\tc = texture2DRect(texture, coord+vec2( 2.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }", "\tc = texture2DRect(texture, coord+vec2(-2.0,  2.0)); if (c.a != 0.0) { ++n; sum += 0.003663 * c; }", "\tc = texture2DRect(texture, coord+vec2(-1.0,  2.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }", "\tc = texture2DRect(texture, coord+vec2( 0.0,  2.0)); if (c.a != 0.0) { ++n; sum += 0.025641 * c; }", "\tc = texture2DRect(texture, coord+vec2( 1.0,  2.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }", "\tc = texture2DRect(texture, coord+vec2( 2.0,  2.0)); if (c.a != 0.0) { ++n; sum += 0.003663 * c; }", "\tc = texture2DRect(texture, coord                 ); if (c.a != 0.0) { ++n; sum += 0.150183 * c; }", "", "\tgl_FragColor = (n > 0 && n < 25) ? sum : c;", "}"};
    @ShaderSource
    public static final String[] CHROMA_KEY = KeyingShaders.createChromaKeySource(false);
    @ShaderSource
    public static final String[] CHROMA_KEY_MASK_ONLY = KeyingShaders.createChromaKeySource(true);
    @ShaderSource
    public static final String[] CHROMA_KEY_SMOOTHING_LOW = new String[]{"uniform sampler2DRect tex0;", "uniform sampler2DRect tex1;", "", "void main(void)", "{", "\tvec2 coord = gl_TexCoord[0].st;", "\tvec4 sum = vec4(0.0);", "\tint n = 0;", "\tvec2 d;", "\tvec4 c;", "\td = coord+vec2(-1.0, -1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.0625 * texture2DRect(tex0, d);", "\td = coord+vec2( 0.0, -1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.1250 * texture2DRect(tex0, d);", "\td = coord+vec2( 1.0, -1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.0625 * texture2DRect(tex0, d);", "\td = coord+vec2(-1.0,  0.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.1250 * texture2DRect(tex0, d);", "\td = coord+vec2( 1.0,  0.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.1250 * texture2DRect(tex0, d);", "\td = coord+vec2(-1.0,  1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.0625 * texture2DRect(tex0, d);", "\td = coord+vec2( 0.0,  1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.1250 * texture2DRect(tex0, d);", "\td = coord+vec2( 1.0,  1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.0625 * texture2DRect(tex0, d);", "\td = coord                 ; c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; c = texture2DRect(tex0, d); sum += 0.2500 * c;", "", "\tgl_FragColor = (n > 0 && n < 9) ? sum : c;", "}"};
    @ShaderSource
    public static final String[] CHROMA_KEY_SMOOTHING_HIGH = new String[]{"uniform sampler2DRect tex0;", "uniform sampler2DRect tex1;", "", "void main(void)", "{", "\tvec2 coord = gl_TexCoord[0].st;", "\tvec4 sum = vec4(0.0);", "\tint n = 0;", "\tvec2 d;", "\tvec4 c;", "\td = coord+vec2(-2.0, -2.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.003663 * texture2DRect(tex0, d);", "\td = coord+vec2(-1.0, -2.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.014652 * texture2DRect(tex0, d);", "\td = coord+vec2( 0.0, -2.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.025641 * texture2DRect(tex0, d);", "\td = coord+vec2( 1.0, -2.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.014652 * texture2DRect(tex0, d);", "\td = coord+vec2( 2.0, -2.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.003663 * texture2DRect(tex0, d);", "\td = coord+vec2(-2.0, -1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.014652 * texture2DRect(tex0, d);", "\td = coord+vec2(-1.0, -1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.058608 * texture2DRect(tex0, d);", "\td = coord+vec2( 0.0, -1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.095238 * texture2DRect(tex0, d);", "\td = coord+vec2( 1.0, -1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.058608 * texture2DRect(tex0, d);", "\td = coord+vec2( 2.0, -1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.014652 * texture2DRect(tex0, d);", "\td = coord+vec2(-2.0,  0.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.025641 * texture2DRect(tex0, d);", "\td = coord+vec2(-1.0,  0.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.095238 * texture2DRect(tex0, d);", "\td = coord+vec2( 1.0,  0.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.095238 * texture2DRect(tex0, d);", "\td = coord+vec2( 2.0,  0.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.025641 * texture2DRect(tex0, d);", "\td = coord+vec2(-2.0,  1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.014652 * texture2DRect(tex0, d);", "\td = coord+vec2(-1.0,  1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.058608 * texture2DRect(tex0, d);", "\td = coord+vec2( 0.0,  1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.095238 * texture2DRect(tex0, d);", "\td = coord+vec2( 1.0,  1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.058608 * texture2DRect(tex0, d);", "\td = coord+vec2( 2.0,  1.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.014652 * texture2DRect(tex0, d);", "\td = coord+vec2(-2.0,  2.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.003663 * texture2DRect(tex0, d);", "\td = coord+vec2(-1.0,  2.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.014652 * texture2DRect(tex0, d);", "\td = coord+vec2( 0.0,  2.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.025641 * texture2DRect(tex0, d);", "\td = coord+vec2( 1.0,  2.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.014652 * texture2DRect(tex0, d);", "\td = coord+vec2( 2.0,  2.0); c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; sum += 0.003663 * texture2DRect(tex0, d);", "\td = coord                 ; c = texture2DRect(tex1, d); if (c.a != 0.0) { ++n; }; c = texture2DRect(tex0, d); sum += 0.150183 * c;", "", "\tgl_FragColor = (n > 0 && n < 25) ? sum : c;", "}"};
    @ShaderSource(program=false)
    public static final String[] rgb2hsl = new String[]{"vec3 rgb2hsl(vec3 rgb) {", "\tfloat min = min(min(rgb.r, rgb.g), rgb.b);", "\tfloat max = max(max(rgb.r, rgb.g), rgb.b);", "\tfloat dmax = max - min;", "", "\tfloat luma = (max + min)*0.5;", "\tfloat hue, sat;", "", "\tif (dmax == 0.0) {", "\t\thue = sat = 0.0;", "\t} else {", "\t\tsat = (luma < 0.5) ? dmax/(max+min) : dmax/(2.0-max-min);", "", "\t\tfloat dr = ((max-rgb.r)/6.0 + dmax/2.0)/dmax;", "\t\tfloat dg = ((max-rgb.g)/6.0 + dmax/2.0)/dmax;", "\t\tfloat db = ((max-rgb.b)/6.0 + dmax/2.0)/dmax;", "", "\t\thue = (rgb.r == max) ? db-dg", "\t\t\t: (rgb.g == max) ? 1.0/3.0 + dr-db", "\t\t\t:\t\t\t\t   2.0/3.0 + dg-dr;", "", "\t\tif (hue < 0.0) hue += 1.0;", "\t\telse if (hue > 1.0) hue -= 1.0;", "\t}", "", "\treturn vec3(hue, sat, luma);", "}"};
    @ShaderSource(attach={"rgb2hsl"})
    public static final String[] HSL_KEY = KeyingShaders.createHSLKeySource(false);
    @ShaderSource(attach={"rgb2hsl"})
    public static final String[] HSL_KEY_MASK_ONLY = KeyingShaders.createHSLKeySource(true);

    private static String[] createChromaKeySource(boolean maskOnly) {
        return new String[]{"uniform sampler2DRect texture;", "uniform vec2 keyUV;", "uniform float similarity;", "uniform float blend;", "uniform float t_minus_c;", "uniform float cutoff;", "", "const vec3 yVec = vec3(0.299, 0.587, 0.114);", "const vec3 uVec = vec3(-0.14713, -0.28886, 0.436);", "const vec3 vVec = vec3(0.615, -0.51499, -0.10001);", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tvec3 rgb = color.rgb/color.a;", "", "\tvec2 uv = vec2(dot(uVec, rgb), dot(vVec, rgb));", "\tfloat d = distance(keyUV, uv);", "\tfloat a1 = (d-similarity)/blend;", "", "\tfloat y = dot(yVec, rgb);", "\tfloat a2 = clamp(1.0-(y-cutoff)/t_minus_c, 0.0, 1.0);", "", "\tif (a1 > 0.0) {", "\t\tfloat a = min(1.0, a1)*(1.0-a2)+a2;", maskOnly ? "\t\tgl_FragData[0] = vec4(a, a, a, 1.0);" : "\t\tgl_FragData[0] = color*a; gl_FragData[1] = vec4(a);", "\t} else {", maskOnly ? "\t\tgl_FragData[0] = (a2 == 1.0) ? vec4(1.0) : vec4(0.0, 0.0, 0.0, 1.0);" : "\t\tgl_FragData[0] = (a2 == 1.0) ? color : vec4(0.0, 0.0, 0.0, color.a*a2); gl_FragData[1] = vec4(0.0);", "\t}", "}"};
    }

    private static String[] createHSLKeySource(boolean maskOnly) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("vec3 rgb2hsl(vec3 rgb);", "", "uniform sampler2DRect texture;", "uniform vec3 similarityMin;", "uniform vec3 similarityMax;", "uniform vec3 blendMin;", "uniform vec3 blendMax;", "uniform vec3 bleachHSL;", "uniform vec3 bleachRGB;", "uniform vec2 correctionHue;", "uniform float correctionSat;", "uniform float correctionAlpha;", "", "const vec3 vec3_111 = vec3(1.0);", "const float PI = 3.14159265358979323846264;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tvec3 unmult = color.rgb/color.a;", "\tvec3 hsl = rgb2hsl(unmult);", "\tvec3 bleachDelta = hsl-bleachHSL;", "\thsl.y *= 1.0-abs(hsl.z-0.5)*2.0;", "", "\tvec3 a3 = max((similarityMin-hsl)/blendMin, (hsl-similarityMax)/blendMax);", "\ta3.x = min(a3.x, (similarityMin.x-(hsl.x-1.0))/blendMin.x);", "\ta3.x = min(a3.x, ((hsl.x+1.0)-similarityMax.x)/blendMax.x);", "", "\ta3 = vec3_111 - clamp(a3, 0.0, 1.0);", "\ta3 = 0.5*(1.0-cos(PI*a3));", "\tfloat a = 1.0 - a3.x*a3.y*a3.z;", "", "\tif (similarityMin.y-blendMin.y < 0.0 && hsl.y < blendMin.y-similarityMin.y) {", "\t\tfloat y = 1.0 - clamp((hsl.y+similarityMin.y)/blendMin.y, 0.0, 1.0);", "\t\ty = 0.5*(1.0-cos(PI*y));", "\t\ta = min(a, 1.0 - y*a3.z);", "\t}", "", "\tfloat bleachLevel = (bleachDelta.x-floor(bleachDelta.x))*6.0;", "\tif (bleachLevel > 3.0) {", "\t\tbleachLevel = (6.0-bleachLevel)/correctionHue.x;", "\t} else {", "\t\tbleachLevel /= correctionHue.y;", "\t}", "", "\tvec3 b3 = vec3_111 - vec3(min(bleachLevel, 1.0), min(abs(bleachDelta.y)*correctionSat, 1.0), min(abs(bleachDelta.z)*2.0, 1.0));", "\tbleachLevel = b3.x*b3.y*b3.z;", "\tbleachLevel = max(bleachLevel, (abs(bleachDelta.y)*correctionSat+(1.0-correctionSat*2.0))*b3.z);", "", "\ta = (1.0-correctionAlpha*bleachLevel) * a * color.a;"));
        if (maskOnly) {
            list.addAll(Arrays.asList("\tgl_FragColor = vec4(a, a, a, 1.0);", "}"));
        } else {
            list.addAll(Arrays.asList("\tunmult = clamp((unmult-bleachLevel*bleachRGB)/(1.0-bleachLevel), 0.0, 1.0);", "\tgl_FragColor = vec4(unmult, 1.0) * a;", "}"));
        }
        return list.toArray(new String[list.size()]);
    }
}

