/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.stylize;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.BlendMode;
import ch.kuramo.javie.effects.VideoEffectUtil;
import ch.kuramo.javie.effects.blurSharpen.BlurUtil;
import com.google.inject.Inject;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

@Effect(id="ch.kuramo.javie.Glow", category="ch.kuramo.javie.api.effectCategory.stylize")
public class Glow {
    @Property(value="ORIGINAL_COLORS")
    private IAnimatableEnum<GlowColors> colors;
    @Property(value="60", min="0", max="100")
    private IAnimatableDouble threshold;
    @Property(value="10", min="0", max="500")
    private IAnimatableDouble radius;
    @Property(value="1", min="0", max="255")
    private IAnimatableDouble intensity;
    @Property(value="NONE")
    private IAnimatableEnum<GlowComposite> composite;
    @Property(value="ADD")
    private IAnimatableEnum<BlendMode> operation;
    @Property(value="TRIANGLE_ABA")
    private IAnimatableEnum<GlowLooping> colorLooping;
    @Property(value="1", min="1", max="127")
    private IAnimatableDouble colorLoops;
    @Property
    private IAnimatableDouble colorPhase;
    @Property(value="50", min="0", max="100")
    private IAnimatableDouble abMidpoint;
    @Property(value="1,1,1")
    private IAnimatableColor colorA;
    @Property(value="0,0,0")
    private IAnimatableColor colorB;
    @Property
    private IAnimatableEnum<GlowDimensions> dimensions;
    @Property(value="true")
    private IAnimatableBoolean fast;
    private final IVideoEffectContext context;
    private final IShaderRegistry shaders;
    private final IShaderProgram oColorsThresholdProgram;
    private final IShaderProgram abColorsThresholdProgram;
    private final IShaderProgram alphaBaseThresholdProgram;
    private final IShaderProgram sawtoothProgram;
    private final IShaderProgram triangleProgram;
    private final IShaderProgram oColorsIntensityProgram;
    private final IShaderProgram oColorsIntensityFloatProgram;
    private final IShaderProgram abColorsIntensityProgram;
    @ShaderSource
    public static final String[] OCOLORS_THRESHOLD = new String[]{"uniform sampler2DRect texture;", "uniform float upper;", "uniform float lower;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tfloat a = color.a;", "\tvec3 rgb = (a != 0.0) ? color.rgb/a : vec3(0.0);", "", "\trgb = clamp((rgb - lower) / (upper - lower), 0.0, 1.0);", "", "\tgl_FragColor = vec4(rgb*a, a);", "}"};
    @ShaderSource
    public static final String[] ABCOLORS_THRESHOLD = new String[]{"uniform sampler2DRect texture;", "uniform float upper;", "uniform float lower;", "", "const vec3 lumaVec = vec3(0.299, 0.587, 0.114);", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "", "\tfloat luma = dot(color.rgb, lumaVec);", "\tluma = clamp((luma - lower) / (upper - lower), 0.0, 1.0);", "", "\tgl_FragColor = vec4(luma);", "}"};
    @ShaderSource
    public static final String[] ALPHA_BASE_THRESHOLD = new String[]{"uniform sampler2DRect texture;", "uniform float upper;", "uniform float lower;", "", "void main(void)", "{", "\tfloat a = texture2DRect(texture, gl_TexCoord[0].st).a;", "", "\ta = clamp((a - lower) / (upper - lower), 0.0, 1.0);", "", "\tgl_FragColor = vec4(a);", "}"};
    @ShaderSource
    public static final String[] SAWTOOTH = new String[]{"uniform sampler2DRect texture;", "uniform float loops;", "uniform float phase;", "uniform float midpoint;", "uniform vec3 colorA;", "uniform vec3 colorM;", "uniform vec3 colorB;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tfloat a = color.a;", "\tfloat t = phase + a * loops;", "", "\tif (t > 1.0) {", "\t\tt -= floor(t);", "\t}", "", "\tvec3 rgb;", "\tif (t > midpoint) {", "\t\tt = (t-midpoint)/(1.0-midpoint);", "\t\trgb = colorA*t + colorM*(1.0-t);", "\t} else {", "\t\tt = t/midpoint;", "\t\trgb = colorB*(1.0-t) + colorM*t;", "\t}", "", "\tgl_FragColor = vec4(rgb, 1.0)*a;", "}"};
    @ShaderSource
    public static final String[] TRIANGLE = new String[]{"uniform sampler2DRect texture;", "uniform float loops;", "uniform float phase;", "uniform float midpoint;", "uniform vec3 colorA;", "uniform vec3 colorM;", "uniform vec3 colorB;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tfloat a = color.a;", "\tfloat t = phase + a * loops;", "", "\tt = 1.0 - 2.0 * abs(t - floor(t) - 0.5);", "", "\tvec3 rgb;", "\tif (t > midpoint) {", "\t\tt = (t-midpoint)/(1.0-midpoint);", "\t\trgb = colorA*t + colorM*(1.0-t);", "\t} else {", "\t\tt = t/midpoint;", "\t\trgb = colorB*(1.0-t) + colorM*t;", "\t}", "", "\tgl_FragColor = vec4(rgb, 1.0)*a;", "}"};
    @ShaderSource
    public static final String[] OCOLORS_INTENSITY = new String[]{"uniform sampler2DRect texture;", "uniform float intensity;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tgl_FragColor = vec4(min(color.rgb*intensity, color.a), color.a);", "}"};
    @ShaderSource
    public static final String[] OCOLORS_INTENSITY_FLOAT = new String[]{"uniform sampler2DRect texture;", "uniform float intensity;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tgl_FragColor = vec4(color.rgb*intensity, color.a);", "}"};
    @ShaderSource
    public static final String[] ABCOLORS_INTENSITY = new String[]{"uniform sampler2DRect texture;", "uniform float intensity;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tgl_FragColor = vec4(color.rgb*intensity, min(color.a*intensity, 1.0));", "}"};
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] NONE = Glow.createCompositeSource("none");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] NORMAL = Glow.createCompositeSource("normal");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] DARKEN = Glow.createCompositeSource("darken");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] MULTIPLY = Glow.createCompositeSource("multiply");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] COLOR_BURN = Glow.createCompositeSource("color_burn");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] LINEAR_BURN = Glow.createCompositeSource("linear_burn");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] DARKER_COLOR = Glow.createCompositeSource("darker_color");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] ADD = Glow.createCompositeSource("add");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] LIGHTEN = Glow.createCompositeSource("lighten");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] SCREEN = Glow.createCompositeSource("screen");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] COLOR_DODGE = Glow.createCompositeSource("color_dodge");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] LINEAR_DODGE = Glow.createCompositeSource("linear_dodge");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] LIGHTER_COLOR = Glow.createCompositeSource("lighter_color");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] OVERLAY = Glow.createCompositeSource("overlay");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] SOFT_LIGHT = Glow.createCompositeSource("soft_light");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] HARD_LIGHT = Glow.createCompositeSource("hard_light");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] LINEAR_LIGHT = Glow.createCompositeSource("linear_light");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] VIVID_LIGHT = Glow.createCompositeSource("vivid_light");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] PIN_LIGHT = Glow.createCompositeSource("pin_light");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] HARD_MIX = Glow.createCompositeSource("hard_mix");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] DIFFERENCE = Glow.createCompositeSource("difference");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] EXCLUSION = Glow.createCompositeSource("exclusion");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] HUE = Glow.createCompositeSource("hue");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] SATURATION = Glow.createCompositeSource("saturation");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] COLOR = Glow.createCompositeSource("color");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] LUMINOSITY = Glow.createCompositeSource("luminosity");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] STENCIL_ALPHA = Glow.createCompositeSource("stencil_alpha");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] STENCIL_LUMA = Glow.createCompositeSource("stencil_luma");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] SILHOUETTE_ALPHA = Glow.createCompositeSource("silhouette_alpha");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] SILHOUETTE_LUMA = Glow.createCompositeSource("silhouette_luma");

    @Inject
    public Glow(IVideoEffectContext context, IShaderRegistry shaders) {
        this.context = context;
        this.shaders = shaders;
        this.oColorsThresholdProgram = shaders.getProgram(Glow.class, "OCOLORS_THRESHOLD");
        this.abColorsThresholdProgram = shaders.getProgram(Glow.class, "ABCOLORS_THRESHOLD");
        this.alphaBaseThresholdProgram = shaders.getProgram(Glow.class, "ALPHA_BASE_THRESHOLD");
        this.sawtoothProgram = shaders.getProgram(Glow.class, "SAWTOOTH");
        this.triangleProgram = shaders.getProgram(Glow.class, "TRIANGLE");
        this.oColorsIntensityProgram = shaders.getProgram(Glow.class, "OCOLORS_INTENSITY");
        this.oColorsIntensityFloatProgram = shaders.getProgram(Glow.class, "OCOLORS_INTENSITY_FLOAT");
        this.abColorsIntensityProgram = shaders.getProgram(Glow.class, "ABCOLORS_INTENSITY");
    }

    public VideoBounds getVideoBounds() {
        double radius = (Double)this.context.value((IAnimatableValue)this.radius);
        if (radius == 0.0) {
            return null;
        }
        GlowDimensions dimensions = (GlowDimensions)((Object)this.context.value(this.dimensions));
        boolean horz = dimensions != GlowDimensions.VERTICAL;
        boolean vert = dimensions != GlowDimensions.HORIZONTAL;
        boolean fast = radius > 50.0 || (Boolean)this.context.value((IAnimatableValue)this.fast) != false;
        radius = this.context.getVideoResolution().scale(radius);
        VideoBounds bounds = this.context.getPreviousBounds();
        if (bounds.isEmpty()) {
            return bounds;
        }
        int sampleRatio = 1;
        if (fast) {
            int[] nArray = BlurUtil.getDownSampleFactors(radius);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int factor = nArray[n2];
                int hFactor = horz ? factor : 1;
                int vFactor = vert ? factor : 1;
                bounds = new VideoBounds(bounds.x / (double)hFactor, bounds.y / (double)vFactor, (bounds.width + hFactor - 1) / hFactor, (bounds.height + vFactor - 1) / vFactor);
                sampleRatio *= factor;
                ++n2;
            }
            radius /= (double)sampleRatio;
        }
        int ceiledRadius = (int)Math.ceil(radius);
        bounds = VideoEffectUtil.expandBounds(bounds, ceiledRadius, horz, vert);
        int hRatio = horz ? sampleRatio : 1;
        int vRatio = vert ? sampleRatio : 1;
        return new VideoBounds(bounds.x * (double)hRatio, bounds.y * (double)vRatio, bounds.width * hRatio, bounds.height * vRatio);
    }

    public IVideoBuffer doVideoEffect() {
        GlowColors colors = (GlowColors)((Object)this.context.value(this.colors));
        IVideoBuffer input = null;
        IVideoBuffer buf1 = null;
        IVideoBuffer buf2 = null;
        IVideoBuffer buf3 = null;
        IVideoBuffer buf4 = null;
        IVideoBuffer buf5 = null;
        try {
            input = this.context.doPreviousEffect();
            if (input.getBounds().isEmpty()) {
                IVideoBuffer result = input;
                input = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            buf1 = this.threshold(input, colors);
            buf2 = this.blur(buf1);
            if (buf2 == buf1) {
                buf1 = null;
            }
            if (colors == GlowColors.ORIGINAL_COLORS) {
                buf3 = buf2;
                buf2 = null;
            } else {
                buf3 = this.abColors(buf2);
            }
            buf4 = this.intensity(buf3, colors);
            if (buf4 == buf3) {
                buf3 = null;
            }
            if ((buf5 = this.composite(buf4, input)) == buf4) {
                buf4 = null;
            }
            IVideoBuffer result = buf5;
            buf5 = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
            if (buf1 != null) {
                buf1.dispose();
            }
            if (buf2 != null) {
                buf2.dispose();
            }
            if (buf3 != null) {
                buf3.dispose();
            }
            if (buf4 != null) {
                buf4.dispose();
            }
            if (buf5 != null) {
                buf5.dispose();
            }
        }
    }

    private IVideoBuffer threshold(IVideoBuffer input, GlowColors colors) {
        final IShaderProgram program = colors == GlowColors.ORIGINAL_COLORS ? this.oColorsThresholdProgram : (colors == GlowColors.A_AND_B_COLORS ? this.abColorsThresholdProgram : this.alphaBaseThresholdProgram);
        double threshold = (Double)this.context.value((IAnimatableValue)this.threshold) / 100.0;
        final double upper = Math.min(threshold + 0.0625, 1.0);
        final double lower = Math.max(threshold - 0.0625, 0.0);
        final GL2 gl = this.context.getGL().getGL2();
        VideoBounds bounds = input.getBounds();
        final int w = bounds.width;
        final int h = bounds.height;
        VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
        IVideoBuffer buffer = null;
        try {
            buffer = this.context.createVideoBuffer(bounds);
            gl.glFramebufferTexture2D(36160, 36064, 34037, buffer.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, input.getTexture());
            program.useProgram(new Runnable(){

                public void run() {
                    gl.glUniform1i(program.getUniformLocation("texture"), 0);
                    gl.glUniform1f(program.getUniformLocation("upper"), (float)upper);
                    gl.glUniform1f(program.getUniformLocation("lower"), (float)lower);
                    gl.glBegin(7);
                    gl.glTexCoord2f(0.0f, 0.0f);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glTexCoord2f((float)w, 0.0f);
                    gl.glVertex2f((float)w, 0.0f);
                    gl.glTexCoord2f((float)w, (float)h);
                    gl.glVertex2f((float)w, (float)h);
                    gl.glTexCoord2f(0.0f, (float)h);
                    gl.glVertex2f(0.0f, (float)h);
                    gl.glEnd();
                }
            });
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private IVideoBuffer blur(IVideoBuffer input) {
        double radius = (Double)this.context.value((IAnimatableValue)this.radius);
        if (radius == 0.0) {
            return input;
        }
        GlowDimensions dimensions = (GlowDimensions)((Object)this.context.value(this.dimensions));
        boolean horz = dimensions != GlowDimensions.VERTICAL;
        boolean vert = dimensions != GlowDimensions.HORIZONTAL;
        boolean fast = radius > 50.0 || (Boolean)this.context.value((IAnimatableValue)this.fast) != false;
        radius = this.context.getVideoResolution().scale(radius);
        GL2 gl = this.context.getGL().getGL2();
        GLU glu = this.context.getGLU();
        return this.blur(input, radius, false, horz, vert, fast, gl, glu);
    }

    private IVideoBuffer blur(IVideoBuffer input, double blur, boolean repeatEdgePixels, boolean horz, boolean vert, boolean fast, GL2 gl, GLU glu) {
        VideoBounds inputBounds = input.getBounds();
        int sampleRatio = 1;
        if (fast) {
            VideoBounds bounds = inputBounds;
            int[] nArray = BlurUtil.getDownSampleFactors(blur);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int factor = nArray[n2];
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(input, gl);
                }
                int hFactor = horz ? factor : 1;
                int vFactor = vert ? factor : 1;
                bounds = new VideoBounds(bounds.x / (double)hFactor, bounds.y / (double)vFactor, (bounds.width + hFactor - 1) / hFactor, (bounds.height + vFactor - 1) / vFactor);
                IVideoBuffer buf = this.context.createVideoBuffer(bounds);
                BlurUtil.doDownSample(input, buf, hFactor, vFactor, gl, glu, this.shaders);
                input.dispose();
                input = buf;
                sampleRatio *= factor;
                ++n2;
            }
            blur /= (double)sampleRatio;
        }
        int radius = (int)Math.ceil(blur);
        double sigma = blur / 2.5;
        double sigmaSquare = sigma * sigma;
        float[] kernel = new float[radius * 2 + 1];
        float sum = 0.0f;
        int i = 1;
        while (i <= radius) {
            float f = (float)Math.exp((double)(-i * i) / (2.0 * sigmaSquare));
            kernel[radius - i] = f;
            sum += 2.0f * f;
            ++i;
        }
        kernel[radius] = 1.0f / (sum += 1.0f);
        i = 1;
        while (i <= radius) {
            int n = radius - i;
            float f = kernel[n] / sum;
            kernel[n] = f;
            kernel[radius + i] = f;
            ++i;
        }
        IVideoBuffer buf1 = null;
        IVideoBuffer buf2 = null;
        IVideoBuffer buf3 = null;
        try {
            VideoBounds bounds;
            if (horz) {
                bounds = input.getBounds();
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(input, gl);
                } else {
                    bounds = VideoEffectUtil.expandBounds(bounds, radius, true, false);
                }
                buf1 = this.context.createVideoBuffer(bounds);
                VideoEffectUtil.convolution1D(input, buf1, true, radius, kernel, gl, glu, this.shaders);
            } else {
                buf1 = input;
                input = null;
            }
            if (vert) {
                bounds = buf1.getBounds();
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(buf1, gl);
                } else {
                    bounds = VideoEffectUtil.expandBounds(bounds, radius, false, true);
                }
                buf2 = this.context.createVideoBuffer(bounds);
                VideoEffectUtil.convolution1D(buf1, buf2, false, radius, kernel, gl, glu, this.shaders);
            } else {
                buf2 = buf1;
                buf1 = null;
            }
            if (sampleRatio != 1) {
                VideoBounds bounds2;
                int vRatio;
                int hRatio = horz ? sampleRatio : 1;
                int n = vRatio = vert ? sampleRatio : 1;
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(buf2, gl);
                    bounds2 = inputBounds;
                } else {
                    bounds2 = buf2.getBounds();
                    bounds2 = new VideoBounds(bounds2.x * (double)hRatio, bounds2.y * (double)vRatio, bounds2.width * hRatio, bounds2.height * vRatio);
                }
                buf3 = this.context.createVideoBuffer(bounds2);
                BlurUtil.doUpSample(buf2, buf3, hRatio, vRatio, gl, glu);
            } else {
                buf3 = buf2;
                buf2 = null;
            }
            IVideoBuffer iVideoBuffer = buf3;
            return iVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
            if (buf1 != null) {
                buf1.dispose();
            }
            if (buf2 != null) {
                buf2.dispose();
            }
        }
    }

    private IVideoBuffer abColors(IVideoBuffer input) {
        Color colorB;
        Color colorA;
        GlowLooping looping = (GlowLooping)((Object)this.context.value(this.colorLooping));
        final double loops = (Double)this.context.value((IAnimatableValue)this.colorLoops);
        final double phase = (Double)this.context.value((IAnimatableValue)this.colorPhase) / 360.0;
        final double midpoint = 1.0 - (Double)this.context.value((IAnimatableValue)this.abMidpoint) / 100.0;
        if (looping == GlowLooping.SAWTOOTH_AB || looping == GlowLooping.TRIANGLE_ABA) {
            colorA = (Color)this.context.value((IAnimatableValue)this.colorA);
            colorB = (Color)this.context.value((IAnimatableValue)this.colorB);
        } else {
            colorA = (Color)this.context.value((IAnimatableValue)this.colorB);
            colorB = (Color)this.context.value((IAnimatableValue)this.colorA);
        }
        final Color colorM = new Color((colorA.r + colorB.r) / 2.0, (colorA.g + colorB.g) / 2.0, (colorA.b + colorB.b) / 2.0);
        final IShaderProgram program = looping == GlowLooping.SAWTOOTH_AB || looping == GlowLooping.SAWTOOTH_BA ? this.sawtoothProgram : this.triangleProgram;
        final GL2 gl = this.context.getGL().getGL2();
        VideoBounds bounds = input.getBounds();
        final int w = bounds.width;
        final int h = bounds.height;
        VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
        IVideoBuffer buffer = null;
        try {
            buffer = this.context.createVideoBuffer(bounds);
            gl.glFramebufferTexture2D(36160, 36064, 34037, buffer.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, input.getTexture());
            program.useProgram(new Runnable(){

                public void run() {
                    gl.glUniform1i(program.getUniformLocation("texture"), 0);
                    gl.glUniform1f(program.getUniformLocation("loops"), (float)loops);
                    gl.glUniform1f(program.getUniformLocation("phase"), (float)phase);
                    gl.glUniform1f(program.getUniformLocation("midpoint"), (float)midpoint);
                    gl.glUniform3f(program.getUniformLocation("colorA"), (float)colorA.r, (float)colorA.g, (float)colorA.b);
                    gl.glUniform3f(program.getUniformLocation("colorM"), (float)colorM.r, (float)colorM.g, (float)colorM.b);
                    gl.glUniform3f(program.getUniformLocation("colorB"), (float)colorB.r, (float)colorB.g, (float)colorB.b);
                    gl.glBegin(7);
                    gl.glTexCoord2f(0.0f, 0.0f);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glTexCoord2f((float)w, 0.0f);
                    gl.glVertex2f((float)w, 0.0f);
                    gl.glTexCoord2f((float)w, (float)h);
                    gl.glVertex2f((float)w, (float)h);
                    gl.glTexCoord2f(0.0f, (float)h);
                    gl.glVertex2f(0.0f, (float)h);
                    gl.glEnd();
                }
            });
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private IVideoBuffer intensity(IVideoBuffer input, GlowColors colors) {
        final double intensity = (Double)this.context.value((IAnimatableValue)this.intensity);
        if (intensity == 1.0) {
            return input;
        }
        final IShaderProgram program = colors != GlowColors.ORIGINAL_COLORS ? this.abColorsIntensityProgram : (input.getColorMode().isFloat() ? this.oColorsIntensityFloatProgram : this.oColorsIntensityProgram);
        final GL2 gl = this.context.getGL().getGL2();
        VideoBounds bounds = input.getBounds();
        final int w = bounds.width;
        final int h = bounds.height;
        VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
        IVideoBuffer buffer = null;
        try {
            buffer = this.context.createVideoBuffer(bounds);
            gl.glFramebufferTexture2D(36160, 36064, 34037, buffer.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, input.getTexture());
            program.useProgram(new Runnable(){

                public void run() {
                    gl.glUniform1i(program.getUniformLocation("texture"), 0);
                    gl.glUniform1f(program.getUniformLocation("intensity"), (float)intensity);
                    gl.glBegin(7);
                    gl.glTexCoord2f(0.0f, 0.0f);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glTexCoord2f((float)w, 0.0f);
                    gl.glVertex2f((float)w, 0.0f);
                    gl.glTexCoord2f((float)w, (float)h);
                    gl.glVertex2f((float)w, (float)h);
                    gl.glTexCoord2f(0.0f, (float)h);
                    gl.glVertex2f(0.0f, (float)h);
                    gl.glEnd();
                }
            });
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private IVideoBuffer composite(IVideoBuffer glow, IVideoBuffer orig) {
        final GlowComposite composite = (GlowComposite)((Object)this.context.value(this.composite));
        BlendMode operation = (BlendMode)((Object)this.context.value(this.operation));
        if (composite == GlowComposite.NONE && operation == BlendMode.NONE) {
            return glow;
        }
        final GL2 gl = this.context.getGL().getGL2();
        VideoBounds glowBounds = glow.getBounds();
        VideoBounds origBounds = orig.getBounds();
        final int w = glowBounds.width;
        final int h = glowBounds.height;
        final float ox = (float)(glowBounds.x - origBounds.x);
        final float oy = (float)(glowBounds.y - origBounds.y);
        VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
        IVideoBuffer buffer = null;
        try {
            buffer = this.context.createVideoBuffer(glowBounds);
            gl.glFramebufferTexture2D(36160, 36064, 34037, buffer.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, glow.getTexture());
            gl.glActiveTexture(33985);
            gl.glBindTexture(34037, orig.getTexture());
            final IShaderProgram program = this.shaders.getProgram(Glow.class, operation.name());
            program.useProgram(new Runnable(){

                public void run() {
                    gl.glUniform1i(program.getUniformLocation("texGlow"), 0);
                    gl.glUniform1i(program.getUniformLocation("texOrig"), 1);
                    gl.glUniform1i(program.getUniformLocation("composite"), composite.ordinal());
                    gl.glBegin(7);
                    gl.glMultiTexCoord2f(33984, 0.0f, 0.0f);
                    gl.glMultiTexCoord2f(33985, ox, oy);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glMultiTexCoord2f(33984, (float)w, 0.0f);
                    gl.glMultiTexCoord2f(33985, ox + (float)w, oy);
                    gl.glVertex2f((float)w, 0.0f);
                    gl.glMultiTexCoord2f(33984, (float)w, (float)h);
                    gl.glMultiTexCoord2f(33985, ox + (float)w, oy + (float)h);
                    gl.glVertex2f((float)w, (float)h);
                    gl.glMultiTexCoord2f(33984, 0.0f, (float)h);
                    gl.glMultiTexCoord2f(33985, ox, oy + (float)h);
                    gl.glVertex2f(0.0f, (float)h);
                    gl.glEnd();
                }
            });
            gl.glActiveTexture(33985);
            gl.glBindTexture(34037, 0);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private static final String[] createCompositeSource(String name) {
        boolean none = name.equals("none");
        boolean noneOrNormal = none || name.equals("normal");
        return new String[]{"uniform sampler2DRect texGlow;", "uniform sampler2DRect texOrig;", "uniform int composite;", "", "vec4 blend_normal(vec4 pDst, vec4 pSrc, float intensity);", noneOrNormal ? "" : String.format("vec4 blend_%s(vec4 pDst, vec4 pSrc, float intensity);", name), "", "void main(void)", "{", "\tvec4 glow = texture2DRect(texGlow, gl_TexCoord[0].st);", "\tvec4 orig = texture2DRect(texOrig, gl_TexCoord[1].st);", none ? "" : String.format("\tglow = blend_%s(glow, orig, 1.0);", name), "", "\tgl_FragColor = (composite == 0) ? blend_normal(glow, orig, 1.0) :", "\t\t\t\t   (composite == 1) ? blend_normal(orig, glow, 1.0) : glow;", "}"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GlowColors {
        ORIGINAL_COLORS,
        A_AND_B_COLORS,
        A_AND_B_COLORS_ALPHA_BASE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GlowComposite {
        ON_TOP,
        BEHIND,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GlowDimensions {
        BOTH,
        HORIZONTAL,
        VERTICAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GlowLooping {
        SAWTOOTH_AB,
        SAWTOOTH_BA,
        TRIANGLE_ABA,
        TRIANGLE_BAB;

    }
}

