/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.stylize;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import com.google.inject.Inject;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

@Effect(id="ch.kuramo.javie.Mosaic", category="ch.kuramo.javie.api.effectCategory.stylize")
public class Mosaic {
    @ShaderSource
    public static final String[] MOSAIC_SHARP_COLORS = new String[]{"uniform sampler2DRect texture;", "uniform float hSize;", "uniform float vSize;", "", "void main(void)", "{", "\tfloat s = (floor(gl_TexCoord[0].s/hSize)+0.5)*hSize;", "\tfloat t = (floor(gl_TexCoord[0].t/vSize)+0.5)*vSize;", "\tgl_FragColor = texture2DRect(texture, vec2(s, t));", "}"};
    private final IVideoEffectContext context;
    private final IShaderRegistry shaders;
    private final IShaderProgram sharpColorsProgram;
    @Property(value="10", min="1")
    private IAnimatableInteger horizontalBlocks;
    @Property(value="10", min="1")
    private IAnimatableInteger verticalBlocks;
    @Property
    private IAnimatableBoolean sharpColors;

    @Inject
    public Mosaic(IVideoEffectContext context, IShaderRegistry shaders) {
        this.context = context;
        this.shaders = shaders;
        this.sharpColorsProgram = shaders.getProgram(Mosaic.class, "MOSAIC_SHARP_COLORS");
    }

    public IVideoBuffer doVideoEffect() {
        int hBlocks = (Integer)this.context.value((IAnimatableValue)this.horizontalBlocks);
        int vBlocks = (Integer)this.context.value((IAnimatableValue)this.verticalBlocks);
        boolean sharpColors = (Boolean)this.context.value((IAnimatableValue)this.sharpColors);
        if (sharpColors) {
            return this.doSharpColorsMosaic(hBlocks, vBlocks);
        }
        return this.doAverageColorsMosaic(hBlocks, vBlocks);
    }

    private IVideoBuffer doSharpColorsMosaic(int hBlocks, int vBlocks) {
        IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds bounds = input.getBounds();
        if (bounds.isEmpty()) {
            return input;
        }
        final int w = bounds.width;
        final int h = bounds.height;
        hBlocks = Math.min(hBlocks, w);
        vBlocks = Math.min(vBlocks, h);
        if (hBlocks == w && vBlocks == h) {
            return input;
        }
        final float hSize = (float)w / (float)hBlocks;
        final float vSize = (float)h / (float)vBlocks;
        IVideoBuffer buffer = null;
        try {
            buffer = this.context.createVideoBuffer(bounds);
            final GL2 gl = this.context.getGL().getGL2();
            VideoEffectUtil.ortho2D(gl, this.context.getGLU(), w, h);
            gl.glFramebufferTexture2D(36160, 36064, 34037, buffer.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, input.getTexture());
            this.sharpColorsProgram.useProgram(new Runnable(){

                public void run() {
                    gl.glUniform1i(Mosaic.this.sharpColorsProgram.getUniformLocation("texture"), 0);
                    gl.glUniform1f(Mosaic.this.sharpColorsProgram.getUniformLocation("hSize"), hSize);
                    gl.glUniform1f(Mosaic.this.sharpColorsProgram.getUniformLocation("vSize"), vSize);
                    gl.glBegin(7);
                    gl.glTexCoord2f(0.0f, 0.0f);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glTexCoord2f((float)w, 0.0f);
                    gl.glVertex2f((float)w, 0.0f);
                    gl.glTexCoord2f((float)w, (float)h);
                    gl.glVertex2f((float)w, (float)h);
                    gl.glTexCoord2f(0.0f, (float)h);
                    gl.glVertex2f(0.0f, (float)h);
                    gl.glEnd();
                }
            });
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            IVideoBuffer output = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            input.dispose();
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private IVideoBuffer doAverageColorsMosaic(int hBlocks, int vBlocks) {
        IVideoBuffer input = this.context.doPreviousEffect();
        IVideoBuffer buffer = null;
        try {
            VideoBounds bounds = input.getBounds();
            if (bounds.isEmpty()) {
                IVideoBuffer output = input;
                input = null;
                IVideoBuffer iVideoBuffer = output;
                return iVideoBuffer;
            }
            int w = bounds.width;
            int h = bounds.height;
            hBlocks = Math.min(hBlocks, w);
            vBlocks = Math.min(vBlocks, h);
            if (hBlocks != w || vBlocks != h) {
                buffer = this.context.createVideoBuffer(new VideoBounds(hBlocks, vBlocks));
                this.average(input, buffer);
                this.scale(buffer, input);
            }
            IVideoBuffer output = input;
            input = null;
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private void average(IVideoBuffer src, IVideoBuffer dst) {
        final GL2 gl = this.context.getGL().getGL2();
        IVideoBuffer src0 = src;
        IVideoBuffer tmpBuf = null;
        try {
            VideoBounds srcBounds = src.getBounds();
            VideoBounds dstBounds = dst.getBounds();
            int hBlocks = dstBounds.width;
            int vBlocks = dstBounds.height;
            int hbs = (srcBounds.width + hBlocks - 1) / hBlocks;
            int vbs = (srcBounds.height + vBlocks - 1) / vBlocks;
            if (hbs > 7 || vbs > 7) {
                tmpBuf = this.context.createVideoBuffer(new VideoBounds(hbs > 7 ? hBlocks * 7 : hBlocks, vbs > 7 ? vBlocks * 7 : vBlocks));
                this.average(src, tmpBuf);
                src = tmpBuf;
                srcBounds = src.getBounds();
                hbs = (srcBounds.width + hBlocks - 1) / hBlocks;
                vbs = (srcBounds.height + vBlocks - 1) / vBlocks;
            }
            final int srcWidth = srcBounds.width;
            final int srcHeight = srcBounds.height;
            final int dstWidth = dstBounds.width;
            final int dstHeight = dstBounds.height;
            final int ksize = hbs * vbs;
            final float[] kernel = new float[ksize];
            final float[] offset = new float[ksize * 2];
            int j = 0;
            while (j < vbs) {
                int i = 0;
                while (i < hbs) {
                    int k = j * hbs + i;
                    kernel[k] = 1.0f / (float)ksize;
                    offset[k * 2] = i - hbs / 2;
                    offset[k * 2 + 1] = j - vbs / 2;
                    ++i;
                }
                ++j;
            }
            VideoEffectUtil.setClampToEdge(src, gl);
            VideoEffectUtil.ortho2D(gl, this.context.getGLU(), hBlocks, vBlocks);
            gl.glFramebufferTexture2D(36160, 36064, 34037, dst.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, src.getTexture());
            final IShaderProgram program = this.shaders.getProgram(VideoEffectUtil.class, "CONVOLUTION");
            program.useProgram(new Runnable(){

                public void run() {
                    gl.glUniform1i(program.getUniformLocation("texture"), 0);
                    gl.glUniform1i(program.getUniformLocation("ksize"), ksize);
                    gl.glUniform1fv(program.getUniformLocation("kernel[0]"), ksize, kernel, 0);
                    gl.glUniform2fv(program.getUniformLocation("offset[0]"), ksize, offset, 0);
                    gl.glBegin(7);
                    gl.glTexCoord2f(0.0f, 0.0f);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glTexCoord2f((float)srcWidth, 0.0f);
                    gl.glVertex2f((float)dstWidth, 0.0f);
                    gl.glTexCoord2f((float)srcWidth, (float)srcHeight);
                    gl.glVertex2f((float)dstWidth, (float)dstHeight);
                    gl.glTexCoord2f(0.0f, (float)srcHeight);
                    gl.glVertex2f(0.0f, (float)dstHeight);
                    gl.glEnd();
                }
            });
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
        }
        finally {
            if (tmpBuf != null) {
                tmpBuf.dispose();
            }
            VideoEffectUtil.setClampToBorder(src0, gl);
        }
    }

    private void scale(IVideoBuffer src, IVideoBuffer dst) {
        GL2 gl = this.context.getGL().getGL2();
        GLU glu = this.context.getGLU();
        VideoEffectUtil.setNearest(src, gl);
        VideoBounds srcBounds = src.getBounds();
        VideoBounds dstBounds = dst.getBounds();
        VideoEffectUtil.ortho2D(gl, glu, dstBounds.width, dstBounds.height);
        gl.glFramebufferTexture2D(36160, 36064, 34037, dst.getTexture(), 0);
        gl.glDrawBuffer(36064);
        gl.glActiveTexture(33984);
        gl.glBindTexture(34037, src.getTexture());
        gl.glEnable(34037);
        gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex2f(0.0f, 0.0f);
        gl.glTexCoord2f((float)srcBounds.width, 0.0f);
        gl.glVertex2f((float)dstBounds.width, 0.0f);
        gl.glTexCoord2f((float)srcBounds.width, (float)srcBounds.height);
        gl.glVertex2f((float)dstBounds.width, (float)dstBounds.height);
        gl.glTexCoord2f(0.0f, (float)srcBounds.height);
        gl.glVertex2f(0.0f, (float)dstBounds.height);
        gl.glEnd();
        gl.glActiveTexture(33984);
        gl.glBindTexture(34037, 0);
        gl.glDisable(34037);
        gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
    }
}

