/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.transition;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import com.google.inject.Inject;
import javax.media.opengl.GL2;

@Effect(id="ch.kuramo.javie.GradientWipe", category="ch.kuramo.javie.api.effectCategory.transition")
public class GradientWipe {
    @ShaderSource
    public static final String[] GRADIENT_WIPE_NORMAL = GradientWipe.createShaderSource(false, false);
    @ShaderSource
    public static final String[] GRADIENT_WIPE_NORMAL_TILE = GradientWipe.createShaderSource(false, true);
    @ShaderSource
    public static final String[] GRADIENT_WIPE_INVERT = GradientWipe.createShaderSource(true, false);
    @ShaderSource
    public static final String[] GRADIENT_WIPE_INVERT_TILE = GradientWipe.createShaderSource(true, true);
    private final IVideoEffectContext context;
    private final IShaderProgram normalProgram;
    private final IShaderProgram normalTileProgram;
    private final IShaderProgram invertProgram;
    private final IShaderProgram invertTileProgram;
    @Property(min="0", max="100")
    private IAnimatableDouble transitionCompletion;
    @Property(min="0", max="100")
    private IAnimatableDouble transitionSoftness;
    @Property
    private IAnimatableLayerReference gradientLayer;
    @Property(value="STRETCH")
    private IAnimatableEnum<GradientPlacement> gradientPlacement;
    @Property
    private IAnimatableBoolean invertGradient;

    private static String[] createShaderSource(boolean invert, boolean tile) {
        return new String[]{"uniform sampler2DRect grdTex;", "uniform sampler2DRect srcTex;", "uniform float min;", "uniform float max;", tile ? "uniform vec2 size;" : "", "", "const vec3 yvec = vec3(0.299, 0.587, 0.114);", "", "void main(void)", "{", "\tvec2 texCoord = gl_TexCoord[0].st;", tile ? "\tvec4 grd = texture2DRect(grdTex, texCoord - floor(texCoord/size)*size);" : "\tvec4 grd = texture2DRect(grdTex, texCoord);", "\tvec4 src = texture2DRect(srcTex, gl_FragCoord.xy);", invert ? "\tfloat y = 1.0 - dot(grd.rgb, yvec);" : "\tfloat y = dot(grd.rgb, yvec);", "\tfloat a = clamp((y-min)/(max-min), 0.0, 1.0);", "\tgl_FragColor = src*a;", "}"};
    }

    @Inject
    public GradientWipe(IVideoEffectContext context, IShaderRegistry shaders) {
        this.context = context;
        this.normalProgram = shaders.getProgram(GradientWipe.class, "GRADIENT_WIPE_NORMAL");
        this.normalTileProgram = shaders.getProgram(GradientWipe.class, "GRADIENT_WIPE_NORMAL_TILE");
        this.invertProgram = shaders.getProgram(GradientWipe.class, "GRADIENT_WIPE_INVERT");
        this.invertTileProgram = shaders.getProgram(GradientWipe.class, "GRADIENT_WIPE_INVERT_TILE");
    }

    public IVideoBuffer doVideoEffect() {
        double completion = (Double)this.context.value((IAnimatableValue)this.transitionCompletion) / 100.0;
        if (completion == 0.0) {
            return null;
        }
        if (completion == 1.0) {
            IVideoBuffer vb = this.context.createVideoBuffer(this.context.getPreviousBounds());
            VideoEffectUtil.clearTexture(vb, this.context.getGL().getGL2());
            return vb;
        }
        double softness = (Double)this.context.value((IAnimatableValue)this.transitionSoftness) / 100.0;
        final GradientPlacement placement = (GradientPlacement)((Object)this.context.value(this.gradientPlacement));
        final boolean tile = placement == GradientPlacement.TILE;
        boolean invert = (Boolean)this.context.value((IAnimatableValue)this.invertGradient);
        final double max = (1.0 + softness) * completion;
        final double min = max - softness;
        IVideoBuffer sourceBuffer = null;
        IVideoBuffer gradientBuffer = null;
        IVideoBuffer resultBuffer = null;
        try {
            sourceBuffer = this.context.doPreviousEffect();
            final VideoBounds sourceBounds = sourceBuffer.getBounds();
            if (sourceBounds.isEmpty()) {
                IVideoBuffer result = sourceBuffer;
                sourceBuffer = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            final GL2 gl = this.context.getGL().getGL2();
            gradientBuffer = this.context.getLayerVideoFrame(this.gradientLayer);
            if (gradientBuffer == null) {
                gradientBuffer = this.context.createVideoBuffer(new VideoBounds(0, 0));
                VideoEffectUtil.clearTexture(gradientBuffer, gl);
            }
            final VideoBounds gradientBounds = gradientBuffer.getBounds();
            resultBuffer = this.context.createVideoBuffer(sourceBounds);
            VideoEffectUtil.ortho2D(gl, this.context.getGLU(), sourceBounds.width, sourceBounds.height);
            gl.glFramebufferTexture2D(36160, 36064, 34037, resultBuffer.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, gradientBuffer.getTexture());
            gl.glActiveTexture(33985);
            gl.glBindTexture(34037, sourceBuffer.getTexture());
            final IShaderProgram program = tile ? (invert ? this.invertTileProgram : this.normalTileProgram) : (invert ? this.invertProgram : this.normalProgram);
            program.useProgram(new Runnable(){

                public void run() {
                    gl.glUniform1i(program.getUniformLocation("grdTex"), 0);
                    gl.glUniform1i(program.getUniformLocation("srcTex"), 1);
                    gl.glUniform1f(program.getUniformLocation("min"), (float)min);
                    gl.glUniform1f(program.getUniformLocation("max"), (float)max);
                    if (tile) {
                        gl.glUniform2f(program.getUniformLocation("size"), (float)gradientBounds.width, (float)gradientBounds.height);
                    }
                    gl.glBegin(7);
                    switch (placement) {
                        case CENTER: {
                            float s = (float)(gradientBounds.width - sourceBounds.width) / 2.0f;
                            float t = (float)(gradientBounds.height - sourceBounds.height) / 2.0f;
                            gl.glTexCoord2f(s, t);
                            gl.glVertex2f(0.0f, 0.0f);
                            gl.glTexCoord2f(s + (float)sourceBounds.width, t);
                            gl.glVertex2f((float)sourceBounds.width, 0.0f);
                            gl.glTexCoord2f(s + (float)sourceBounds.width, t + (float)sourceBounds.height);
                            gl.glVertex2f((float)sourceBounds.width, (float)sourceBounds.height);
                            gl.glTexCoord2f(s, t + (float)sourceBounds.height);
                            gl.glVertex2f(0.0f, (float)sourceBounds.height);
                            break;
                        }
                        case STRETCH: {
                            gl.glTexCoord2f(0.0f, 0.0f);
                            gl.glVertex2f(0.0f, 0.0f);
                            gl.glTexCoord2f((float)gradientBounds.width, 0.0f);
                            gl.glVertex2f((float)sourceBounds.width, 0.0f);
                            gl.glTexCoord2f((float)gradientBounds.width, (float)gradientBounds.height);
                            gl.glVertex2f((float)sourceBounds.width, (float)sourceBounds.height);
                            gl.glTexCoord2f(0.0f, (float)gradientBounds.height);
                            gl.glVertex2f(0.0f, (float)sourceBounds.height);
                            break;
                        }
                        default: {
                            gl.glTexCoord2f(0.0f, 0.0f);
                            gl.glVertex2f(0.0f, 0.0f);
                            gl.glTexCoord2f((float)sourceBounds.width, 0.0f);
                            gl.glVertex2f((float)sourceBounds.width, 0.0f);
                            gl.glTexCoord2f((float)sourceBounds.width, (float)sourceBounds.height);
                            gl.glVertex2f((float)sourceBounds.width, (float)sourceBounds.height);
                            gl.glTexCoord2f(0.0f, (float)sourceBounds.height);
                            gl.glVertex2f(0.0f, (float)sourceBounds.height);
                        }
                    }
                    gl.glEnd();
                }
            });
            gl.glActiveTexture(33985);
            gl.glBindTexture(34037, 0);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            IVideoBuffer output = resultBuffer;
            resultBuffer = null;
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            if (sourceBuffer != null) {
                sourceBuffer.dispose();
            }
            if (gradientBuffer != null) {
                gradientBuffer.dispose();
            }
            if (resultBuffer != null) {
                resultBuffer.dispose();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GradientPlacement {
        TILE,
        CENTER,
        STRETCH;

    }
}

