/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api;

import javax.media.opengl.GL2;

public enum ColorMode {

	RGBA8			(GL2.GL_RGBA8  , GL2.GL_UNSIGNED_BYTE ,  4),
	RGBA16			(GL2.GL_RGBA16 , GL2.GL_UNSIGNED_SHORT,  8),
	RGBA16_FLOAT	(GL2.GL_RGBA16F, GL2.GL_FLOAT         , 16),
	RGBA32_FLOAT	(GL2.GL_RGBA32F, GL2.GL_FLOAT         , 16);


	public final int glInternalFormat;

	public final int glDataType;

	public final int javaPixelBytes;


	ColorMode(int glInternalFormat, int glDataType, int javaPixelBytes) {
		this.glInternalFormat = glInternalFormat;
		this.glDataType = glDataType;
		this.javaPixelBytes = javaPixelBytes;
	}

	public boolean isFloat() {
		return (glDataType == GL2.GL_FLOAT);
	}

}
