/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import java.util.Arrays;
import java.util.Set;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Combo;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.views.ComboBoxViewerCellEditor;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.Util;

public class IntersectionGroupElement extends LayerAnimatableValueElement {

	public IntersectionGroupElement(Element parent, Layer layer) {
		super(parent, layer, "intersectionGroup", "交差グループ");
	}

	protected AnimatableValueElementDelegate<?> createDelegate() {
		AnimatableString avalue = PropertyUtil.getProperty(layer, property);
		return new IntersectionGroupElementDelegate(this, name, avalue);
	}

}

class IntersectionGroupElementDelegate extends AnimatableStringElementDelegate {

	private ComboBoxViewerCellEditor editor;


	IntersectionGroupElementDelegate(
			AnimatableValueElement element, String name, AnimatableString avalue) {

		super(element, name, avalue);
	}

	private String[] getIntersectionGroups() {
		LayerComposition comp = (LayerComposition) element.viewer.getData(LayerCompositionView.LAYER_COMPOSITION);

		Set<String> set = Util.newSet();
		for (Layer l : comp.getLayers()) {
			if (l instanceof MediaLayer && LayerNature.isVideoNature(l)) {
				AnimatableString group = ((MediaLayer) l).getIntersectionGroup();
				if (group.hasKeyframe()) {
					for (Keyframe<String> kf : group.getKeyframeMap().values()) {
						set.add(kf.value);
					}
				} else {
					set.add(group.getStaticValue());
				}
			}
		}
		set.remove("");
		String[] array = set.toArray(new String[set.size()]);
		Arrays.sort(array);

		return array;
	}

	public CellEditor getCellEditor(int columnIndex) {
		if (columnIndex == LayerCompositionView.VALUE_COL) {
			if (editor == null) {
				editor = new ComboBoxViewerCellEditor(element.viewer.getTree(), SWT.BORDER);
				editor.setContenProvider(ArrayContentProvider.getInstance());
				editor.setLabelProvider(new LabelProvider());

				((Combo) editor.getControl()).addSelectionListener(new SelectionAdapter() {
					public void widgetSelected(SelectionEvent e) {
						setCellEditorValue(LayerCompositionView.VALUE_COL, editor.getValue());
					}
				});
			}

			String[] groups = getIntersectionGroups();
			editor.setInput(groups);

			if (groups.length > 0) {
				editor.setActivationStyle(ComboBoxViewerCellEditor.DROP_DOWN_ON_PROGRAMMATIC_ACTIVATION);
			} else {
				editor.setActivationStyle(SWT.NONE);
			}

			return editor;

		} else {
			return super.getCellEditor(columnIndex);
		}
	}

}
