/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import java.util.List;

public interface LayerComposition extends Composition {

	boolean isShyEnabled();

	void setShyEnabled(boolean enabled);

	boolean isFrameBlendEnabled();

	void setFrameBlendEnabled(boolean enabled);

	boolean isMotionBlurEnabled();

	void setMotionBlurEnabled(boolean enabled);

	double getMotionBlurShutterAngle();

	void setMotionBlurShutterAngle(double shutterAngle);

	double getMotionBlurShutterPhase();

	void setMotionBlurShutterPhase(double shutterPhase);

	int getMotionBlurSamples();

	void setMotionBlurSamples(int samples);


	List<Layer> getLayers();

	Layer getLayer(String id);


	Layer getParentLayer(Layer layer);

	void setParentLayer(Layer layer, Layer parent);


	void setupCollapseTransformation(
			VideoLayerComposer composer, Camera camera, CollapseTransformation ct, MotionBlur motionBlur);

	VideoBuffer getLayerVideoFrame(Layer layer, boolean withEffects, boolean withTransformation);

	AudioBuffer getLayerAudioChunk(Layer layer, boolean withEffects, boolean withLevelsAndInOut);

}
