/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal;

import java.io.File;

import net.arnx.jsonic.JSONHint;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AbstractItem;
import ch.kuramo.javie.core.FileItem;
import ch.kuramo.javie.core.MediaFileInput;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaInputPlaceholder;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.services.MediaFileInputFactory;

import com.google.inject.Inject;
import com.google.inject.Injector;

@ProjectElement("mediaFile")
public class MediaFileItem extends AbstractItem implements MediaItem, FileItem {

	private File _file;

	private VideoBounds _videoFrameBounds;

	private MediaInput _mediaInput;

	@Inject
	private MediaFileInputFactory _mediaFileInputFactory;

	@Inject
	private Injector _injector;


	public MediaFileItem() {
		super();
	}

	public void initialize(File file) {
		super.initialize();

		MediaFileInput input = _mediaFileInputFactory.get(getId(), file);

		if (input != null) {
			_file = file;
			_videoFrameBounds = input.isVideoAvailable() ? input.getVideoFrameBounds() : null;
			_mediaInput = input;
			setName(_file.getName());
		}
	}

	@Override
	protected void finalize() throws Throwable {
		dispose();
		super.finalize();
	}

	public void dispose() {
		if (_mediaInput != null) {
			if (!(_mediaInput instanceof MediaInputPlaceholder)) {
				_mediaFileInputFactory.release(getId());
			}
			_mediaInput = null;
		}
	}

	public File getFile() {
		return _file;
	}

	public void setFile(File file) {
		_file = file;
	}

	public VideoBounds getVideoFrameBounds() {
		return _videoFrameBounds;
	}

	public void setVideoFrameBounds(VideoBounds videoFrameBounds) {
		_videoFrameBounds = videoFrameBounds;
	}

	@JSONHint(ignore=true)
	public MediaInput getMediaInput() {
		return _mediaInput;
	}

	@Override
	public void afterDecode(Project p) throws ProjectDecodeException {
		super.afterDecode(p);

		MediaFileInput input = _mediaFileInputFactory.get(getId(), _file);

		if (input != null) {
			_videoFrameBounds = input.isVideoAvailable() ? input.getVideoFrameBounds() : null;
			_mediaInput = input;
		} else {
			MediaInputPlaceholderImpl placeholder = _injector.getInstance(MediaInputPlaceholderImpl.class);
			placeholder.setVideoFrameBounds(_videoFrameBounds);
			_mediaInput = placeholder;
		}
	}

	@JSONHint(ignore=true)
	public String getKind() {
		// TODO
		return null;
	}

}
