/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.MediaInputPlaceholder;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;

import com.google.inject.Inject;

class MediaInputPlaceholderImpl implements MediaInputPlaceholder {

	private final RenderContext _context;

	private final VideoRenderSupport _vrSupport;

	private VideoBounds videoFrameBounds;

	@Inject
	MediaInputPlaceholderImpl(RenderContext context, VideoRenderSupport vrSupport) {
		_context = context;
		_vrSupport = vrSupport;
	}

	public void dispose() {
		// nothing to do
	}

	public boolean isAudioAvailable() {
		return false;
	}

	public boolean isVideoAvailable() {
		return true;
	}

	public Time getDuration() {
		return null;
	}

	public Time getVideoFrameDuration() {
		return null;
	}

	public VideoBounds getVideoFrameBounds() {
		return (videoFrameBounds != null) ? videoFrameBounds : new VideoBounds(0, 0);
	}

	void setVideoFrameBounds(VideoBounds videoFrameBounds) {
		this.videoFrameBounds = videoFrameBounds;
	}

	public AudioBuffer getAudioChunk(Time mediaTime) {
		throw new UnsupportedOperationException("audio is not available");
	}

	public VideoBuffer getVideoFrame(Time mediaTime) {
		Resolution resolution = _context.getVideoResolution();
		VideoBounds bounds = resolution.scale(getVideoFrameBounds());

		VideoBuffer videoBuffer = _vrSupport.createVideoBuffer(_context.getColorMode(), bounds);
		videoBuffer.allocateAsTexture();
		_vrSupport.fill(videoBuffer, Color.GRAY);

		return videoBuffer;
	}

}
