/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal;

import java.util.List;

import ch.kuramo.javie.core.AbstractTransformableLayer;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.NullLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.annotations.ProjectElement;

@ProjectElement("nullLayer")
public class NullLayerImpl extends AbstractTransformableLayer implements NullLayer {

	private boolean _videoEnabled = true;

	private boolean _effectsEnabled = true;

	private List<Effect> _effects = Util.newList();


	public boolean isVideoEnabled() {
		return _videoEnabled;
	}

	public void setVideoEnabled(boolean enabled) {
		_videoEnabled = enabled;
	}

	public boolean isEffectsEnabled() {
		return _effectsEnabled;
	}

	public void setEffectsEnabled(boolean effectsEnabled) {
		_effectsEnabled = effectsEnabled;
	}

	public List<Effect> getEffects() {
		return _effects;
	}

	public void setEffects(List<Effect> effects) {
		_effects = effects;
	}

	@Override
	public void afterDecode(Project p, LayerComposition c) throws ProjectDecodeException {
		super.afterDecode(p, c);

		for (Effect effect : _effects) {
			effect.afterDecode(p);
		}
	}

	@Override
	public void prepareExpression(ExpressionScope scope) {
		super.prepareExpression(scope);

		for (Effect effect : _effects) {
			effect.prepareExpression(scope.clone());
		}
	}

	public Object createExpressionElement(CoreContext context) {
		return new TransformableLayerExpressionElement(context);
	}

}
