/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.services;

import org.mozilla.javascript.ContextFactory;

import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IAudioEffectContext;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.core.internal.services.AnimatableValueCollectorImpl;
import ch.kuramo.javie.core.internal.services.AntiAliasSupportProxy;
import ch.kuramo.javie.core.internal.services.ArrayPoolsImpl;
import ch.kuramo.javie.core.internal.services.AudioEffectContextProxy;
import ch.kuramo.javie.core.internal.services.AudioEffectPipelineImpl;
import ch.kuramo.javie.core.internal.services.AudioRenderSupportImpl;
import ch.kuramo.javie.core.internal.services.EffectRegistryImpl;
import ch.kuramo.javie.core.internal.services.FontListImpl;
import ch.kuramo.javie.core.internal.services.FontManagerProxy;
import ch.kuramo.javie.core.internal.services.GLGlobalImpl;
import ch.kuramo.javie.core.internal.services.MediaFileInputFactoryImpl;
import ch.kuramo.javie.core.internal.services.ProjectDecoderImpl;
import ch.kuramo.javie.core.internal.services.ProjectElementFactoryImpl;
import ch.kuramo.javie.core.internal.services.ProjectEncoderImpl;
import ch.kuramo.javie.core.internal.services.RenderBufferPoolImpl;
import ch.kuramo.javie.core.internal.services.RenderContextProxy;
import ch.kuramo.javie.core.internal.services.ShaderRegistryImpl;
import ch.kuramo.javie.core.internal.services.SynchronousTaskThreadImpl;
import ch.kuramo.javie.core.internal.services.VideoEffectContextProxy;
import ch.kuramo.javie.core.internal.services.VideoEffectPipelineImpl;
import ch.kuramo.javie.core.internal.services.VideoRenderSupportImpl;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;

public class JavieCoreModule extends AbstractModule {

	@Override
	protected void configure() {

		// singlton

		bind(ProjectElementFactory.class)
				.to(ProjectElementFactoryImpl.class)
				.in(Scopes.SINGLETON);

		bind(ProjectEncoder.class)
				.to(ProjectEncoderImpl.class)
				.in(Scopes.SINGLETON);

		bind(ProjectDecoder.class)
				.to(ProjectDecoderImpl.class)
				.in(Scopes.SINGLETON);

		bind(MediaFileInputFactory.class)
				.to(MediaFileInputFactoryImpl.class)
				.in(Scopes.SINGLETON);

		bind(GLGlobal.class)
				.to(GLGlobalImpl.class)
				.in(Scopes.SINGLETON);

		bind(EffectRegistry.class)
				.to(EffectRegistryImpl.class)
				.in(Scopes.SINGLETON);

		ShaderRegistryImpl shaderRegistry = new ShaderRegistryImpl();

		bind(ShaderRegistry.class)
				.toInstance(shaderRegistry);

		bind(IShaderRegistry.class)
				.toInstance(shaderRegistry);

		bind(RenderContext.class)
				.to(RenderContextProxy.class)
				.in(Scopes.SINGLETON);

		bind(VideoRenderSupport.class)
				.to(VideoRenderSupportImpl.class)
				.in(Scopes.SINGLETON);

		bind(VideoEffectPipeline.class)
				.to(VideoEffectPipelineImpl.class)
				.in(Scopes.SINGLETON);

		bind(IVideoEffectContext.class)
				.to(VideoEffectContextProxy.class)
				.in(Scopes.SINGLETON);

		bind(AudioRenderSupport.class)
				.to(AudioRenderSupportImpl.class)
				.in(Scopes.SINGLETON);

		bind(AudioEffectPipeline.class)
				.to(AudioEffectPipelineImpl.class)
				.in(Scopes.SINGLETON);

		bind(IAudioEffectContext.class)
				.to(AudioEffectContextProxy.class)
				.in(Scopes.SINGLETON);

		bind(RenderBufferPool.class)
				.to(RenderBufferPoolImpl.class)
				.in(Scopes.SINGLETON);

		bind(IAntiAliasSupport.class)
				.to(AntiAliasSupportProxy.class)
				.in(Scopes.SINGLETON);

		bind(FontList.class)
				.to(FontListImpl.class)
				.in(Scopes.SINGLETON);

		bind(FontManager.class)
				.to(FontManagerProxy.class)
				.in(Scopes.SINGLETON);

		bind(IArrayPools.class)
				.to(ArrayPoolsImpl.class)
				.in(Scopes.SINGLETON);

		bind(ContextFactory.class)
				.toInstance(new ContextFactory());


		// non-singleton

		bind(SynchronousTaskThread.class)
				.to(SynchronousTaskThreadImpl.class);

		bind(AnimatableValueCollector.class)
				.to(AnimatableValueCollectorImpl.class);
	}

}
