/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.effects.keying;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;

import com.google.inject.Inject;

@Effect(id="ch.kuramo.javie.GarbageMatte16", category=Effect.KEYING)
public class GarbageMatte16 extends GarbageMatteBase {

	@Property
	private IAnimatableVec2d point1;

	@Property
	private IAnimatableVec2d point2;

	@Property
	private IAnimatableVec2d point3;

	@Property
	private IAnimatableVec2d point4;

	@Property
	private IAnimatableVec2d point5;

	@Property
	private IAnimatableVec2d point6;

	@Property
	private IAnimatableVec2d point7;

	@Property
	private IAnimatableVec2d point8;

	@Property
	private IAnimatableVec2d point9;

	@Property
	private IAnimatableVec2d point10;

	@Property
	private IAnimatableVec2d point11;

	@Property
	private IAnimatableVec2d point12;

	@Property
	private IAnimatableVec2d point13;

	@Property
	private IAnimatableVec2d point14;

	@Property
	private IAnimatableVec2d point15;

	@Property
	private IAnimatableVec2d point16;

	@Property
	private IAnimatableBoolean invert;

	@Property(min="0", max="500")
	private IAnimatableDouble feather;


	@Inject
	public GarbageMatte16(IVideoEffectContext context, IAntiAliasSupport aaSupport, IShaderRegistry shaders) {
		super(context, aaSupport, shaders);
	}

	public IVideoBuffer doVideoEffect() {
		Resolution resolution = context.getVideoResolution();
		return doMask(
				context.value(invert),
				resolution.scale(context.value(feather)),
				resolution.scale(context.value(point1)),
				resolution.scale(context.value(point2)),
				resolution.scale(context.value(point3)),
				resolution.scale(context.value(point4)),
				resolution.scale(context.value(point5)),
				resolution.scale(context.value(point6)),
				resolution.scale(context.value(point7)),
				resolution.scale(context.value(point8)),
				resolution.scale(context.value(point9)),
				resolution.scale(context.value(point10)),
				resolution.scale(context.value(point11)),
				resolution.scale(context.value(point12)),
				resolution.scale(context.value(point13)),
				resolution.scale(context.value(point14)),
				resolution.scale(context.value(point15)),
				resolution.scale(context.value(point16)));
	}

}
