/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.effects.keying;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;

import com.google.inject.Inject;

@Effect(id="ch.kuramo.javie.GarbageMatte4", category=Effect.KEYING)
public class GarbageMatte4 extends GarbageMatteBase {

	@Property
	private IAnimatableVec2d topLeft;

	@Property
	private IAnimatableVec2d topRight;

	@Property
	private IAnimatableVec2d bottomRight;

	@Property
	private IAnimatableVec2d bottomLeft;

	@Property
	private IAnimatableBoolean invert;

	@Property(min="0", max="500")
	private IAnimatableDouble feather;


	@Inject
	public GarbageMatte4(IVideoEffectContext context, IAntiAliasSupport aaSupport, IShaderRegistry shaders) {
		super(context, aaSupport, shaders);
	}

	public IVideoBuffer doVideoEffect() {
		Resolution resolution = context.getVideoResolution();
		return doMask(
				context.value(invert),
				resolution.scale(context.value(feather)),
				resolution.scale(context.value(topLeft)),
				resolution.scale(context.value(topRight)),
				resolution.scale(context.value(bottomRight)),
				resolution.scale(context.value(bottomLeft)));
	}

}
