/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ftgl;

import java.io.UnsupportedEncodingException;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;

public class FT_SfntName extends Structure {

	/**
	 * FT_UShort  platform_id;
	 */
	public short platform_id;

	/**
	 * FT_UShort  encoding_id;
	 */
	public short encoding_id;

	/**
	 * FT_UShort  language_id;
	 */
	public short language_id;

	/**
	 * FT_UShort  name_id;
	 */
	public short name_id;

	/**
	 * FT_Byte*   string;      // this string is *not* null-terminated!
	 */
	public Pointer string;

	/**
	 * FT_UInt    string_len;  // in bytes
	 */
	public int string_len;


	public String stringAsJavaString() {
		switch (platform_id) {
			case 1:
				return macintoshPlatformToJavaString();
			case 3:
				return windowsPlatformToJavaString();
			default:
				return toJavaString("UnicodeBigUnmarked");
		}
	}

	private String macintoshPlatformToJavaString() {
		switch (encoding_id) {
			case 0:
				return toJavaString("MacRoman");
			case 1:
				return toJavaString("Shift_JIS");

			// TODO 他の encoding_id についても適切なJavaエンコーディングを指定して変換する。
			default:
				return toJavaString("ASCII");
		}
	}

	private String windowsPlatformToJavaString() {
		switch (encoding_id) {
			case 0:	// Symbolの場合はUnicodeでエンコードされてるっぽい。
			case 1:
				return toJavaString("UnicodeBigUnmarked");
			case 2:
				return toJavaString("MS932");

			// TODO 他の encoding_id についても適切なJavaエンコーディングを指定して変換する。
			default:
				return toJavaString("ASCII");
		}
	}

	private String toJavaString(String encoding) {
		try {
			return new String(string.getByteArray(0, string_len), encoding);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		try {
			return new String(string.getByteArray(0, string_len), "ASCII");
		} catch (UnsupportedEncodingException e) {
			// ASCIIは基本エンコーディングなので必ず存在する。
			throw new Error(e);
		}
	}

}
