/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.api;

import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;

public final class Resolution {
    public static final Resolution FULL = new Resolution(1.0);
    public static final Resolution HALF = new Resolution(0.5);
    public static final Resolution ONETHIRD = new Resolution(0.3333333333333333);
    public static final Resolution QUARTER = new Resolution(0.25);
    public final double scale;

    public Resolution(double scale) {
        this.scale = scale;
    }

    public double scale(double d) {
        return d * this.scale;
    }

    public Size2i scale(Size2i size) {
        return this.scale == 1.0 ? size : new Size2i((int)((double)size.width * this.scale), (int)((double)size.height * this.scale));
    }

    public VideoBounds scale(VideoBounds bounds) {
        return this.scale == 1.0 ? bounds : new VideoBounds(bounds.x * this.scale, bounds.y * this.scale, (int)((double)bounds.width * this.scale), (int)((double)bounds.height * this.scale));
    }

    public Vec2d scale(Vec2d vec) {
        return this.scale == 1.0 ? vec : new Vec2d(vec.x * this.scale, vec.y * this.scale);
    }

    public Vec3d scale(Vec3d vec) {
        return this.scale == 1.0 ? vec : new Vec3d(vec.x * this.scale, vec.y * this.scale, vec.z * this.scale);
    }

    public void scale(double[] array) {
        if (this.scale != 1.0) {
            int i = 0;
            while (i < array.length) {
                int n = i++;
                array[n] = array[n] * this.scale;
            }
        }
    }

    public void scale(float[] array) {
        if (this.scale != 1.0) {
            int i = 0;
            while (i < array.length) {
                int n = i++;
                array[n] = (float)((double)array[n] * this.scale);
            }
        }
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.scale);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resolution other = (Resolution)obj;
        return Double.doubleToLongBits(this.scale) == Double.doubleToLongBits(other.scale);
    }

    public String toString() {
        return "Resolution [" + this.scale + "]";
    }
}

