/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectDescriptor;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.Expressionee;
import ch.kuramo.javie.core.Expressioner;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.PropertyDescriptor;
import ch.kuramo.javie.core.services.EffectRegistry;
import com.google.inject.Injector;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.arnx.jsonic.JSONHint;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEffect
implements Effect {
    protected final Object _interior;
    protected final EffectDescriptor _descriptor;
    protected boolean _enabled;
    protected String _name;

    public AbstractEffect(Injector injector, EffectRegistry registry) {
        this._interior = injector.getInstance(this.getInteriorClass());
        this._descriptor = registry.getEffectDescriptor(this.getType());
        this._enabled = true;
        this._name = this._descriptor.getLabel();
        for (PropertyDescriptor pd : this._descriptor.getPropertyDescriptors()) {
            pd.initValue(this);
        }
    }

    protected abstract Class<?> getInteriorClass();

    public abstract String getType();

    @Override
    @JSONHint(ignore=true)
    public EffectDescriptor getEffectDescriptor() {
        return this._descriptor;
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public void afterDecode(Project p) throws ProjectDecodeException {
        for (PropertyDescriptor pd : this._descriptor.getPropertyDescriptors()) {
            pd.afterDecode(p, this);
        }
    }

    @Override
    public void prepareExpression(ExpressionScope scope) {
        scope.putExpressionElement("thisEffect", this);
        for (PropertyDescriptor pd : this._descriptor.getPropertyDescriptors()) {
            if (!Expressioner.class.isAssignableFrom(pd.getPropertyClass())) continue;
            scope.assignTo((Expressioner)pd.get(this));
        }
    }

    @Override
    public Object createExpressionElement(final CoreContext context) {
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String name = method.getName();
                if (!name.startsWith("get")) {
                    return Scriptable.NOT_FOUND;
                }
                PropertyDescriptor pd = AbstractEffect.this._descriptor.getPropertyDescriptor(name = String.valueOf(Character.toLowerCase(name.charAt(3))) + name.substring(4));
                if (pd == null) {
                    return Scriptable.NOT_FOUND;
                }
                Object value = pd.get(AbstractEffect.this);
                if (value instanceof Expressionee) {
                    return context.getExpressionElement((Expressionee)value);
                }
                return value;
            }
        };
        Class<?> exprInterface = this._descriptor.getExpressionInterface();
        return Proxy.newProxyInstance(exprInterface.getClassLoader(), new Class[]{exprInterface}, handler);
    }
}

