/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.FrameDuration;
import ch.kuramo.javie.core.MediaOptions;
import ch.kuramo.javie.core.MediaSource;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import com.ibm.icu.text.Normalizer;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageSequenceSource
implements MediaSource {
    private static final Logger _logger = LoggerFactory.getLogger(ImageSequenceSource.class);
    private File[] _files;
    private VideoBounds _videoBounds;
    private final RenderContext _context;
    private final VideoRenderSupport _vrSupport;

    @Inject
    public ImageSequenceSource(RenderContext context, VideoRenderSupport vrSupport) {
        this._context = context;
        this._vrSupport = vrSupport;
    }

    public boolean initialize(File file) {
        BufferedImage image;
        block12: {
            Pattern pattern1 = Pattern.compile("^(.*?)(\\d+)?(\\.[^.]+)?$");
            Matcher matcher = pattern1.matcher(Normalizer.normalize((String)file.getName(), (Normalizer.Mode)Normalizer.NFKC));
            matcher.matches();
            String group1 = matcher.group(1);
            String group2 = matcher.group(2);
            String group3 = matcher.group(3);
            if (group2.length() > 0) {
                final Map fileMap = Util.newMap();
                final int[] minMax = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
                final Pattern pattern2 = Pattern.compile(String.format("^\\Q%s\\E(\\d+)\\Q%s\\E$", group1, group3), 2);
                file.getParentFile().listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        Matcher matcher = pattern2.matcher(Normalizer.normalize((String)file.getName(), (Normalizer.Mode)Normalizer.NFKC));
                        if (matcher.matches()) {
                            Integer number = Integer.valueOf(matcher.group(1));
                            if (fileMap.containsKey(number)) {
                                _logger.info("duplicated: " + file.getName());
                            } else {
                                fileMap.put(number, file);
                                minMax[0] = Math.min(minMax[0], number);
                                minMax[1] = Math.max(minMax[1], number);
                            }
                        }
                        return false;
                    }
                });
                if (!fileMap.isEmpty()) {
                    this._files = new File[minMax[1] - minMax[0] + 1];
                    int lacked = 0;
                    int i = 0;
                    int n = this._files.length;
                    while (i < n) {
                        this._files[i] = (File)fileMap.get(i + minMax[0]);
                        if (this._files[i] == null) {
                            ++lacked;
                            _logger.info("lacked: frameNumber=" + i);
                        }
                        ++i;
                    }
                    if (lacked > 0) {
                        _logger.info("lacked: " + lacked + (lacked == 1 ? " file" : " files"));
                    }
                }
            } else if (group3.length() > 0) {
                final Pattern pattern2 = Pattern.compile(String.format("^.*?\\Q%s\\E$", group3), 2);
                File[] files = file.getParentFile().listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return pattern2.matcher(Normalizer.normalize((String)file.getName(), (Normalizer.Mode)Normalizer.NFKC)).matches();
                    }
                });
                if (files != null && files.length > 0) {
                    Arrays.sort(files, new Comparator<File>(){

                        @Override
                        public int compare(File o1, File o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    this._files = files;
                }
            }
            if (this._files == null) {
                return false;
            }
            try {
                image = ImageIO.read(this._files[0]);
                if (image != null) break block12;
                _logger.warn("error reading image file: ImageIO.read returns null");
                return false;
            }
            catch (IOException e) {
                _logger.warn("error reading image file", (Throwable)e);
                return false;
            }
        }
        this._videoBounds = new VideoBounds(image.getWidth(), image.getHeight());
        return true;
    }

    public void dispose() {
    }

    public Time getDuration(MediaOptions options) {
        if (options == null) {
            return null;
        }
        Time vfd = this.getVideoFrameDuration(options);
        return new Time(vfd.timeValue * (long)this._files.length, vfd.timeScale);
    }

    public Time getVideoFrameDuration(MediaOptions options) {
        if (options == null) {
            return null;
        }
        Time vfd = options.getVideoFrameDuration();
        return vfd != null ? vfd : FrameDuration.FPS_29_97;
    }

    public VideoBounds getVideoFrameBounds(MediaOptions options) {
        return this._videoBounds;
    }

    public IVideoBuffer getVideoFrame(Time mediaTime, MediaOptions options) {
        Object array;
        ColorMode colorMode;
        Resolution resolution = this._context.getVideoResolution();
        Size2i scaledSize = resolution.scale(new Size2i(this._videoBounds.width, this._videoBounds.height));
        BufferedImage image = null;
        long frameNumber = mediaTime.toFrameNumber(this.getVideoFrameDuration(options));
        while (image == null && frameNumber >= 0L) {
            File file = this._files[(int)frameNumber];
            if (file != null) {
                try {
                    image = ImageIO.read(file);
                    if (image == null) {
                        _logger.warn("error reading image file: ImageIO.read returns null");
                    }
                }
                catch (IOException e) {
                    _logger.warn("error reading image file", (Throwable)e);
                }
            }
            --frameNumber;
        }
        if (image != null) {
            colorMode = image.getColorModel().getPixelSize() > 32 ? ColorMode.RGBA16 : ColorMode.RGBA8;
            array = this.toInternalFormat(image, colorMode, scaledSize);
        } else {
            array = new byte[scaledSize.width * scaledSize.height * 4];
            colorMode = ColorMode.RGBA8;
        }
        ColorMode contextColorMode = this._context.getColorMode();
        IVideoBuffer videoBuffer = this._vrSupport.createVideoBuffer(contextColorMode, scaledSize);
        videoBuffer.copyToTexture(array, colorMode);
        return videoBuffer;
    }

    public boolean isVideoAvailable() {
        return true;
    }

    public boolean isAudioAvailable() {
        return false;
    }

    public IAudioBuffer getAudioChunk(Time mediaTime, MediaOptions options) {
        throw new UnsupportedOperationException("audio is not available");
    }

    public MediaOptions validateOptions(MediaOptions options) {
        MediaOptions.Option[] availableOptions = new MediaOptions.Option[]{MediaOptions.Option.VIDEO_FRAME_DURATION};
        if (options == null) {
            options = new MediaOptions(availableOptions);
        } else {
            options = options.clone();
            options.setAvailableOptions(availableOptions);
        }
        return options;
    }

    File getFirstFile() {
        return this._files[0];
    }

    private Object toInternalFormat(BufferedImage srcImage, ColorMode srcColorMode, Size2i scaleTo) {
        int dataType = srcColorMode == ColorMode.RGBA16 ? 1 : 0;
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[1] = 1;
        nArray[3] = 3;
        WritableRaster wr = Raster.createInterleavedRaster(dataType, scaleTo.width, scaleTo.height, scaleTo.width * 4, 4, nArray, null);
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), true, true, 3, dataType);
        BufferedImage tmpImage = new BufferedImage(cm, wr, true, null);
        Graphics2D g = tmpImage.createGraphics();
        g.drawImage(srcImage, 0, 0, scaleTo.width, scaleTo.height, null);
        DataBuffer dataBuffer = tmpImage.getRaster().getDataBuffer();
        return dataType == 1 ? ((DataBufferUShort)dataBuffer).getData() : (short[])((DataBufferByte)dataBuffer).getData();
    }
}

