/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.CollapseTransformation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.TransformableLayer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;

class LayerMatrixUtil {
    private final RenderContext _context;
    private final VideoRenderSupport _vrSupport;

    static void multModelViewMatrix(TransformableLayer layer, Vec2d offset, CollapseTransformation ct, RenderContext context, VideoRenderSupport vrSupport) {
        LayerMatrixUtil util = new LayerMatrixUtil(context, vrSupport);
        if (ct != null) {
            util.multCollapseTransformation(ct, LayerNature.isThreeD(layer));
        }
        util.multModelViewMatrix(layer, offset, true);
    }

    static void multParentMatrix(CameraLayer cameraLayer, RenderContext context, VideoRenderSupport vrSupport) {
        Layer parent = ((LayerComposition)context.getComposition()).getParentLayer(cameraLayer);
        if (parent != null) {
            new LayerMatrixUtil(context, vrSupport).multModelViewMatrixInverse(parent, null, true);
        }
    }

    private LayerMatrixUtil(RenderContext context, VideoRenderSupport vrSupport) {
        this._context = context;
        this._vrSupport = vrSupport;
    }

    private void multCollapseTransformation(final CollapseTransformation ct, final boolean threeD) {
        final MediaItemLayer layer = ct.getLayer();
        if (ct.getParent() != null) {
            this.multCollapseTransformation(ct.getParent(), threeD && LayerNature.isThreeD(layer));
        }
        this._context.saveAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                LayerMatrixUtil.this._context.setTime(ct.getTime());
                LayerMatrixUtil.this.multModelViewMatrix(layer, null, threeD);
                return null;
            }
        });
    }

    private void multModelViewMatrix(Layer layer, Vec2d offset, boolean threeD) {
        threeD &= LayerNature.isThreeD(layer);
        Layer parent = ((LayerComposition)this._context.getComposition()).getParentLayer(layer);
        if (parent != null) {
            this.multModelViewMatrix(parent, null, threeD);
        }
        if (layer instanceof TransformableLayer) {
            this.multTransformableLayerMatrix((TransformableLayer)layer, offset, threeD, false);
        } else if (layer instanceof CameraLayer) {
            this.multCameraLayerMatrix((CameraLayer)layer, threeD, false);
        }
    }

    private void multModelViewMatrixInverse(Layer layer, Vec2d offset, boolean threeD) {
        threeD &= LayerNature.isThreeD(layer);
        if (layer instanceof TransformableLayer) {
            this.multTransformableLayerMatrix((TransformableLayer)layer, offset, threeD, true);
        } else if (layer instanceof CameraLayer) {
            this.multCameraLayerMatrix((CameraLayer)layer, threeD, true);
        }
        Layer parent = ((LayerComposition)this._context.getComposition()).getParentLayer(layer);
        if (parent != null) {
            this.multModelViewMatrixInverse(parent, null, threeD);
        }
    }

    private void multTransformableLayerMatrix(TransformableLayer tlayer, Vec2d offset, boolean threeD, boolean inverse) {
        Vec3d rotation;
        Vec3d orientation;
        if (!LayerNature.isVideoNature(tlayer)) {
            return;
        }
        Vec3d anchorPoint = (Vec3d)tlayer.getAnchorPoint().value(this._context);
        if (offset != null) {
            anchorPoint = new Vec3d(anchorPoint.x + offset.x, anchorPoint.y + offset.y, anchorPoint.z);
        }
        Vec3d scale = (Vec3d)tlayer.getScale().value(this._context);
        Vec3d position = (Vec3d)tlayer.getPosition().value(this._context);
        if (threeD) {
            orientation = (Vec3d)tlayer.getOrientation().value(this._context);
            rotation = new Vec3d(((Double)tlayer.getRotationX().value(this._context)).doubleValue(), ((Double)tlayer.getRotationY().value(this._context)).doubleValue(), ((Double)tlayer.getRotationZ().value(this._context)).doubleValue());
        } else {
            anchorPoint = new Vec3d(anchorPoint.x, anchorPoint.y, 0.0);
            scale = new Vec3d(scale.x, scale.y, 100.0);
            orientation = new Vec3d(0.0, 0.0, 0.0);
            rotation = new Vec3d(0.0, 0.0, ((Double)tlayer.getRotationZ().value(this._context)).doubleValue());
            position = new Vec3d(position.x, position.y, 0.0);
        }
        Resolution resolution = this._context.getVideoResolution();
        if (inverse) {
            this._vrSupport.multModelViewMatrixInverse(resolution.scale(anchorPoint), scale, orientation, rotation, resolution.scale(position));
        } else {
            this._vrSupport.multModelViewMatrix(resolution.scale(anchorPoint), scale, orientation, rotation, resolution.scale(position));
        }
    }

    private void multCameraLayerMatrix(CameraLayer clayer, boolean threeD, boolean inverse) {
        Resolution resolution = this._context.getVideoResolution();
        Vec3d position = (Vec3d)clayer.getPosition().value(this._context);
        Vec3d pointOfInterest = (Vec3d)clayer.getPointOfInterest().value(this._context);
        if (threeD) {
            Vec3d orientation = (Vec3d)clayer.getOrientation().value(this._context);
            Vec3d rotation = new Vec3d(((Double)clayer.getRotationX().value(this._context)).doubleValue(), ((Double)clayer.getRotationY().value(this._context)).doubleValue(), ((Double)clayer.getRotationZ().value(this._context)).doubleValue());
            if (inverse) {
                this._vrSupport.multCameraMatrix(orientation, rotation, resolution.scale(position), resolution.scale(pointOfInterest), false);
            } else {
                this._vrSupport.multCameraMatrixInverse(orientation, rotation, resolution.scale(position), resolution.scale(pointOfInterest));
            }
        } else {
            Vec3d anchorPoint = new Vec3d(pointOfInterest.x, pointOfInterest.y, 0.0);
            Vec3d scale = new Vec3d(100.0, 100.0, 100.0);
            Vec3d orientation = new Vec3d(0.0, 0.0, 0.0);
            Vec3d rotation = new Vec3d(0.0, 0.0, ((Double)clayer.getRotationZ().value(this._context)).doubleValue());
            position = new Vec3d(position.x, position.y, 0.0);
            if (inverse) {
                this._vrSupport.multModelViewMatrixInverse(resolution.scale(anchorPoint), scale, orientation, rotation, resolution.scale(position));
            } else {
                this._vrSupport.multModelViewMatrix(resolution.scale(anchorPoint), scale, orientation, rotation, resolution.scale(position));
            }
        }
    }
}

