/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IConvolutionSupport;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.Util;
import com.google.inject.Inject;
import java.util.Arrays;

public class BlurSupportImpl
implements IBlurSupport {
    private final IVideoRenderSupport support;
    private final IConvolutionSupport convolution;
    private static final int[][] DOWNSAMPLE_RATIOS = new int[][]{{300, 7, 7}, {200, 5, 7}, {150, 5, 5}, {100, 3, 5}, {50, 3, 3}, {30, 5}, {10, 3}};

    @Inject
    public BlurSupportImpl(IVideoRenderSupport support, IConvolutionSupport convolution) {
        this.support = support;
        this.convolution = convolution;
    }

    private int[] getDownSampleRatios(double hint) {
        int i = 0;
        while (i < DOWNSAMPLE_RATIOS.length) {
            if (hint >= (double)DOWNSAMPLE_RATIOS[i][0]) {
                int[] ratios = new int[DOWNSAMPLE_RATIOS[i].length - 1];
                int j = 0;
                while (j < ratios.length) {
                    ratios[j] = DOWNSAMPLE_RATIOS[i][j + 1];
                    ++j;
                }
                return ratios;
            }
            ++i;
        }
        return new int[0];
    }

    private void doDownSample(IVideoBuffer input, IVideoBuffer output, int hRatio, int vRatio) {
        int ksize = hRatio * vRatio;
        float[] kernel = new float[ksize];
        float[] offset = new float[ksize * 2];
        int j = 0;
        while (j < vRatio) {
            int i = 0;
            while (i < hRatio) {
                int k = j * hRatio + i;
                kernel[k] = 1.0f / (float)ksize;
                offset[k * 2] = i - hRatio / 2;
                offset[k * 2 + 1] = j - vRatio / 2;
                ++i;
            }
            ++j;
        }
        final VideoBounds bounds = output.getBounds();
        int w = bounds.width * hRatio;
        int h = bounds.height * vRatio;
        final double[][] texCoords = new double[][]{{0.0, 0.0}, {w, 0.0}, {w, h}, {0.0, h}};
        Runnable operation = new Runnable(){

            public void run() {
                BlurSupportImpl.this.support.ortho2D(bounds);
                BlurSupportImpl.this.support.quad2D(bounds, (double[][][])new double[][][]{texCoords});
            }
        };
        this.convolution.convolve(input, output, kernel, offset, operation, 0);
    }

    private void doUpSample(IVideoBuffer input, IVideoBuffer output, int hRatio, int vRatio) {
        final VideoBounds bounds = output.getBounds();
        double w = (double)bounds.width / (double)hRatio;
        double h = (double)bounds.height / (double)vRatio;
        final double[][] texCoords = new double[][]{{0.0, 0.0}, {w, 0.0}, {w, h}, {0.0, h}};
        Runnable operation = new Runnable(){

            public void run() {
                BlurSupportImpl.this.support.ortho2D(bounds);
                BlurSupportImpl.this.support.quad2D(bounds, (double[][][])new double[][][]{texCoords});
            }
        };
        IVideoBuffer.TextureFilter currFilter = input.getTextureFilter();
        try {
            input.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
            this.support.useFramebuffer(operation, 0, output, new IVideoBuffer[]{input});
        }
        finally {
            input.setTextureFilter(currFilter);
        }
    }

    private VideoBounds expandBounds(VideoBounds bounds, int hExpand, int vExpand) {
        int dx = -hExpand;
        int dw = hExpand * 2;
        int dy = -vExpand;
        int dh = vExpand * 2;
        return new VideoBounds(bounds.x + (double)dx, bounds.y + (double)dy, bounds.width + dw, bounds.height + dh);
    }

    private VideoBounds calcBlurredBounds(VideoBounds bounds, double radius, IBlurSupport.BlurDimensions dimensions, boolean fast, boolean boxBlur) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("radius must be greater than 0");
        }
        boolean horz = dimensions != IBlurSupport.BlurDimensions.VERTICAL;
        boolean vert = dimensions != IBlurSupport.BlurDimensions.HORIZONTAL;
        int totalRatio = 1;
        if (fast) {
            int[] nArray = this.getDownSampleRatios(radius);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int ratio = nArray[n2];
                int hRatio = horz ? ratio : 1;
                int vRatio = vert ? ratio : 1;
                bounds = new VideoBounds(bounds.x / (double)hRatio, bounds.y / (double)vRatio, (bounds.width + hRatio - 1) / hRatio, (bounds.height + vRatio - 1) / vRatio);
                totalRatio *= ratio;
                ++n2;
            }
            radius /= (double)totalRatio;
            if (boxBlur && totalRatio != 1) {
                radius -= 0.3333333333333333;
            }
        }
        int ceiledRadius = (int)Math.ceil(radius);
        int hExpand = horz ? ceiledRadius : 0;
        int vExpand = vert ? ceiledRadius : 0;
        bounds = this.expandBounds(bounds, hExpand, vExpand);
        int hRatio = horz ? totalRatio : 1;
        int vRatio = vert ? totalRatio : 1;
        return new VideoBounds(bounds.x * (double)hRatio, bounds.y * (double)vRatio, bounds.width * hRatio, bounds.height * vRatio);
    }

    private float[] createBlurKernel(double radius, boolean boxBlur) {
        int ceiledRadius = (int)Math.ceil(radius);
        float[] kernel = new float[ceiledRadius * 2 + 1];
        if (boxBlur) {
            Arrays.fill(kernel, (float)(1.0 / (radius * 2.0 + 1.0)));
            if (radius != (double)ceiledRadius) {
                kernel[0] = (float)((double)kernel[0] * (1.0 - ((double)ceiledRadius - radius)));
                int n = kernel.length - 1;
                kernel[n] = (float)((double)kernel[n] * (1.0 - ((double)ceiledRadius - radius)));
            }
        } else {
            double sigma = radius / 2.5;
            double sigmaSquare = sigma * sigma;
            float sum = 0.0f;
            int i = 1;
            while (i <= ceiledRadius) {
                float f = (float)Math.exp((double)(-i * i) / (2.0 * sigmaSquare));
                kernel[ceiledRadius - i] = f;
                sum += 2.0f * f;
                ++i;
            }
            kernel[ceiledRadius] = 1.0f / (sum += 1.0f);
            i = 1;
            while (i <= ceiledRadius) {
                int n = ceiledRadius - i;
                float f = kernel[n] / sum;
                kernel[n] = f;
                kernel[ceiledRadius + i] = f;
                ++i;
            }
        }
        return kernel;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IVideoBuffer blur(IVideoBuffer input, ColorMode colorMode, double radius, IBlurSupport.BlurDimensions dimensions, boolean repeatEdgePixels, boolean fast, boolean boxBlur) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("radius must be greater than 0");
        }
        tmpBuffers = Util.newSet();
        try {
            horz = dimensions != IBlurSupport.BlurDimensions.VERTICAL;
            vert = dimensions != IBlurSupport.BlurDimensions.HORIZONTAL;
            buffer = input;
            inputBounds = input.getBounds();
            totalRatio = 1;
            if (fast) {
                bounds = inputBounds;
                var19_16 = this.getDownSampleRatios(radius);
                var18_17 = var19_16.length;
                var17_20 = 0;
                while (var17_20 < var18_17) {
                    ratio = var19_16[var17_20];
                    if (repeatEdgePixels) {
                        buffer.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE);
                    }
                    hRatio = horz != false ? ratio : 1;
                    vRatio = vert != false ? ratio : 1;
                    bounds = new VideoBounds(bounds.x / (double)hRatio, bounds.y / (double)vRatio, (bounds.width + hRatio - 1) / hRatio, (bounds.height + vRatio - 1) / vRatio);
                    tmp = this.support.createVideoBuffer(bounds, colorMode);
                    tmpBuffers.add(tmp);
                    this.doDownSample(buffer, tmp, hRatio, vRatio);
                    buffer = tmp;
                    totalRatio *= ratio;
                    ++var17_20;
                }
                radius /= (double)totalRatio;
                if (boxBlur && totalRatio != 1) {
                    radius -= 0.3333333333333333;
                }
            }
            ceiledRadius = (int)Math.ceil(radius);
            kernel = this.createBlurKernel(radius, boxBlur);
            if (horz) {
                bounds = buffer.getBounds();
                if (repeatEdgePixels) {
                    buffer.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE);
                } else {
                    bounds = this.expandBounds(bounds, ceiledRadius, 0);
                }
                tmp = this.support.createVideoBuffer(bounds, colorMode);
                tmpBuffers.add(tmp);
                this.convolution.convolve1D(buffer, tmp, kernel, IConvolutionSupport.ConvolutionDirection.HORIZONTAL);
                buffer = tmp;
            }
            if (vert) {
                bounds = buffer.getBounds();
                if (repeatEdgePixels) {
                    buffer.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE);
                } else {
                    bounds = this.expandBounds(bounds, 0, ceiledRadius);
                }
                tmp = this.support.createVideoBuffer(bounds, colorMode);
                tmpBuffers.add(tmp);
                this.convolution.convolve1D(buffer, tmp, kernel, IConvolutionSupport.ConvolutionDirection.VERTICAL);
                buffer = tmp;
            }
            if (totalRatio != 1) {
                hRatio = horz != false ? totalRatio : 1;
                v0 = vRatio = vert != false ? totalRatio : 1;
                if (repeatEdgePixels) {
                    buffer.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE);
                    bounds = inputBounds;
                } else {
                    bounds = buffer.getBounds();
                    bounds = new VideoBounds(bounds.x * (double)hRatio, bounds.y * (double)vRatio, bounds.width * hRatio, bounds.height * vRatio);
                }
                tmp = this.support.createVideoBuffer(bounds, colorMode);
                tmpBuffers.add(tmp);
                this.doUpSample(buffer, tmp, hRatio, vRatio);
                buffer = tmp;
            }
            tmpBuffers.remove(buffer);
            var24_30 = buffer;
            return var24_30;
        }
        finally {
            ** for (vb : tmpBuffers)
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl81:
        // 1 sources

        return var24_30;
    }

    public VideoBounds calcGaussianBlurredBounds(VideoBounds inputBounds, double radius, IBlurSupport.BlurDimensions dimensions, boolean fast) {
        return this.calcBlurredBounds(inputBounds, radius, dimensions, fast, false);
    }

    public float[] createGaussianBlurKernel(double radius) {
        return this.createBlurKernel(radius, false);
    }

    public IVideoBuffer gaussianBlur(IVideoBuffer input, double radius, IBlurSupport.BlurDimensions dimensions, boolean repeatEdgePixels, boolean fast) {
        return this.gaussianBlur(input, input.getColorMode(), radius, dimensions, repeatEdgePixels, fast);
    }

    public IVideoBuffer gaussianBlur(IVideoBuffer input, ColorMode colorMode, double radius, IBlurSupport.BlurDimensions dimensions, boolean repeatEdgePixels, boolean fast) {
        IVideoBuffer.TextureWrapMode wrapMode = repeatEdgePixels ? input.getTextureWrapMode() : null;
        try {
            IVideoBuffer iVideoBuffer = this.blur(input, colorMode, radius, dimensions, repeatEdgePixels, fast, false);
            return iVideoBuffer;
        }
        finally {
            if (wrapMode != null) {
                input.setTextureWrapMode(wrapMode);
            }
        }
    }

    public VideoBounds calcBoxBlurredBounds(VideoBounds inputBounds, double radius, IBlurSupport.BlurDimensions dimensions, boolean fast, int boxIterations) {
        if (boxIterations < 1) {
            throw new IllegalArgumentException("boxIterations must be 1 or greater");
        }
        VideoBounds bounds = inputBounds;
        int i = 0;
        while (i < boxIterations) {
            bounds = this.calcBlurredBounds(bounds, radius, dimensions, fast, true);
            ++i;
        }
        return bounds;
    }

    public float[] createBoxBlurKernel(double radius) {
        return this.createBlurKernel(radius, true);
    }

    public IVideoBuffer boxBlur(IVideoBuffer input, double radius, IBlurSupport.BlurDimensions dimensions, boolean repeatEdgePixels, boolean fast, int boxIterations) {
        return this.boxBlur(input, input.getColorMode(), radius, dimensions, repeatEdgePixels, fast, boxIterations);
    }

    public IVideoBuffer boxBlur(IVideoBuffer input, ColorMode colorMode, double radius, IBlurSupport.BlurDimensions dimensions, boolean repeatEdgePixels, boolean fast, int boxIterations) {
        if (boxIterations < 1) {
            throw new IllegalArgumentException("boxIterations must be 1 or greater");
        }
        IVideoBuffer.TextureWrapMode wrapMode = repeatEdgePixels ? input.getTextureWrapMode() : null;
        try {
            IVideoBuffer buffer = this.blur(input, colorMode, radius, dimensions, repeatEdgePixels, fast, true);
            int i = 1;
            while (i < boxIterations) {
                IVideoBuffer old = buffer;
                try {
                    buffer = this.blur(buffer, colorMode, radius, dimensions, repeatEdgePixels, fast, true);
                }
                finally {
                    old.dispose();
                }
                ++i;
            }
            IVideoBuffer iVideoBuffer = buffer;
            return iVideoBuffer;
        }
        finally {
            if (wrapMode != null) {
                input.setTextureWrapMode(wrapMode);
            }
        }
    }
}

