/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.core.EffectConverter;
import ch.kuramo.javie.core.JavieRuntimeException;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;

class ConverterClassProcessor {
    private final ClassLoader cl;
    private final String convertTo;
    private final CtClass cc;

    ConverterClassProcessor(ClassLoader cl, String convertTo, CtClass cc) {
        this.cl = cl;
        this.convertTo = convertTo;
        this.cc = cc;
    }

    EffectConverter process() {
        try {
            ClassPool pool = this.cc.getClassPool();
            CtClass[] methodParams = new CtClass[]{pool.get("java.util.Map")};
            try {
                this.cc.getDeclaredMethod("convert", methodParams);
            }
            catch (NotFoundException notFoundException) {
                this.cc.addMethod(CtMethod.make((String)"public void convert(java.util.Map map) { }", (CtClass)this.cc));
            }
            String getNewTypeMethod = String.format("public String getNewType() { return \"%s\"; }", this.convertTo.replaceAll("\"", "\\\\\""));
            this.cc.addMethod(CtMethod.make((String)getNewTypeMethod, (CtClass)this.cc));
            this.cc.addInterface(pool.get("ch.kuramo.javie.core.EffectConverter"));
            Class clazz = this.cc.toClass(this.cl, null);
            return (EffectConverter)clazz.newInstance();
        }
        catch (NotFoundException e) {
            throw new JavieRuntimeException(e);
        }
        catch (CannotCompileException e) {
            throw new JavieRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new JavieRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new JavieRuntimeException(e);
        }
    }
}

