/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.DepthBuffer;
import ch.kuramo.javie.core.TrackMatte;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.VideoLayerBuffer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.DepthBufferImpl;
import ch.kuramo.javie.core.internal.VideoBufferImpl;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import ch.kuramo.javie.core.shaders.AccumulationShaders;
import ch.kuramo.javie.core.shaders.BlendModeShaders;
import ch.kuramo.javie.core.shaders.TrackMatteShaders;
import com.google.inject.Inject;
import com.google.inject.Injector;
import ftgl.FTGL;
import ftgl.FTGLfont;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoRenderSupportImplOld
implements VideoRenderSupport {
    private static final Logger _logger = LoggerFactory.getLogger(VideoRenderSupportImplOld.class);
    private static final float[] FLOAT0000 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    @Inject
    private Injector _injector;
    @Inject
    private GLGlobal _glGlobal;
    @Inject
    private RenderContext _context;
    @Inject
    private IVideoRenderSupport _support;
    @Inject
    private IShaderRegistry _shaders;
    @Inject
    private IAntiAliasSupport _aaSupport;
    @Inject
    private IArrayPools _arrayPools;
    private static final int[][] _frustumEdgeTable;
    private static final int[][] _frustumClipSearchTable;

    static {
        int[][] nArrayArray = new int[12][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 6;
        nArrayArray[2] = nArray3;
        nArrayArray[3] = new int[]{1, 3};
        nArrayArray[4] = new int[]{1, 7};
        nArrayArray[5] = new int[]{2, 3};
        nArrayArray[6] = new int[]{2, 4};
        nArrayArray[7] = new int[]{3, 5};
        nArrayArray[8] = new int[]{4, 5};
        nArrayArray[9] = new int[]{4, 6};
        nArrayArray[10] = new int[]{5, 7};
        nArrayArray[11] = new int[]{6, 7};
        _frustumEdgeTable = nArrayArray;
        int[][] nArrayArray2 = new int[12][];
        nArrayArray2[0] = new int[]{1, 3, 5, 2, 4, 11};
        int[] nArray4 = new int[6];
        nArray4[1] = 3;
        nArray4[2] = 5;
        nArray4[3] = 2;
        nArray4[4] = 6;
        nArray4[5] = 9;
        nArrayArray2[1] = nArray4;
        int[] nArray5 = new int[6];
        nArray5[0] = 1;
        nArray5[1] = 6;
        nArray5[2] = 9;
        nArray5[4] = 4;
        nArray5[5] = 11;
        nArrayArray2[2] = nArray5;
        int[] nArray6 = new int[6];
        nArray6[1] = 1;
        nArray6[2] = 5;
        nArray6[3] = 4;
        nArray6[4] = 7;
        nArray6[5] = 10;
        nArrayArray2[3] = nArray6;
        int[] nArray7 = new int[6];
        nArray7[1] = 2;
        nArray7[2] = 11;
        nArray7[3] = 3;
        nArray7[4] = 7;
        nArray7[5] = 10;
        nArrayArray2[4] = nArray7;
        int[] nArray8 = new int[6];
        nArray8[1] = 1;
        nArray8[2] = 3;
        nArray8[3] = 6;
        nArray8[4] = 7;
        nArray8[5] = 8;
        nArrayArray2[5] = nArray8;
        nArrayArray2[6] = new int[]{1, 2, 9, 5, 7, 8};
        nArrayArray2[7] = new int[]{3, 4, 10, 5, 6, 8};
        nArrayArray2[8] = new int[]{5, 6, 7, 9, 10, 11};
        nArrayArray2[9] = new int[]{1, 2, 6, 8, 10, 11};
        nArrayArray2[10] = new int[]{3, 4, 7, 8, 9, 11};
        int[] nArray9 = new int[6];
        nArray9[1] = 2;
        nArray9[2] = 4;
        nArray9[3] = 8;
        nArray9[4] = 9;
        nArray9[5] = 10;
        nArrayArray2[11] = nArray9;
        _frustumClipSearchTable = nArrayArray2;
    }

    @Override
    public IVideoBuffer createVideoBuffer(ColorMode colorMode, Size2i size) {
        return new VideoBufferImpl(colorMode, new VideoBounds(size), this._context, this._support, this._arrayPools, this._glGlobal);
    }

    @Override
    public IVideoBuffer createVideoBuffer(ColorMode colorMode, VideoBounds bounds) {
        return new VideoBufferImpl(colorMode, bounds, this._context, this._support, this._arrayPools, this._glGlobal);
    }

    @Override
    public DepthBuffer createDepthBuffer(Size2i size) {
        DepthBufferImpl db = new DepthBufferImpl(size);
        this._injector.injectMembers((Object)db);
        return db;
    }

    @Override
    public int createDepthTexture(Size2i textureSize) {
        GL2 gl = this._context.getGL().getGL2();
        int[] tex = new int[1];
        gl.glGenTextures(1, tex, 0);
        gl.glBindTexture(34037, tex[0]);
        gl.glTexParameteri(34037, 10241, 9728);
        gl.glTexParameteri(34037, 10240, 9728);
        gl.glTexParameteri(34037, 10242, 33069);
        gl.glTexParameteri(34037, 10243, 33069);
        gl.glTexParameterfv(34037, 4100, FLOAT0000, 0);
        gl.glTexImage2D(34037, 0, 6402, Math.max(1, textureSize.width), Math.max(1, textureSize.height), 0, 6402, 5126, null);
        gl.glBindTexture(34037, 0);
        return tex[0];
    }

    @Override
    public void deleteTexture(int texture) {
        GL2 gl = this._context.getGL().getGL2();
        gl.glDeleteTextures(1, new int[]{texture}, 0);
    }

    @Override
    public void fillRectCR(IVideoBuffer resultBuffer, final double[] mvMatrix, final double[] prjMatrix, final Size2i size, final Color color) {
        final int resultTexture = resultBuffer.getTexture();
        final VideoBounds resultBounds = resultBuffer.getBounds();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                final GL2 gl = VideoRenderSupportImplOld.this._context.getGL().getGL2();
                gl.glViewport(0, 0, resultBounds.width, resultBounds.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(prjMatrix, 0);
                gl.glMatrixMode(5888);
                gl.glLoadMatrixd(mvMatrix, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                Color clampedColor = color.clamp();
                float a = (float)clampedColor.a;
                float r = (float)clampedColor.r * a;
                float g = (float)clampedColor.g * a;
                float b = (float)clampedColor.b * a;
                gl.glColor4f(r, g, b, a);
                VideoRenderSupportImplOld.this._aaSupport.antiAlias(resultBounds.width, resultBounds.height, new Runnable(){

                    public void run() {
                        gl.glBegin(7);
                        gl.glVertex2i(0, 0);
                        gl.glVertex2i(size.width, 0);
                        gl.glVertex2i(size.width, size.height);
                        gl.glVertex2i(0, size.height);
                        gl.glEnd();
                    }
                });
                gl.glColor4fv(savedColor, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    private void ortho2D(GL2 gl, GLU glu, int width, int height) {
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluOrtho2D(0.0f, (float)width, 0.0f, (float)height);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    @Override
    public void trackMatte(IVideoBuffer matteBuffer, IVideoBuffer fillBuffer, IVideoBuffer resultBuffer, final TrackMatte trackMatte, final double matteOpacity) {
        if (trackMatte == TrackMatte.NONE) {
            throw new IllegalArgumentException();
        }
        final int matteTexture = matteBuffer.getTexture();
        final int fillTexture = fillBuffer.getTexture();
        final int resultTexture = resultBuffer.getTexture();
        final VideoBounds bounds = resultBuffer.getBounds();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                final GL2 gl = VideoRenderSupportImplOld.this._context.getGL().getGL2();
                VideoRenderSupportImplOld.this.ortho2D(gl, VideoRenderSupportImplOld.this._context.getGLU(), bounds.width, bounds.height);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, fillTexture);
                gl.glActiveTexture(33985);
                gl.glBindTexture(34037, matteTexture);
                final IShaderProgram program = VideoRenderSupportImplOld.this._shaders.getProgram(TrackMatteShaders.class, trackMatte.name());
                program.useProgram(new Runnable(){

                    public void run() {
                        gl.glUniform1i(program.getUniformLocation("texFill"), 0);
                        gl.glUniform1i(program.getUniformLocation("texMatte"), 1);
                        gl.glUniform1f(program.getUniformLocation("matteOpacity"), (float)matteOpacity);
                        gl.glBegin(7);
                        gl.glTexCoord2f(0.0f, 0.0f);
                        gl.glVertex2f(0.0f, 0.0f);
                        gl.glTexCoord2f((float)bounds.width, 0.0f);
                        gl.glVertex2f((float)bounds.width, 0.0f);
                        gl.glTexCoord2f((float)bounds.width, (float)bounds.height);
                        gl.glVertex2f((float)bounds.width, (float)bounds.height);
                        gl.glTexCoord2f(0.0f, (float)bounds.height);
                        gl.glVertex2f(0.0f, (float)bounds.height);
                        gl.glEnd();
                    }
                });
                gl.glActiveTexture(33985);
                gl.glBindTexture(34037, 0);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void blend(IVideoBuffer srcBuffer, IVideoBuffer dstBuffer, IVideoBuffer resultBuffer, final BlendMode blendMode, final double opacity, final int dissolveSeed) {
        final int srcTexture = srcBuffer.getTexture();
        final int dstTexture = dstBuffer.getTexture();
        final int resultTexture = resultBuffer.getTexture();
        final VideoBounds bounds = resultBuffer.getBounds();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                final GL2 gl = VideoRenderSupportImplOld.this._context.getGL().getGL2();
                VideoRenderSupportImplOld.this.ortho2D(gl, VideoRenderSupportImplOld.this._context.getGLU(), bounds.width, bounds.height);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, dstTexture);
                gl.glActiveTexture(33985);
                gl.glBindTexture(34037, srcTexture);
                final IShaderProgram program = VideoRenderSupportImplOld.this._shaders.getProgram(BlendModeShaders.class, blendMode.name());
                program.useProgram(new Runnable(){

                    public void run() {
                        gl.glUniform1i(program.getUniformLocation("texDst"), 0);
                        gl.glUniform1i(program.getUniformLocation("texSrc"), 1);
                        gl.glUniform1f(program.getUniformLocation("opacity"), (float)opacity);
                        switch (blendMode) {
                            case DISSOLVE: {
                                gl.glUniform1f(program.getUniformLocation("dissolveSeed"), 100.0f * (float)dissolveSeed / 2.1474836E9f);
                                break;
                            }
                            case DANCING_DISSOLVE: {
                                gl.glUniform1f(program.getUniformLocation("dissolveSeed"), 100.0f * (float)dissolveSeed / 2.1474836E9f + (float)VideoRenderSupportImplOld.this._context.getTime().toSecond());
                            }
                        }
                        gl.glBegin(7);
                        gl.glTexCoord2f(0.0f, 0.0f);
                        gl.glVertex2f(0.0f, 0.0f);
                        gl.glTexCoord2f((float)bounds.width, 0.0f);
                        gl.glVertex2f((float)bounds.width, 0.0f);
                        gl.glTexCoord2f((float)bounds.width, (float)bounds.height);
                        gl.glVertex2f((float)bounds.width, (float)bounds.height);
                        gl.glTexCoord2f(0.0f, (float)bounds.height);
                        gl.glVertex2f(0.0f, (float)bounds.height);
                        gl.glEnd();
                    }
                });
                gl.glActiveTexture(33985);
                gl.glBindTexture(34037, 0);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void blend(final Collection<VideoLayerBuffer> srcBuffers, final IVideoBuffer dstBuffer, IVideoBuffer resultBuffer) {
        final int resultTexture = resultBuffer.getTexture();
        final VideoBounds bounds = resultBuffer.getBounds();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                final GL2 gl = VideoRenderSupportImplOld.this._context.getGL().getGL2();
                VideoRenderSupportImplOld.this.ortho2D(gl, VideoRenderSupportImplOld.this._context.getGLU(), bounds.width, bounds.height);
                final int maxLayers = BlendModeShaders.getMaxIntersectingLayers();
                if (srcBuffers.size() > maxLayers) {
                    _logger.warn(String.format("number of layers in a inersection group exceeds limit: limit=%d, layers=%d", maxLayers, srcBuffers.size()));
                }
                final int nLayers = Math.min(srcBuffers.size(), maxLayers);
                final int[] blendMode = new int[nLayers];
                final float[] opacity = new float[maxLayers];
                final float[] dissolveSeed = new float[maxLayers];
                float time = (float)VideoRenderSupportImplOld.this._context.getTime().toSecond();
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, dstBuffer.getTexture());
                int i = 0;
                for (VideoLayerBuffer vlb : srcBuffers) {
                    gl.glActiveTexture(33984 + i + 1);
                    gl.glBindTexture(34037, vlb.getVideoBuffer().getTexture());
                    gl.glActiveTexture(33984 + i + 1 + maxLayers);
                    gl.glBindTexture(34037, vlb.getDepthBuffer().getTexture());
                    blendMode[i] = vlb.getBlendMode().ordinal();
                    opacity[i] = (float)vlb.getOpacity();
                    switch (vlb.getBlendMode()) {
                        case DISSOLVE: {
                            dissolveSeed[i] = 100.0f * (float)vlb.getDissolveSeed() / 2.1474836E9f;
                            break;
                        }
                        case DANCING_DISSOLVE: {
                            dissolveSeed[i] = 100.0f * (float)vlb.getDissolveSeed() / 2.1474836E9f + time;
                        }
                    }
                    if (++i >= nLayers) break;
                }
                final IShaderProgram program = VideoRenderSupportImplOld.this._shaders.getProgram(BlendModeShaders.getIntersectingBlendSourceFactory(blendMode));
                program.useProgram(new Runnable(){

                    public void run() {
                        gl.glUniform1i(program.getUniformLocation("nLayers"), nLayers);
                        gl.glUniform1i(program.getUniformLocation("texDst"), 0);
                        int i = 0;
                        while (i < maxLayers) {
                            gl.glUniform1i(program.getUniformLocation("texSrc" + i), i + 1);
                            gl.glUniform1i(program.getUniformLocation("texDep" + i), i + 1 + maxLayers);
                            ++i;
                        }
                        i = 0;
                        while (i < nLayers) {
                            gl.glUniform1i(program.getUniformLocation("blendMode" + i), blendMode[i]);
                            ++i;
                        }
                        gl.glUniform1fv(program.getUniformLocation("opacity[0]"), maxLayers, opacity, 0);
                        gl.glUniform1fv(program.getUniformLocation("dissolveSeed[0]"), maxLayers, dissolveSeed, 0);
                        gl.glBegin(7);
                        gl.glTexCoord2f(0.0f, 0.0f);
                        gl.glVertex2f(0.0f, 0.0f);
                        gl.glTexCoord2f((float)bounds.width, 0.0f);
                        gl.glVertex2f((float)bounds.width, 0.0f);
                        gl.glTexCoord2f((float)bounds.width, (float)bounds.height);
                        gl.glVertex2f((float)bounds.width, (float)bounds.height);
                        gl.glTexCoord2f(0.0f, (float)bounds.height);
                        gl.glVertex2f(0.0f, (float)bounds.height);
                        gl.glEnd();
                    }
                });
                int j = 0;
                int n = maxLayers * 2 + 1;
                while (j < n) {
                    gl.glActiveTexture(33984 + j);
                    gl.glBindTexture(34037, 0);
                    ++j;
                }
                gl.glActiveTexture(33984);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void premultiply(IVideoBuffer vb) {
        this.premultiply(vb, Color.BLACK, false);
    }

    @Override
    public void premultiply(final IVideoBuffer vb, final Color colorMatte, final boolean discardAlpha) {
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImplOld.this._context.getGL().getGL2();
                GLU glu = VideoRenderSupportImplOld.this._context.getGLU();
                VideoBounds bounds = vb.getBounds();
                VideoRenderSupportImplOld.this.ortho2D(gl, glu, bounds.width, bounds.height);
                gl.glFramebufferTexture2D(36160, 36064, 34037, vb.getTexture(), 0);
                gl.glDrawBuffer(36064);
                gl.glEnable(3042);
                if (discardAlpha) {
                    gl.glBlendFuncSeparate(773, 772, 1, 0);
                } else {
                    gl.glBlendFuncSeparate(773, 772, 0, 1);
                }
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                gl.glColor4f((float)colorMatte.r, (float)colorMatte.g, (float)colorMatte.b, 1.0f);
                gl.glBegin(7);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glVertex2f((float)bounds.width, 0.0f);
                gl.glVertex2f((float)bounds.width, (float)bounds.height);
                gl.glVertex2f(0.0f, (float)bounds.height);
                gl.glEnd();
                gl.glColor4fv(savedColor, 0);
                gl.glDisable(3042);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void alphaToGrayscale(final IVideoBuffer vb) {
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImplOld.this._context.getGL().getGL2();
                GLU glu = VideoRenderSupportImplOld.this._context.getGLU();
                VideoBounds bounds = vb.getBounds();
                VideoRenderSupportImplOld.this.ortho2D(gl, glu, bounds.width, bounds.height);
                gl.glFramebufferTexture2D(36160, 36064, 34037, vb.getTexture(), 0);
                gl.glDrawBuffer(36064);
                gl.glEnable(3042);
                gl.glBlendFuncSeparate(772, 0, 1, 0);
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                gl.glBegin(7);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glVertex2f((float)bounds.width, 0.0f);
                gl.glVertex2f((float)bounds.width, (float)bounds.height);
                gl.glVertex2f(0.0f, (float)bounds.height);
                gl.glEnd();
                gl.glColor4fv(savedColor, 0);
                gl.glDisable(3042);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void copy(IVideoBuffer src, IVideoBuffer dst) {
        final int srcTexture = src.getTexture();
        final VideoBounds srcBounds = src.getBounds();
        final int dstTexture = dst.getTexture();
        final VideoBounds dstBounds = dst.getBounds();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImplOld.this._context.getGL().getGL2();
                VideoRenderSupportImplOld.this.ortho2D(gl, VideoRenderSupportImplOld.this._context.getGLU(), dstBounds.width, dstBounds.height);
                gl.glTranslatef((float)(-dstBounds.x), (float)(-dstBounds.y), 0.0f);
                gl.glFramebufferTexture2D(36160, 36064, 34037, dstTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, srcTexture);
                gl.glEnable(34037);
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                gl.glBegin(7);
                gl.glTexCoord2f(0.0f, 0.0f);
                gl.glVertex2f((float)srcBounds.x, (float)srcBounds.y);
                gl.glTexCoord2f((float)srcBounds.width, 0.0f);
                gl.glVertex2f((float)(srcBounds.x + (double)srcBounds.width), (float)srcBounds.y);
                gl.glTexCoord2f((float)srcBounds.width, (float)srcBounds.height);
                gl.glVertex2f((float)(srcBounds.x + (double)srcBounds.width), (float)(srcBounds.y + (double)srcBounds.height));
                gl.glTexCoord2f(0.0f, (float)srcBounds.height);
                gl.glVertex2f((float)srcBounds.x, (float)(srcBounds.y + (double)srcBounds.height));
                gl.glEnd();
                gl.glColor4fv(savedColor, 0);
                gl.glBindTexture(34037, 0);
                gl.glDisable(34037);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public <T> T pushMatrixAndExecute(WrappedOperation<T> operation) {
        return operation.execute();
    }

    @Override
    public void multModelViewMatrix(Vec3d anchorPoint, Vec3d scale, Vec3d orientation, Vec3d rotate, Vec3d position) {
        GL2 gl = this._context.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glTranslatef((float)position.x, (float)position.y, (float)position.z);
        gl.glRotatef((float)orientation.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)orientation.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)orientation.z, 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)rotate.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)rotate.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)rotate.z, 0.0f, 0.0f, 1.0f);
        gl.glScalef((float)(scale.x / 100.0), (float)(scale.y / 100.0), (float)(scale.z / 100.0));
        gl.glTranslatef((float)(-anchorPoint.x), (float)(-anchorPoint.y), (float)(-anchorPoint.z));
    }

    @Override
    public void multModelViewMatrixInverse(Vec3d anchorPoint, Vec3d scale, Vec3d orientation, Vec3d rotate, Vec3d position) {
        GL2 gl = this._context.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glTranslatef((float)anchorPoint.x, (float)anchorPoint.y, (float)anchorPoint.z);
        gl.glScalef((float)(100.0 / scale.x), (float)(100.0 / scale.y), (float)(100.0 / scale.z));
        gl.glRotatef((float)(-rotate.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-rotate.y), 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)(-rotate.x), 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)(-orientation.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-orientation.y), 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)(-orientation.x), 1.0f, 0.0f, 0.0f);
        gl.glTranslatef((float)(-position.x), (float)(-position.y), (float)(-position.z));
    }

    @Override
    public void multCameraMatrix(Vec3d orientation, Vec3d rotate, Vec3d position, Vec3d pointOfInterest, boolean flipZ) {
        double dx = pointOfInterest.x - position.x;
        double dy = pointOfInterest.y - position.y;
        double dz = pointOfInterest.z - position.z;
        float _1 = flipZ ? -1 : 1;
        GL2 gl = this._context.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glRotatef((float)(-rotate.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-rotate.y), 0.0f, _1, 0.0f);
        gl.glRotatef((float)(-rotate.x), _1, 0.0f, 0.0f);
        gl.glRotatef((float)(-orientation.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-orientation.y), 0.0f, _1, 0.0f);
        gl.glRotatef((float)(-orientation.x), _1, 0.0f, 0.0f);
        gl.glRotatef((float)Math.toDegrees(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz))), _1, 0.0f, 0.0f);
        gl.glRotatef((float)Math.toDegrees(-Math.atan2(dx, dz)), 0.0f, _1, 0.0f);
        gl.glTranslatef((float)(-position.x), (float)(-position.y), (float)(-position.z) * _1);
        if (flipZ) {
            gl.glScalef(1.0f, 1.0f, -1.0f);
        }
    }

    @Override
    public void multCameraMatrixInverse(Vec3d orientation, Vec3d rotate, Vec3d position, Vec3d pointOfInterest) {
        double dx = pointOfInterest.x - position.x;
        double dy = pointOfInterest.y - position.y;
        double dz = pointOfInterest.z - position.z;
        GL2 gl = this._context.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glTranslatef((float)position.x, (float)position.y, (float)position.z);
        gl.glRotatef((float)Math.toDegrees(Math.atan2(dx, dz)), 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)Math.toDegrees(-Math.atan2(dy, Math.sqrt(dx * dx + dz * dz))), 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)orientation.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)orientation.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)orientation.z, 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)rotate.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)rotate.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)rotate.z, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void multModelViewMatrix(double[] mvMatrix) {
        GL2 gl = this._context.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glMultMatrixd(mvMatrix, 0);
    }

    @Override
    public void getMatrix(double[] mvMatrix, double[] prjMatrix) {
        GL2 gl = this._context.getGL().getGL2();
        if (mvMatrix != null) {
            gl.glGetDoublev(2982, mvMatrix, 0);
        }
        if (prjMatrix != null) {
            gl.glGetDoublev(2983, prjMatrix, 0);
        }
    }

    @Override
    public void setMatrix(double[] mvMatrix, double[] prjMatrix) {
        GL2 gl = this._context.getGL().getGL2();
        if (prjMatrix != null) {
            gl.glMatrixMode(5889);
            gl.glLoadMatrixd(prjMatrix, 0);
        }
        if (mvMatrix != null) {
            gl.glMatrixMode(5888);
            gl.glLoadMatrixd(mvMatrix, 0);
        }
    }

    @Override
    public void resetMatrix() {
        GL2 gl = this._context.getGL().getGL2();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    @Override
    public Vec3d project(Vec3d point, double[] mvMatrix, double[] prjMatrix, Size2i viewportSize) {
        int[] nArray = new int[4];
        nArray[2] = viewportSize.width;
        nArray[3] = viewportSize.height;
        int[] viewport = nArray;
        double[] result = new double[3];
        this._context.getGLU().gluProject(point.x, point.y, point.z, mvMatrix, 0, prjMatrix, 0, viewport, 0, result, 0);
        return new Vec3d(result[0], result[1], result[2]);
    }

    @Override
    public void transform(IVideoBuffer srcBuffer, IVideoBuffer resultBuffer, DepthBuffer depthBuffer, final double[] mvMatrix, final double[] prjMatrix) {
        final int srcTexture = srcBuffer.getTexture();
        final VideoBounds srcBounds = srcBuffer.getBounds();
        final int resultTexture = resultBuffer.getTexture();
        final VideoBounds resultBounds = resultBuffer.getBounds();
        final int depthTexture = depthBuffer != null ? depthBuffer.getTexture() : 0;
        IVideoBuffer.TextureFilter currFilter = srcBuffer.getTextureFilter();
        try {
            srcBuffer.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
            this.pushMatrixAndExecute(new WrappedOperation<Object>(){

                @Override
                public Object execute() {
                    GL2 gl = VideoRenderSupportImplOld.this._context.getGL().getGL2();
                    gl.glViewport(0, 0, resultBounds.width, resultBounds.height);
                    gl.glMatrixMode(5889);
                    gl.glLoadMatrixd(prjMatrix, 0);
                    gl.glMatrixMode(5888);
                    gl.glLoadMatrixd(mvMatrix, 0);
                    gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                    gl.glDrawBuffer(36064);
                    gl.glActiveTexture(33984);
                    gl.glBindTexture(34037, srcTexture);
                    gl.glEnable(34037);
                    if (depthTexture != 0) {
                        gl.glFramebufferTexture2D(36160, 36096, 34037, depthTexture, 0);
                        gl.glEnable(2929);
                        gl.glClearDepth(1.0);
                        gl.glClear(256);
                    }
                    float[] savedColor = new float[4];
                    gl.glGetFloatv(2816, savedColor, 0);
                    gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                    gl.glBegin(7);
                    gl.glTexCoord2f(0.0f, 0.0f);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glTexCoord2f((float)srcBounds.width, 0.0f);
                    gl.glVertex2f((float)srcBounds.width, 0.0f);
                    gl.glTexCoord2f((float)srcBounds.width, (float)srcBounds.height);
                    gl.glVertex2f((float)srcBounds.width, (float)srcBounds.height);
                    gl.glTexCoord2f(0.0f, (float)srcBounds.height);
                    gl.glVertex2f(0.0f, (float)srcBounds.height);
                    gl.glEnd();
                    gl.glColor4fv(savedColor, 0);
                    if (depthTexture != 0) {
                        gl.glDisable(2929);
                        gl.glFramebufferTexture2D(36160, 36096, 34037, 0, 0);
                    }
                    gl.glBindTexture(34037, 0);
                    gl.glDisable(34037);
                    gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                    return null;
                }
            });
        }
        finally {
            srcBuffer.setTextureFilter(currFilter);
        }
    }

    @Override
    public void accumulate(final List<IVideoBuffer> srcBuffers, List<Double> weights, IVideoBuffer dstBuffer) {
        int maxUnits;
        final int nUnits = srcBuffers.size();
        if (nUnits > (maxUnits = this._glGlobal.getMaxTextureImageUnits())) {
            throw new IllegalArgumentException();
        }
        final float[] weightsArray = new float[nUnits];
        int i = 0;
        while (i < nUnits) {
            weightsArray[i] = weights.get(i).floatValue();
            ++i;
        }
        final int dstTexture = dstBuffer.getTexture();
        final VideoBounds bounds = dstBuffer.getBounds();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                final GL2 gl = VideoRenderSupportImplOld.this._context.getGL().getGL2();
                VideoRenderSupportImplOld.this.ortho2D(gl, VideoRenderSupportImplOld.this._context.getGLU(), bounds.width, bounds.height);
                gl.glFramebufferTexture2D(36160, 36064, 34037, dstTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glPushAttrib(286720);
                gl.glEnable(3042);
                gl.glBlendFunc(1, 1);
                gl.glBlendEquation(32774);
                int i = 0;
                while (i < maxUnits) {
                    gl.glActiveTexture(33984 + i);
                    gl.glBindTexture(34037, i < nUnits ? ((IVideoBuffer)srcBuffers.get(i)).getTexture() : 0);
                    ++i;
                }
                final IShaderProgram program = VideoRenderSupportImplOld.this._shaders.getProgram(AccumulationShaders.class, "accumulation");
                program.useProgram(new Runnable(){

                    public void run() {
                        gl.glUniform1fv(program.getUniformLocation("weights[0]"), nUnits, weightsArray, 0);
                        gl.glUniform1i(program.getUniformLocation("nUnits"), nUnits);
                        int i = 0;
                        while (i < maxUnits) {
                            gl.glUniform1i(program.getUniformLocation("texSrc" + i), i);
                            ++i;
                        }
                        gl.glBegin(7);
                        gl.glTexCoord2f(0.0f, 0.0f);
                        gl.glVertex2f(0.0f, 0.0f);
                        gl.glTexCoord2f((float)bounds.width, 0.0f);
                        gl.glVertex2f((float)bounds.width, 0.0f);
                        gl.glTexCoord2f((float)bounds.width, (float)bounds.height);
                        gl.glVertex2f((float)bounds.width, (float)bounds.height);
                        gl.glTexCoord2f(0.0f, (float)bounds.height);
                        gl.glVertex2f(0.0f, (float)bounds.height);
                        gl.glEnd();
                    }
                });
                gl.glPopAttrib();
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void accumulate(List<IVideoBuffer> srcBuffers, double weight, IVideoBuffer dstBuffer) {
        this.accumulate(srcBuffers, Collections.nCopies(srcBuffers.size(), weight), dstBuffer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void fillDepth(DepthBuffer depthBuffer, final double[] mvMatrix, final double[] prjMatrix) {
        Size2i size = depthBuffer.getImageSize();
        final int w = size.width;
        final int h = size.height;
        int[] nArray = new int[4];
        nArray[2] = w;
        nArray[3] = h;
        int[] viewport = nArray;
        double[][] unprj = new double[8][3];
        GLU glu = this._context.getGLU();
        glu.gluUnProject(0.0, 0.0, 0.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[0], 0);
        glu.gluUnProject(0.0, 0.0, 1.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[1], 0);
        glu.gluUnProject((double)w, 0.0, 0.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[2], 0);
        glu.gluUnProject((double)w, 0.0, 1.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[3], 0);
        glu.gluUnProject((double)w, (double)h, 0.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[4], 0);
        glu.gluUnProject((double)w, (double)h, 1.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[5], 0);
        glu.gluUnProject(0.0, (double)h, 0.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[6], 0);
        glu.gluUnProject(0.0, (double)h, 1.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[7], 0);
        Point3d[] frustumVertices = new Point3d[8];
        int i = 0;
        while (i < 8) {
            frustumVertices[i] = new Point3d(unprj[i]);
            ++i;
        }
        Point3d[][] frustumEdges = new Point3d[12][2];
        int i2 = 0;
        while (i2 < 12) {
            frustumEdges[i2][0] = frustumVertices[_frustumEdgeTable[i2][0]];
            frustumEdges[i2][1] = frustumVertices[_frustumEdgeTable[i2][1]];
            ++i2;
        }
        final LinkedHashSet<Point2d> set = Util.newLinkedHashSet();
        Vector3d v = new Vector3d();
        int i3 = 0;
        while (i3 < 12) {
            boolean y;
            Point3d p0 = frustumEdges[i3][0];
            Point3d p1 = frustumEdges[i3][1];
            v.sub((Tuple3d)p1, (Tuple3d)p0);
            Point2d p = new Point2d(p0.x - v.x / v.z * p0.z, p0.y - v.y / v.z * p0.z);
            boolean x = p0.x <= p.x && p.x <= p1.x || p1.x <= p.x && p.x <= p0.x;
            boolean bl = y = p0.y <= p.y && p.y <= p1.y || p1.y <= p.y && p.y <= p0.y;
            if (!x || !y) {
                ++i3;
                continue;
            }
            set.add(p);
            block6: while (true) {
                int j = 0;
                while (j < 6) {
                    int k = _frustumClipSearchTable[i3][j];
                    p0 = frustumEdges[k][0];
                    p1 = frustumEdges[k][1];
                    v.sub((Tuple3d)p1, (Tuple3d)p0);
                    p = new Point2d(p0.x - v.x / v.z * p0.z, p0.y - v.y / v.z * p0.z);
                    x = p0.x <= p.x && p.x <= p1.x || p1.x <= p.x && p.x <= p0.x;
                    boolean bl2 = y = p0.y <= p.y && p.y <= p1.y || p1.y <= p.y && p.y <= p0.y;
                    if (x && y && !set.contains(p)) {
                        set.add(p);
                        i3 = k;
                        continue block6;
                    }
                    ++j;
                }
                break block5;
                break;
            }
        }
        IVideoBuffer tmpBuffer = this.createVideoBuffer(ColorMode.RGBA8, size);
        try {
            final int tmpTexture = tmpBuffer.getTexture();
            final int depthTexture = depthBuffer.getTexture();
            this.pushMatrixAndExecute(new WrappedOperation<Object>(){

                @Override
                public Object execute() {
                    GL2 gl = VideoRenderSupportImplOld.this._context.getGL().getGL2();
                    gl.glViewport(0, 0, w, h);
                    gl.glMatrixMode(5889);
                    gl.glLoadMatrixd(prjMatrix, 0);
                    gl.glMatrixMode(5888);
                    gl.glLoadMatrixd(mvMatrix, 0);
                    gl.glFramebufferTexture2D(36160, 36064, 34037, tmpTexture, 0);
                    gl.glDrawBuffer(36064);
                    gl.glFramebufferTexture2D(36160, 36096, 34037, depthTexture, 0);
                    gl.glEnable(2929);
                    gl.glClearDepth(1.0);
                    gl.glClear(256);
                    if (set.size() >= 3) {
                        gl.glBegin(9);
                        for (Point2d pt : set) {
                            gl.glVertex2d(pt.x, pt.y);
                        }
                        gl.glEnd();
                    }
                    gl.glDisable(2929);
                    gl.glFramebufferTexture2D(36160, 36096, 34037, 0, 0);
                    gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                    return null;
                }
            });
            return;
        }
        finally {
            tmpBuffer.dispose();
        }
    }

    @Override
    public void renderText(final FTGLfont font, final Color fillColor, final String[] texts, final double[][] offsets, IVideoBuffer resultBuffer) {
        final VideoBounds resultBounds = resultBuffer.getBounds();
        if (resultBounds.isEmpty()) {
            return;
        }
        final int resultTexture = resultBuffer.getTexture();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImplOld.this._context.getGL().getGL2();
                GLU glu = VideoRenderSupportImplOld.this._context.getGLU();
                float scale = (float)((VideoRenderSupportImplOld)VideoRenderSupportImplOld.this)._context.getVideoResolution().scale;
                VideoRenderSupportImplOld.this.ortho2D(gl, glu, resultBounds.width, resultBounds.height);
                gl.glTranslatef((float)(-resultBounds.x), (float)(-resultBounds.y), 0.0f);
                double[] mvMatrix = new double[16];
                VideoRenderSupportImplOld.this.getMatrix(mvMatrix, null);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                Color clampedColor = fillColor.clamp();
                gl.glColor4f((float)clampedColor.r, (float)clampedColor.g, (float)clampedColor.b, (float)clampedColor.a);
                gl.glEnable(3042);
                gl.glBlendFuncSeparate(770, 771, 1, 771);
                int i = 0;
                while (i < texts.length) {
                    VideoRenderSupportImplOld.this.setMatrix(mvMatrix, null);
                    gl.glTranslatef((float)offsets[i][0], (float)offsets[i][1], 0.0f);
                    gl.glScalef(scale, -scale, scale);
                    FTGL.ftglRenderFont((FTGLfont)font, (String)texts[i], (int)65535);
                    ++i;
                }
                gl.glDisable(3042);
                gl.glColor4fv(savedColor, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void renderText(final FTGLfont font, final Color fillColor, final String[] texts, final double[][] offsets, IVideoBuffer resultBuffer, final double[] mvMatrix, final double[] prjMatrix) {
        final int resultTexture = resultBuffer.getTexture();
        final VideoBounds resultBounds = resultBuffer.getBounds();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                final GL2 gl = VideoRenderSupportImplOld.this._context.getGL().getGL2();
                final float scale = (float)((VideoRenderSupportImplOld)VideoRenderSupportImplOld.this)._context.getVideoResolution().scale;
                gl.glViewport(0, 0, resultBounds.width, resultBounds.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(prjMatrix, 0);
                gl.glMatrixMode(5888);
                gl.glLoadMatrixd(mvMatrix, 0);
                final double[] mvMatrix2 = new double[16];
                VideoRenderSupportImplOld.this.getMatrix(mvMatrix2, null);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                Color clampedColor = fillColor.clamp();
                float a = (float)clampedColor.a;
                float r = (float)clampedColor.r * a;
                float g = (float)clampedColor.g * a;
                float b = (float)clampedColor.b * a;
                gl.glColor4f(r, g, b, a);
                VideoRenderSupportImplOld.this._aaSupport.antiAlias(resultBounds.width, resultBounds.height, new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < texts.length) {
                            VideoRenderSupportImplOld.this.setMatrix(mvMatrix2, null);
                            gl.glTranslatef((float)offsets[i][0], (float)offsets[i][1], 0.0f);
                            gl.glScalef(scale, -scale, scale);
                            FTGL.ftglRenderFont((FTGLfont)font, (String)texts[i], (int)65535);
                            ++i;
                        }
                    }
                });
                gl.glColor4fv(savedColor, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }
}

