/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.output;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.misc.AtiIntelLock;
import ch.kuramo.javie.core.output.Output;
import ch.kuramo.javie.core.output.ProgressMonitor;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.util.Arrays;

public abstract class PushSourceOutput
extends Output {
    @Inject
    private RenderContext _context;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private AudioRenderSupport _arSupport;
    @Inject
    private GLGlobal _glGlobal;

    public void doOutput(ProgressMonitor progMon) {
        ProgressMonitor monitor;
        boolean videoEnabled = this.isVideoEnabled();
        boolean audioEnabled = this.isAudioEnabled();
        if (!videoEnabled && !audioEnabled) {
            throw new IllegalStateException("neither video nor audio is enabled.");
        }
        this.initialize();
        ProgressMonitor progressMonitor = monitor = progMon != null ? progMon : ProgressMonitor.NULL;
        if (videoEnabled) {
            Thread audioThread = null;
            if (audioEnabled) {
                final ProgressMonitor audioMon = new ProgressMonitor(){

                    public void beginTask(int totalWork) {
                    }

                    public void currentWork(int currentWork) {
                    }

                    public void done() {
                    }

                    public boolean isCanceled() {
                        return monitor.isCanceled();
                    }
                };
                audioThread = new Thread(){

                    public void run() {
                        PushSourceOutput.this.audioLoop(audioMon);
                    }
                };
                audioThread.start();
            }
            try {
                this.videoLoop(monitor);
            }
            catch (Throwable throwable) {
                if (audioThread != null) {
                    try {
                        audioThread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.finish();
                throw throwable;
            }
            if (audioThread != null) {
                try {
                    audioThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.finish();
        } else {
            try {
                this.audioLoop(monitor);
            }
            finally {
                this.finish();
            }
        }
    }

    protected abstract void initialize();

    protected abstract void finish();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void videoLoop(ProgressMonitor monitor) {
        AtiIntelLock atiIntelLock = AtiIntelLock.get(this._glGlobal);
        Composition comp = this.getComposition();
        AudioMode audioMode = this.getAudioMode();
        Time frameDuration = comp.getFrameDuration();
        long numFrames = comp.getDuration().toFrameNumber(frameDuration);
        monitor.beginTask((int)numFrames);
        this._context.activate();
        try {
            comp.prepareExpression(this._context.createInitialExpressionScope(comp));
            long i = 0L;
            while (i < numFrames && !monitor.isCanceled()) {
                Time time = Time.fromFrameNumber((long)i, (Time)frameDuration);
                this._context.reset();
                this._context.setVideoResolution(Resolution.FULL);
                this._context.setVideoFrameDuration(comp.getFrameDuration());
                this._context.setAudioMode(audioMode);
                this._context.setAudioAnimationRate(audioMode.sampleRate / 100);
                this._context.setTime(time);
                IVideoBuffer vb = null;
                try {
                    atiIntelLock.lock();
                    try {
                        vb = comp.renderVideoFrame();
                        switch (this.getVideoChannels()) {
                            case RGB: {
                                this._vrSupport.premultiply(vb, Color.BLACK, true);
                                break;
                            }
                            case ALPHA: {
                                this._vrSupport.alphaToGrayscale(vb);
                                break;
                            }
                            case RGBA_STRAIGHT: {
                                break;
                            }
                            case RGBA_PREMULTIPLIED: {
                                this._vrSupport.premultiply(vb, this.getColorMatte(), false);
                                break;
                            }
                        }
                        this.writeVideo(i, time, vb);
                    }
                    finally {
                        atiIntelLock.unlock();
                    }
                }
                finally {
                    if (vb != null) {
                        vb.dispose();
                    }
                }
                monitor.currentWork((int)i);
                ++i;
            }
        }
        finally {
            this._context.deactivate();
        }
        monitor.done();
    }

    protected abstract void writeVideo(long var1, Time var3, IVideoBuffer var4);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void audioLoop(ProgressMonitor monitor) {
        Composition comp = this.getComposition();
        AudioMode audioMode = this.getAudioMode();
        long totalFrames = comp.getDuration().toFrameNumber(audioMode.sampleDuration);
        int chunkFrames = audioMode.sampleRate;
        monitor.beginTask((int)totalFrames);
        this._context.activate();
        try {
            comp.prepareExpression(this._context.createInitialExpressionScope(comp));
            long i = 0L;
            while (i < totalFrames && !monitor.isCanceled()) {
                Time time = Time.fromFrameNumber((long)i, (Time)audioMode.sampleDuration);
                this._context.reset();
                this._context.setAudioMode(audioMode);
                this._context.setAudioAnimationRate(audioMode.sampleRate / 100);
                this._context.setAudioFrameCount((int)Math.min((long)chunkFrames, totalFrames - i));
                this._context.setVideoResolution(Resolution.FULL);
                this._context.setVideoFrameDuration(comp.getFrameDuration());
                this._context.setTime(time);
                IAudioBuffer ab = comp.renderAudioChunk();
                try {
                    if (ab == null) {
                        ab = this.createAudioBufferClear();
                    }
                    this.writeAudio(i, time, ab);
                }
                finally {
                    ab.dispose();
                }
                monitor.currentWork((int)(i += (long)ab.getFrameCount()));
            }
        }
        finally {
            this._context.deactivate();
        }
        monitor.done();
    }

    protected abstract void writeAudio(long var1, Time var3, IAudioBuffer var4);

    private IAudioBuffer createAudioBufferClear() {
        IAudioBuffer ab = this._arSupport.createAudioBuffer();
        switch (ab.getAudioMode().dataType) {
            case SHORT: {
                Arrays.fill((short[])ab.getData(), 0, ab.getDataLength(), (short)0);
                break;
            }
            case INT: {
                Arrays.fill((int[])ab.getData(), 0, ab.getDataLength(), 0);
                break;
            }
            case FLOAT: {
                Arrays.fill((float[])ab.getData(), 0, ab.getDataLength(), 0.0f);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + ab.getAudioMode().dataType);
            }
        }
        return ab;
    }
}

