/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.shaders;

import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.GLGlobal;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;

public class AccumulationShaders {
    @ShaderSource
    public final String[] accumulation;

    private String[] createAccumulationSource(int maxUnits) {
        List<String> source = Util.newList();
        int i = 0;
        while (i < maxUnits) {
            source.add(String.format("uniform sampler2DRect texSrc%d;", i));
            ++i;
        }
        source.add("vec2 texCoord = gl_TexCoord[0].st;");
        source.add("vec4 getSrc(int i) {");
        source.add("\treturn");
        i = 0;
        while (i < maxUnits) {
            source.add(String.format("\t\t(i == %1$d) ? texture2DRect(texSrc%1$d, texCoord) :", i));
            ++i;
        }
        source.add("\t\tvec4(0.0);");
        source.add("}");
        source.addAll(Arrays.asList(String.format("uniform float weights[%d];", maxUnits), "uniform int nUnits;", "", "void main(void)", "{", "\tvec4 accum = vec4(0.0);", "\tfor (int i = 0; i < nUnits; ++i) {", "\t\taccum += weights[i]*getSrc(i);", "\t}", "\tgl_FragColor = accum;", "}"));
        return source.toArray(new String[source.size()]);
    }

    @Inject
    public AccumulationShaders(GLGlobal glGlobal) {
        this.accumulation = this.createAccumulationSource(glGlobal.getMaxTextureImageUnits());
    }
}

