/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.runtime;

import com.sun.gluegen.runtime.BufferFactory;
import com.sun.gluegen.runtime.CPU;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public class PointerBuffer {
    private ByteBuffer bb;
    private LongBuffer lb;
    private int capacity;
    private int position;
    private long[] backup;

    private PointerBuffer(ByteBuffer byteBuffer) {
        this.bb = byteBuffer;
        this.lb = byteBuffer.asLongBuffer();
        this.capacity = byteBuffer.capacity() / 8;
        this.position = 0;
        this.backup = new long[this.capacity];
    }

    public final int limit() {
        return this.capacity;
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int position() {
        return this.position;
    }

    public final int remaining() {
        return this.capacity - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.capacity;
    }

    public final void rewind() {
        this.position = 0;
    }

    int arrayOffset() {
        return 0;
    }

    boolean hasArray() {
        return true;
    }

    public long[] array() {
        return this.backup;
    }

    public static PointerBuffer allocate(int n) {
        return new PointerBuffer(ByteBuffer.wrap(new byte[8 * n]));
    }

    public static PointerBuffer allocateDirect(int n) {
        return new PointerBuffer(BufferFactory.newDirectByteBuffer(8 * n));
    }

    public static PointerBuffer wrap(ByteBuffer byteBuffer) {
        PointerBuffer pointerBuffer = new PointerBuffer(byteBuffer);
        pointerBuffer.updateBackup();
        return pointerBuffer;
    }

    public static PointerBuffer wrapNative2Java(ByteBuffer byteBuffer, boolean bl) {
        PointerBuffer pointerBuffer;
        if (CPU.is32Bit()) {
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            int n = intBuffer.capacity();
            pointerBuffer = byteBuffer.isDirect() && bl ? PointerBuffer.allocateDirect(n) : PointerBuffer.allocate(n);
            for (int i = 0; i < n; ++i) {
                pointerBuffer.put(i, intBuffer.get(i));
            }
        } else {
            pointerBuffer = new PointerBuffer(byteBuffer);
            pointerBuffer.updateBackup();
        }
        return pointerBuffer;
    }

    public ByteBuffer getBuffer() {
        return this.bb;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public long get(int n) {
        if (0 > n || n >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        return this.lb.get(n);
    }

    public long get() {
        long l = this.get(this.position + 1);
        ++this.position;
        return l;
    }

    public PointerBuffer put(int n, long l) {
        if (0 > n || n >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.backup[n] = l;
        this.lb.put(n, l);
        return this;
    }

    public PointerBuffer put(long l) {
        this.put(this.position + 1, l);
        ++this.position;
        return this;
    }

    private void updateBackup() {
        for (int i = 0; i < this.capacity; ++i) {
            this.backup[i] = this.get(i);
        }
    }
}

