/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.blurSharpen;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.ZoomBlur", category="ch.kuramo.javie.api.effectCategory.blurAndSharpen")
public class ZoomBlur {
    @Property(value="0", min="0", max="1000")
    private IAnimatableDouble amount;
    @Property
    private IAnimatableVec2d center;
    @Property(value="ZOOM_IN")
    private IAnimatableEnum<Direction> direction;
    @Property(value="20", min="0")
    private IAnimatableInteger maxSamples;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram zoomInProgram;
    private final IShaderProgram zoomOutProgram;
    private final IShaderProgram zoomBothProgram;
    @ShaderSource
    public static final String[] ZOOM_IN = ZoomBlur.createShaderSource(Direction.ZOOM_IN);
    @ShaderSource
    public static final String[] ZOOM_OUT = ZoomBlur.createShaderSource(Direction.ZOOM_OUT);
    @ShaderSource
    public static final String[] ZOOM_BOTH = ZoomBlur.createShaderSource(Direction.ZOOM_BOTH);

    @Inject
    public ZoomBlur(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.zoomInProgram = shaders.getProgram(ZoomBlur.class, "ZOOM_IN");
        this.zoomOutProgram = shaders.getProgram(ZoomBlur.class, "ZOOM_OUT");
        this.zoomBothProgram = shaders.getProgram(ZoomBlur.class, "ZOOM_BOTH");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        VideoBounds bounds = source.getBounds();
        if (bounds.isEmpty()) {
            return source;
        }
        Resolution resolution = this.context.getVideoResolution();
        double amount = resolution.scale(((Double)this.context.value((IAnimatableValue)this.amount)).doubleValue());
        int maxSamples = (Integer)this.context.value((IAnimatableValue)this.maxSamples);
        if (amount == 0.0 || maxSamples == 0) {
            return source;
        }
        Vec2d center = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.center));
        Direction direction = (Direction)((Object)this.context.value(this.direction));
        try {
            double amountScale;
            IShaderProgram program;
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            switch (direction) {
                case ZOOM_IN: {
                    program = this.zoomInProgram;
                    amountScale = resolution.scale(200.0);
                    uniforms.add(new GLUniformData("amountIn", (float)Math.min(amount, amountScale)));
                    break;
                }
                case ZOOM_OUT: {
                    program = this.zoomOutProgram;
                    amountScale = resolution.scale(200.0);
                    uniforms.add(new GLUniformData("amountOut", (float)amount));
                    break;
                }
                case ZOOM_BOTH: {
                    program = this.zoomBothProgram;
                    amountScale = resolution.scale(400.0);
                    uniforms.add(new GLUniformData("amountIn", (float)Math.min(amount, amountScale)));
                    uniforms.add(new GLUniformData("amountOut", (float)amount));
                    break;
                }
                default: {
                    throw new RuntimeException("unknown zoom direction: " + (Object)((Object)direction));
                }
            }
            uniforms.add(new GLUniformData("source", 0));
            uniforms.add(new GLUniformData("center", 2, this.toFloatBuffer(center.x - bounds.x, center.y - bounds.y)));
            uniforms.add(new GLUniformData("amountScale", (float)amountScale));
            uniforms.add(new GLUniformData("maxSamples", (float)maxSamples));
            source.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
            source.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE);
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(program, uniforms, null, new IVideoBuffer[]{source});
            return iVideoBuffer;
        }
        finally {
            source.dispose();
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] array = new float[values.length];
        int i = 0;
        while (i < values.length) {
            array[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(array);
    }

    private static String[] createShaderSource(Direction direction) {
        boolean in = direction != Direction.ZOOM_OUT;
        boolean out = direction != Direction.ZOOM_IN;
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("uniform sampler2DRect source;", "uniform float amountScale;", in ? "uniform float amountIn;" : "", out ? "uniform float amountOut;" : "", "uniform vec2 center;", "uniform float maxSamples;", "", "void main(void)", "{", "\tvec2 coord = gl_TexCoord[0].st;", "\tvec2 v = center - coord;", "\tfloat d = length(v);", "", "\tvec4 color = texture2DRect(source, coord);", "", "\tif (d > 0.0) {", "\t\tint n = 0;"));
        if (in) {
            list.addAll(Arrays.asList("\t\tfloat a1 = amountIn*d/amountScale;", "\t\tint   n1 = int(min(a1+1.0, maxSamples));", "\t\tvec2  v1 = v/d*a1/float(n1);", "\t\tfor (int i = 1; i <= n1; ++i) {", "\t\t\tcolor += texture2DRect(source, coord + v1*float(i));", "\t\t}", "\t\tn += n1;"));
        }
        if (out) {
            list.addAll(Arrays.asList("\t\tfloat a2 = amountOut*d/amountScale;", "\t\tint   n2 = int(min(a2+1.0, maxSamples));", "\t\tvec2  v2 = v/d*a2/float(n2);", "\t\tfor (int i = 1; i <= n2; ++i) {", "\t\t\tcolor += texture2DRect(source, coord - v2*float(i));", "\t\t}", "\t\tn += n2;"));
        }
        list.addAll(Arrays.asList("", "\t\tcolor /= float(n+1);", "\t}", "", "\tgl_FragColor = color;", "}"));
        return list.toArray(new String[list.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        ZOOM_IN,
        ZOOM_OUT,
        ZOOM_BOTH;

    }
}

