/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.colorCorrection;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.Monochrome", category="ch.kuramo.javie.api.effectCategory.colorCorrection")
public class Monochrome {
    @ShaderSource
    public static final String[] MONOCHROME = new String[]{"uniform sampler2DRect texture;", "uniform vec3 highlight;", "uniform vec3 shadow;", "uniform float blend;", "", "const vec3 yvec = vec3(0.299, 0.587, 0.114);", "", "void main(void)", "{", "\tvec4 src = texture2DRect(texture, gl_TexCoord[0].st);", "\tfloat y = (src.a != 0.0) ? dot(src.rgb/src.a, yvec) : 0.0;", "\tvec3 rgb = shadow*(1.0-y) + highlight*y;", "\tfloat a = src.a*(1.0-blend);", "\tgl_FragColor = src*blend + vec4(rgb*a, a);", "}"};
    @Property(value="1,1,1")
    private IAnimatableColor highlight;
    @Property(value="0,0,0")
    private IAnimatableColor shadow;
    @Property(min="0", max="100")
    private IAnimatableDouble blendWithOriginal;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram program;

    @Inject
    public Monochrome(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.program = shaders.getProgram(Monochrome.class, "MONOCHROME");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds bounds = input.getBounds();
        if (bounds.isEmpty()) {
            return input;
        }
        double blend = (Double)this.context.value((IAnimatableValue)this.blendWithOriginal);
        if (blend == 100.0) {
            return input;
        }
        Color highlight = ((Color)this.context.value((IAnimatableValue)this.highlight)).clamp();
        Color shadow = ((Color)this.context.value((IAnimatableValue)this.shadow)).clamp();
        try {
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("highlight", 3, FloatBuffer.wrap(this.colorToFloat3(highlight))));
            uniforms.add(new GLUniformData("shadow", 3, FloatBuffer.wrap(this.colorToFloat3(shadow))));
            uniforms.add(new GLUniformData("blend", (float)(blend / 100.0)));
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(this.program, uniforms, null, new IVideoBuffer[]{input});
            return iVideoBuffer;
        }
        finally {
            input.dispose();
        }
    }

    private float[] colorToFloat3(Color color) {
        return new float[]{(float)color.r, (float)color.g, (float)color.b};
    }
}

