/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.distort;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.PolarCoordinates", category="ch.kuramo.javie.api.effectCategory.distort")
public class PolarCoordinates {
    @ShaderSource
    public static final String[] RECT_TO_POLAR = new String[]{"uniform sampler2DRect texture;", "uniform vec2 center;", "uniform float radians_per_px;", "uniform float interp;", "", "void main(void)", "{", "\tfloat sRect = gl_TexCoord[0].s;", "\tfloat tRect = gl_TexCoord[0].t;", "", "\tfloat sPolar = atan(sRect-center.s, tRect-center.t) / radians_per_px + center.s;", "\tfloat tPolar = distance(gl_TexCoord[0].st, center) * 2.0;", "", "\tfloat s = interp*sPolar + (1.0-interp)*sRect;", "\tfloat t = interp*tPolar + (1.0-interp)*tRect;", "\tgl_FragColor = texture2DRect(texture, vec2(s, t));", "}"};
    @ShaderSource
    public static final String[] POLAR_TO_RECT = new String[]{"uniform sampler2DRect texture;", "uniform vec2 center;", "uniform float radians_per_px;", "uniform float maxRadius_div_h;", "uniform float interp;", "", "void main(void)", "{", "\tfloat sPolar = gl_TexCoord[0].s;", "\tfloat tPolar = gl_TexCoord[0].t;", "", "\tfloat theta = (sPolar - center.s) * radians_per_px;", "\tfloat sRect = maxRadius_div_h*tPolar*cos(theta) + center.s;", "\tfloat tRect = maxRadius_div_h*tPolar*sin(theta) + center.t;", "", "\tfloat s = interp*sRect + (1.0-interp)*sPolar;", "\tfloat t = interp*tRect + (1.0-interp)*tPolar;", "\tgl_FragColor = texture2DRect(texture, vec2(s, t));", "}"};
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram rectToPolarProgram;
    private final IShaderProgram polarToRectProgram;
    @Property(min="0", max="100")
    private IAnimatableDouble interpolation;
    @Property
    private IAnimatableEnum<TypeOfConversion> typeOfConversion;

    @Inject
    public PolarCoordinates(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.rectToPolarProgram = shaders.getProgram(PolarCoordinates.class, "RECT_TO_POLAR");
        this.polarToRectProgram = shaders.getProgram(PolarCoordinates.class, "POLAR_TO_RECT");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds bounds = input.getBounds();
        if (bounds.isEmpty()) {
            return input;
        }
        double interp = (Double)this.context.value((IAnimatableValue)this.interpolation);
        if (interp == 0.0) {
            return input;
        }
        TypeOfConversion type = (TypeOfConversion)((Object)this.context.value(this.typeOfConversion));
        IShaderProgram program = type == TypeOfConversion.RECT_TO_POLAR ? this.rectToPolarProgram : this.polarToRectProgram;
        int w = bounds.width;
        int h = bounds.height;
        try {
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("center", 2, FloatBuffer.wrap(new float[]{(float)w / 2.0f, (float)h / 2.0f})));
            uniforms.add(new GLUniformData("radians_per_px", (float)Math.toRadians(360.0 / (double)w)));
            if (type == TypeOfConversion.POLAR_TO_RECT) {
                uniforms.add(new GLUniformData("maxRadius_div_h", (float)(Math.sqrt(w * w + h * h) * 0.5 / (double)h)));
            }
            uniforms.add(new GLUniformData("interp", (float)(interp / 100.0)));
            input.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(program, uniforms, null, new IVideoBuffer[]{input});
            return iVideoBuffer;
        }
        finally {
            input.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeOfConversion {
        RECT_TO_POLAR,
        POLAR_TO_RECT;

    }
}

