/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.effects.Texture1D;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Effect(id="ch.kuramo.javie.Rectangle", category="ch.kuramo.javie.api.effectCategory.generate")
public class Rectangle {
    @Property
    private IAnimatableVec2d location;
    @Property(value="150", min="0")
    private IAnimatableVec2d size;
    @Property(value="0.5")
    private IAnimatableVec2d anchor;
    @Property
    private IAnimatableEnum<Edge> edge;
    @Property(value="10", min="0", max="4000")
    private IAnimatableDouble thickness;
    @Property(min="0", max="4000")
    private IAnimatableDouble outerFeather;
    @Property(min="0", max="4000")
    private IAnimatableDouble innerFeather;
    @Property
    private IAnimatableBoolean invert;
    @Property(value="1,1,1")
    private IAnimatableColor color;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableEnum<BlendMode> blendMode;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlendSupport blendSupport;
    private final IArrayPools arrayPools;
    private final IShaderProgram rectangleSamplerProgram;
    private final IShaderProgram invertSamplerProgram;
    @ShaderSource
    public static final String[] RECTANGLE_SAMPLER = Rectangle.createSamplerProgram(false);
    @ShaderSource
    public static final String[] INVERT_SAMPLER = Rectangle.createSamplerProgram(true);

    @Inject
    public Rectangle(IVideoEffectContext context, IVideoRenderSupport support, IBlendSupport blendSupport, IArrayPools arrayPools, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.blendSupport = blendSupport;
        this.arrayPools = arrayPools;
        this.rectangleSamplerProgram = shaders.getProgram(Rectangle.class, "RECTANGLE_SAMPLER");
        this.invertSamplerProgram = shaders.getProgram(Rectangle.class, "INVERT_SAMPLER");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer original;
        VideoBounds bounds;
        BlendMode blendMode = (BlendMode)this.context.value(this.blendMode);
        if (blendMode == BlendMode.NONE) {
            bounds = this.context.getPreviousBounds();
            original = this.context.createVideoBuffer(bounds);
        } else {
            original = this.context.doPreviousEffect();
            bounds = original.getBounds();
        }
        if (bounds.isEmpty()) {
            return original;
        }
        RectangleParams params = null;
        IVideoBuffer rectangle = null;
        try {
            final RectangleParams p = params = new RectangleParams();
            rectangle = this.context.createVideoBuffer(bounds);
            if (p.invert) {
                rectangle.clear(p.color);
            } else {
                rectangle.clear();
            }
            IShaderProgram program = p.invert ? this.invertSamplerProgram : this.rectangleSamplerProgram;
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texInnerX", 0));
            uniforms.add(new GLUniformData("texInnerY", 1));
            uniforms.add(new GLUniformData("texOuter", 2));
            uniforms.add(new GLUniformData("texSize", 4, FloatBuffer.wrap(new float[]{p.texSize[0], p.texSize[1], p.texSize[2], p.texSize[2]})));
            uniforms.add(new GLUniformData("texOffset", 4, FloatBuffer.wrap(new float[]{(float)((double)p.texSize[0] * 0.5 - p.innerMiddleX), (float)((double)p.texSize[1] * 0.5 - p.innerMiddleY), (float)((double)p.texSize[2] * 0.5 - p.outerMiddleX), (float)((double)p.texSize[2] * 0.5 - p.outerMiddleY)})));
            uniforms.add(new GLUniformData("center", 2, FloatBuffer.wrap(new float[]{(float)(((RectangleParams)p).center.x - bounds.x), (float)(((RectangleParams)p).center.y - bounds.y)})));
            uniforms.add(new GLUniformData("color", 4, FloatBuffer.wrap(new float[]{(float)((RectangleParams)p).color.r, (float)((RectangleParams)p).color.g, (float)((RectangleParams)p).color.b, (float)((RectangleParams)p).color.a})));
            Runnable operation = new Runnable(){

                public void run() {
                    GL2 gl = Rectangle.this.context.getGL().getGL2();
                    Rectangle.this.support.ortho2D(bounds);
                    gl.glMatrixMode(5888);
                    gl.glTranslatef((float)((RectangleParams)p).center.x, (float)((RectangleParams)p).center.y, 0.0f);
                    gl.glActiveTexture(33984);
                    gl.glBindTexture(3552, p.texture[0]);
                    gl.glActiveTexture(33985);
                    gl.glBindTexture(3552, p.texture[1]);
                    gl.glActiveTexture(33986);
                    gl.glBindTexture(3552, p.texture[2]);
                    double halfWidth = p.halfWidth + 2.0;
                    double halfHeight = p.halfHeight + 2.0;
                    Rectangle.this.support.quad2D(-halfWidth, -halfHeight, halfWidth, halfHeight, (double[][][])new double[0][][]);
                }
            };
            this.support.useShaderProgram(program, uniforms, operation, 262144, rectangle, new IVideoBuffer[0]);
            if (blendMode == BlendMode.NONE && p.opacity == 1.0) {
                IVideoBuffer result = rectangle;
                rectangle = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            IVideoBuffer iVideoBuffer = this.blendSupport.blend(rectangle, original, null, blendMode, p.opacity, this.context);
            return iVideoBuffer;
        }
        finally {
            if (original != null) {
                original.dispose();
            }
            if (rectangle != null) {
                rectangle.dispose();
            }
            if (params != null) {
                this.deleteTextures(params.texture);
            }
        }
    }

    private int[] createRectangleTextures(double innerMiddleX, double innerMiddleY, double innerFeather, double outerFeather, int[] texSize) {
        int[] nArray;
        IArray<float[]> data2;
        IArray<float[]> data1;
        int tex2;
        int tex1;
        int tex0;
        block17: {
            tex0 = 0;
            tex1 = 0;
            tex2 = 0;
            IArray<float[]> data0 = null;
            data1 = null;
            data2 = null;
            try {
                if (innerMiddleX <= 0.0 && innerFeather == 0.0) {
                    tex0 = Texture1D.fromArray(new float[]{0.0f, 0.0f}, this.context);
                    texSize[0] = 2;
                } else {
                    data0 = this.createRectangleData(innerFeather);
                    tex0 = Texture1D.fromArray(data0, this.context);
                    texSize[0] = data0.getLength();
                }
                if (innerMiddleY <= 0.0 && innerFeather == 0.0) {
                    tex1 = Texture1D.fromArray(new float[]{0.0f, 0.0f}, this.context);
                    texSize[1] = 2;
                } else {
                    data1 = this.createRectangleData(innerFeather);
                    tex1 = Texture1D.fromArray(data1, this.context);
                    texSize[1] = data1.getLength();
                }
                data2 = this.createRectangleData(outerFeather);
                tex2 = Texture1D.fromArray(data2, this.context);
                texSize[2] = data2.getLength();
                int[] result = new int[]{tex0, tex1, tex2};
                tex2 = 0;
                tex1 = 0;
                tex0 = 0;
                nArray = result;
                if (data0 == null) break block17;
            }
            catch (Throwable throwable) {
                if (data0 != null) {
                    data0.release();
                }
                if (data1 != null) {
                    data1.release();
                }
                if (data2 != null) {
                    data2.release();
                }
                if (tex0 != 0) {
                    this.deleteTextures(tex0);
                }
                if (tex1 != 0) {
                    this.deleteTextures(tex1);
                }
                if (tex2 != 0) {
                    this.deleteTextures(tex2);
                }
                throw throwable;
            }
            data0.release();
        }
        if (data1 != null) {
            data1.release();
        }
        if (data2 != null) {
            data2.release();
        }
        if (tex0 != 0) {
            this.deleteTextures(tex0);
        }
        if (tex1 != 0) {
            this.deleteTextures(tex1);
        }
        if (tex2 != 0) {
            this.deleteTextures(tex2);
        }
        return nArray;
    }

    private IArray<float[]> createRectangleData(double feather) {
        int halfLen = (int)Math.ceil(feather) + 1;
        IArray data = this.arrayPools.getFloatArray(halfLen * 2);
        float[] array = (float[])data.getArray();
        int arrayLen = data.getLength();
        int i = 0;
        while (i < arrayLen) {
            double r = (double)i + 0.5;
            double d = r <= (double)halfLen - feather ? 1.0 : (r >= (double)halfLen + feather ? 0.0 : 0.5 * (1.0 - Math.cos(Math.PI * 2 * (r - ((double)halfLen + feather)) / (4.0 * feather))));
            array[i] = (float)d;
            ++i;
        }
        return data;
    }

    private void deleteTextures(int ... texture) {
        GL2 gl = this.context.getGL().getGL2();
        gl.glDeleteTextures(texture.length, texture, 0);
    }

    private static final String[] createSamplerProgram(boolean invert) {
        return new String[]{"uniform sampler1D texInnerX;", "uniform sampler1D texInnerY;", "uniform sampler1D texOuter;", "uniform vec4 texSize;", "uniform vec4 texOffset;", "uniform vec2 center;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec2 delta = abs(gl_FragCoord.st - center);", "\tvec4 texCoord = (vec4(delta, delta) + texOffset) / texSize;", "", "\tfloat a0 = texture1D(texInnerX, texCoord.x).a;", "\tfloat a1 = texture1D(texInnerY, texCoord.y).a;", "\tfloat a2 = texture1D(texOuter, texCoord.z).a;", "\tfloat a3 = texture1D(texOuter, texCoord.w).a;", "", invert ? "\tgl_FragColor = color * (1.0 - (1.0-a0*a1)*(a2*a3));" : "\tgl_FragColor = color * (1.0-a0*a1)*(a2*a3);", "}"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Edge {
        NONE,
        THICKNESS,
        P_THICKNESS,
        P_THICKNESS_P_FEATHER;

    }

    private class RectangleParams {
        private final Vec2d center;
        private final boolean invert;
        private final Color color;
        private final double opacity;
        private final double halfWidth;
        private final double halfHeight;
        private final double innerMiddleX;
        private final double innerMiddleY;
        private final double outerMiddleX;
        private final double outerMiddleY;
        private final int[] texture;
        private final int[] texSize = new int[3];

        private RectangleParams() {
            Resolution resolution = Rectangle.this.context.getVideoResolution();
            Vec2d location = (Vec2d)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.location);
            Vec2d size = (Vec2d)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.size);
            Vec2d anchor = (Vec2d)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.anchor);
            double halfDiag = Math.sqrt(size.x * size.x + size.y * size.y) * 0.5;
            this.center = resolution.scale(new Vec2d(location.x - size.x * (anchor.x - 0.5), location.y - size.y * (anchor.y - 0.5)));
            size = resolution.scale(size);
            Edge edge = (Edge)((Object)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.edge));
            this.invert = (Boolean)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.invert);
            this.opacity = (Double)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.opacity) / 100.0;
            Color color = ((Color)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.color)).clamp();
            double a = color.a;
            this.color = new Color(color.r * a, color.g * a, color.b * a, a);
            double thickness = 0.0;
            double innerFeather = 0.0;
            double outerFeather = 0.0;
            switch (edge) {
                case NONE: {
                    outerFeather = resolution.scale(((Double)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.outerFeather)).doubleValue());
                    break;
                }
                case THICKNESS: {
                    thickness = resolution.scale(((Double)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.thickness)).doubleValue());
                    innerFeather = resolution.scale(((Double)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.innerFeather)).doubleValue());
                    outerFeather = resolution.scale(((Double)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.outerFeather)).doubleValue());
                    break;
                }
                case P_THICKNESS: {
                    thickness = resolution.scale(((Double)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.thickness)).doubleValue()) * halfDiag / 100.0;
                    innerFeather = resolution.scale(((Double)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.innerFeather)).doubleValue());
                    outerFeather = resolution.scale(((Double)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.outerFeather)).doubleValue());
                    break;
                }
                case P_THICKNESS_P_FEATHER: {
                    thickness = resolution.scale(((Double)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.thickness)).doubleValue()) * halfDiag / 100.0;
                    innerFeather = resolution.scale(((Double)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.innerFeather)).doubleValue()) * halfDiag / 100.0;
                    outerFeather = resolution.scale(((Double)Rectangle.this.context.value((IAnimatableValue)Rectangle.this.outerFeather)).doubleValue()) * halfDiag / 100.0;
                }
            }
            switch (edge) {
                case NONE: {
                    this.halfWidth = size.x * 0.5 + outerFeather;
                    this.halfHeight = size.y * 0.5 + outerFeather;
                    this.innerMiddleX = 0.0;
                    this.innerMiddleY = 0.0;
                    this.outerMiddleX = size.x * 0.5;
                    this.outerMiddleY = size.y * 0.5;
                    break;
                }
                default: {
                    this.halfWidth = size.x * 0.5 + thickness * 0.5 + outerFeather;
                    this.halfHeight = size.y * 0.5 + thickness * 0.5 + outerFeather;
                    this.innerMiddleX = size.x * 0.5 - thickness * 0.5;
                    this.innerMiddleY = size.y * 0.5 - thickness * 0.5;
                    this.outerMiddleX = size.x * 0.5 + thickness * 0.5;
                    this.outerMiddleY = size.y * 0.5 + thickness * 0.5;
                }
            }
            this.texture = Rectangle.this.createRectangleTextures(this.innerMiddleX, this.innerMiddleY, innerFeather, outerFeather, this.texSize);
        }
    }
}

